/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers.prefixTree.map;

import com.intellij.util.containers.prefixTree.PrefixTreeFactory;
import com.intellij.util.containers.prefixTree.PrefixTreeImpl;
import com.intellij.util.containers.prefixTree.map.AbstractPrefixTreeMap;
import com.intellij.util.containers.prefixTree.map.MutablePrefixTreeMap;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010&\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0002\b\u0001\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u0002*\u0004\b\u0002\u0010\u00032\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u00042\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0005B\u001b\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\u0016\u001a\u0004\u0018\u00018\u00022\u0006\u0010\u0017\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u0018J\u001d\u0010\u0019\u001a\u00028\u00022\u0006\u0010\u0017\u001a\u00028\u00002\u0006\u0010\u001a\u001a\u00028\u0002H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u001f\u0010\u001c\u001a\u0004\u0018\u00018\u00022\u0006\u0010\u0017\u001a\u00028\u00002\u0006\u0010\u001d\u001a\u00028\u0002H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u0017\u0010\u001e\u001a\u0004\u0018\u00018\u00022\u0006\u0010\u0017\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0018J\u0015\u0010\u001f\u001a\u00020 2\u0006\u0010\u0017\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010!J'\u0010\"\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00020\u00130\u00122\u0006\u0010\u0017\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010#J'\u0010$\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00020\u00130\u00122\u0006\u0010\u0017\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010#J\u001a\u0010%\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00020\u00130\u0012H\u0016J\u0017\u0010&\u001a\b\u0012\u0004\u0012\u00028\u00010'*\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010(R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\n\u001a\u001a\u0012\u0004\u0012\u00028\u0001\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R&\u0010\u0011\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00020\u00130\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006)"}, d2={"Lcom/intellij/util/containers/prefixTree/map/PrefixTreeMapImpl;", "Key", "KeyElement", "Value", "Lcom/intellij/util/containers/prefixTree/map/AbstractPrefixTreeMap;", "Lcom/intellij/util/containers/prefixTree/map/MutablePrefixTreeMap;", "convertor", "Lcom/intellij/util/containers/prefixTree/PrefixTreeFactory;", "<init>", "(Lcom/intellij/util/containers/prefixTree/PrefixTreeFactory;)V", "tree", "Lcom/intellij/util/containers/prefixTree/PrefixTreeImpl;", "Ljava/util/AbstractMap$SimpleEntry;", "size", "", "getSize", "()I", "entries", "", "", "getEntries", "()Ljava/util/Set;", "get", "key", "(Ljava/lang/Object;)Ljava/lang/Object;", "getOrDefault", "defaultValue", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "put", "value", "remove", "containsKey", "", "(Ljava/lang/Object;)Z", "getDescendantEntries", "(Ljava/lang/Object;)Ljava/util/Set;", "getAncestorEntries", "getRootEntries", "toList", "", "(Ljava/lang/Object;)Ljava/util/List;", "intellij.platform.util.base"})
@ApiStatus.Internal
public final class PrefixTreeMapImpl<Key, KeyElement, Value>
extends AbstractPrefixTreeMap<Key, Value>
implements MutablePrefixTreeMap<Key, Value> {
    @NotNull
    private final PrefixTreeFactory<Key, KeyElement> convertor;
    @NotNull
    private final PrefixTreeImpl<KeyElement, AbstractMap.SimpleEntry<Key, Value>> tree;

    public PrefixTreeMapImpl(@NotNull PrefixTreeFactory<Key, KeyElement> convertor) {
        Intrinsics.checkNotNullParameter(convertor, "convertor");
        this.convertor = convertor;
        this.tree = new PrefixTreeImpl();
    }

    @Override
    public int getSize() {
        return this.tree.size();
    }

    @Override
    @NotNull
    public Set<Map.Entry<Key, Value>> getEntries() {
        return CollectionsKt.toSet(this.tree.values());
    }

    @Override
    @Nullable
    public Value get(Object key) {
        AbstractMap.SimpleEntry<Key, Value> simpleEntry = this.tree.get((Object)this.toList(key));
        return (Value)(simpleEntry != null ? simpleEntry.getValue() : null);
    }

    @Override
    public Value getOrDefault(Object key, Value defaultValue) {
        return this.tree.getOrDefault((Object)this.toList(key), (AbstractMap.SimpleEntry<Key, AbstractMap.SimpleEntry<Object, Value>>)new AbstractMap.SimpleEntry<Object, Value>(key, defaultValue)).getValue();
    }

    @Override
    @Nullable
    public Value put(Key key, Value value) {
        AbstractMap.SimpleEntry<Key, Value> simpleEntry = this.tree.put(this.toList(key), new AbstractMap.SimpleEntry<Key, Value>(key, value));
        return (Value)(simpleEntry != null ? simpleEntry.getValue() : null);
    }

    @Override
    @Nullable
    public Value remove(Key key) {
        AbstractMap.SimpleEntry<Key, Value> simpleEntry = this.tree.remove(this.toList(key));
        return (Value)(simpleEntry != null ? simpleEntry.getValue() : null);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.tree.containsKey((Object)this.toList(key));
    }

    @Override
    @NotNull
    public Set<Map.Entry<Key, Value>> getDescendantEntries(Key key) {
        return CollectionsKt.toSet(this.tree.getDescendantValues(this.toList(key)));
    }

    @Override
    @NotNull
    public Set<Map.Entry<Key, Value>> getAncestorEntries(Key key) {
        return CollectionsKt.toSet(this.tree.getAncestorValues(this.toList(key)));
    }

    @Override
    @NotNull
    public Set<Map.Entry<Key, Value>> getRootEntries() {
        return CollectionsKt.toSet(this.tree.getRootValues());
    }

    private final List<KeyElement> toList(Key $this$toList) {
        return this.convertor.convertToList($this$toList);
    }
}

