/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.DescribeClientQuotasRequestData;
import org.apache.kafka.common.message.DescribeClientQuotasResponseData;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.image.ClientQuotaImage;
import org.apache.kafka.image.node.ClientQuotasImageNode;
import org.apache.kafka.image.writer.ImageWriter;

public record ClientQuotasImage(Map<ClientQuotaEntity, ClientQuotaImage> entities) {
    public static final ClientQuotasImage EMPTY = new ClientQuotasImage(Map.of());

    public ClientQuotasImage(Map<ClientQuotaEntity, ClientQuotaImage> entities) {
        this.entities = Collections.unmodifiableMap(entities);
    }

    public boolean isEmpty() {
        return this.entities.isEmpty();
    }

    public void write(ImageWriter writer) {
        for (Map.Entry<ClientQuotaEntity, ClientQuotaImage> entry : this.entities.entrySet()) {
            ClientQuotaEntity entity = entry.getKey();
            ClientQuotaImage clientQuotaImage = entry.getValue();
            clientQuotaImage.write(entity, writer);
        }
    }

    public DescribeClientQuotasResponseData describe(DescribeClientQuotasRequestData request) {
        DescribeClientQuotasResponseData response = new DescribeClientQuotasResponseData();
        HashMap<String, String> exactMatch = new HashMap<String, String>();
        HashSet<String> typeMatch = new HashSet<String>();
        block5: for (DescribeClientQuotasRequestData.ComponentData componentData : request.components()) {
            if (componentData.entityType().isEmpty()) {
                throw new InvalidRequestException("Invalid empty entity type.");
            }
            if (exactMatch.containsKey(componentData.entityType()) || typeMatch.contains(componentData.entityType())) {
                throw new InvalidRequestException("Entity type " + componentData.entityType() + " cannot appear more than once in the filter.");
            }
            if (!(componentData.entityType().equals("ip") || componentData.entityType().equals("user") || componentData.entityType().equals("client-id"))) {
                throw new UnsupportedVersionException("Unsupported entity type " + componentData.entityType());
            }
            switch (componentData.matchType()) {
                case 0: {
                    if (componentData.match() == null) {
                        throw new InvalidRequestException("Request specified MATCH_TYPE_EXACT, but set match string to null.");
                    }
                    exactMatch.put(componentData.entityType(), componentData.match());
                    continue block5;
                }
                case 1: {
                    if (componentData.match() != null) {
                        throw new InvalidRequestException("Request specified MATCH_TYPE_DEFAULT, but also specified a match string.");
                    }
                    exactMatch.put(componentData.entityType(), null);
                    continue block5;
                }
                case 2: {
                    if (componentData.match() != null) {
                        throw new InvalidRequestException("Request specified MATCH_TYPE_SPECIFIED, but also specified a match string.");
                    }
                    typeMatch.add(componentData.entityType());
                    continue block5;
                }
            }
            throw new InvalidRequestException("Unknown match type " + componentData.matchType());
        }
        if ((exactMatch.containsKey("ip") || typeMatch.contains("ip")) && (exactMatch.containsKey("user") || typeMatch.contains("user") || exactMatch.containsKey("client-id") || typeMatch.contains("client-id"))) {
            throw new InvalidRequestException("Invalid entity filter component combination. IP filter component should not be used with user or clientId filter component.");
        }
        for (Map.Entry entry : this.entities.entrySet()) {
            ClientQuotaEntity entity = (ClientQuotaEntity)entry.getKey();
            ClientQuotaImage quotaImage = (ClientQuotaImage)entry.getValue();
            if (!ClientQuotasImage.matches(entity, exactMatch, typeMatch, request.strict())) continue;
            response.entries().add(ClientQuotasImage.toDescribeEntry(entity, quotaImage));
        }
        return response;
    }

    private static boolean matches(ClientQuotaEntity entity, Map<String, String> exactMatch, Set<String> typeMatch, boolean strict) {
        if (strict && entity.entries().size() != exactMatch.size() + typeMatch.size()) {
            return false;
        }
        for (Map.Entry<String, String> entry : exactMatch.entrySet()) {
            if (!entity.entries().containsKey(entry.getKey())) {
                return false;
            }
            if (Objects.equals(entity.entries().get(entry.getKey()), entry.getValue())) continue;
            return false;
        }
        for (String type : typeMatch) {
            if (entity.entries().containsKey(type)) continue;
            return false;
        }
        return true;
    }

    private static DescribeClientQuotasResponseData.EntryData toDescribeEntry(ClientQuotaEntity entity, ClientQuotaImage quotaImage) {
        DescribeClientQuotasResponseData.EntryData data = new DescribeClientQuotasResponseData.EntryData();
        for (Map.Entry entry : entity.entries().entrySet()) {
            data.entity().add(new DescribeClientQuotasResponseData.EntityData().setEntityType((String)entry.getKey()).setEntityName((String)entry.getValue()));
        }
        data.setValues(quotaImage.toDescribeValues());
        return data;
    }

    @Override
    public String toString() {
        return new ClientQuotasImageNode(this).stringify();
    }
}

