/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.PartitionChangeRecord;
import org.apache.kafka.common.metadata.PartitionRecord;
import org.apache.kafka.image.LocalReplicaChanges;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.metadata.Replicas;

public final class TopicDelta {
    private final TopicImage image;
    private final Map<Integer, PartitionRegistration> partitionChanges = new HashMap<Integer, PartitionRegistration>();
    private final Map<Integer, Integer> partitionToUncleanLeaderElectionCount = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> partitionToElrElectionCount = new HashMap<Integer, Integer>();

    public TopicDelta(TopicImage image) {
        this.image = image;
    }

    public TopicImage image() {
        return this.image;
    }

    public Map<Integer, PartitionRegistration> partitionChanges() {
        return this.partitionChanges;
    }

    public Map<Integer, PartitionRegistration> newPartitions() {
        return this.partitionChanges.entrySet().stream().filter(entry -> !this.image.partitions().containsKey(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public String name() {
        return this.image.name();
    }

    public Uuid id() {
        return this.image.id();
    }

    public Map<Integer, Integer> partitionToElrElectionCount() {
        return this.partitionToElrElectionCount;
    }

    public Map<Integer, Integer> partitionToUncleanLeaderElectionCount() {
        return this.partitionToUncleanLeaderElectionCount;
    }

    public void replay(PartitionRecord record) {
        int partitionId = record.partitionId();
        PartitionRegistration prevPartition = this.partitionChanges.get(partitionId);
        if (prevPartition == null) {
            prevPartition = this.image.partitions().get(partitionId);
        }
        if (prevPartition != null) {
            this.updateElectionStats(partitionId, prevPartition, record.leader(), record.leaderRecoveryState());
        }
        this.partitionChanges.put(record.partitionId(), new PartitionRegistration(record));
    }

    public void replay(PartitionChangeRecord record) {
        int partitionId = record.partitionId();
        PartitionRegistration prevPartition = this.partitionChanges.get(partitionId);
        if (prevPartition == null && (prevPartition = this.image.partitions().get(partitionId)) == null) {
            throw new RuntimeException("Unable to find partition " + String.valueOf(record.topicId()) + ":" + partitionId);
        }
        this.updateElectionStats(partitionId, prevPartition, record.leader(), record.leaderRecoveryState());
        this.partitionChanges.put(record.partitionId(), prevPartition.merge(record));
    }

    private void updateElectionStats(int partitionId, PartitionRegistration prevPartition, int newLeader, byte newLeaderRecoveryState) {
        if (PartitionRegistration.electionWasUnclean(newLeaderRecoveryState)) {
            this.partitionToUncleanLeaderElectionCount.put(partitionId, this.partitionToUncleanLeaderElectionCount.getOrDefault(partitionId, 0) + 1);
        }
        if (Replicas.contains(prevPartition.elr, newLeader)) {
            this.partitionToElrElectionCount.put(partitionId, this.partitionToElrElectionCount.getOrDefault(partitionId, 0) + 1);
        }
    }

    public void replay() {
        this.partitionChanges.forEach(this::maybeClearElr);
        this.image.partitions().forEach((partitionId, partition) -> {
            if (!this.partitionChanges.containsKey(partitionId)) {
                this.maybeClearElr((int)partitionId, (PartitionRegistration)partition);
            }
        });
    }

    void maybeClearElr(int partitionId, PartitionRegistration partition) {
        if (partition.elr.length != 0 || partition.lastKnownElr.length != 0) {
            this.partitionChanges.put(partitionId, partition.merge(new PartitionChangeRecord().setPartitionId(partitionId).setTopicId(this.image.id()).setEligibleLeaderReplicas(List.of()).setLastKnownElr(List.of())));
        }
    }

    public TopicImage apply() {
        HashMap<Integer, PartitionRegistration> newPartitions = new HashMap<Integer, PartitionRegistration>();
        for (Map.Entry<Integer, PartitionRegistration> entry : this.image.partitions().entrySet()) {
            int partitionId = entry.getKey();
            PartitionRegistration changedPartition = this.partitionChanges.get(partitionId);
            if (changedPartition == null) {
                newPartitions.put(partitionId, entry.getValue());
                continue;
            }
            newPartitions.put(partitionId, changedPartition);
        }
        for (Map.Entry<Integer, PartitionRegistration> entry : this.partitionChanges.entrySet()) {
            if (newPartitions.containsKey(entry.getKey())) continue;
            newPartitions.put(entry.getKey(), entry.getValue());
        }
        return new TopicImage(this.image.name(), this.image.id(), newPartitions);
    }

    public LocalReplicaChanges localChanges(int brokerId) {
        HashSet<TopicPartition> deletes = new HashSet<TopicPartition>();
        HashMap<TopicPartition, LocalReplicaChanges.PartitionInfo> electedLeaders = new HashMap<TopicPartition, LocalReplicaChanges.PartitionInfo>();
        HashMap<TopicPartition, LocalReplicaChanges.PartitionInfo> leaders = new HashMap<TopicPartition, LocalReplicaChanges.PartitionInfo>();
        HashMap<TopicPartition, LocalReplicaChanges.PartitionInfo> followers = new HashMap<TopicPartition, LocalReplicaChanges.PartitionInfo>();
        HashMap<String, Uuid> topicIds = new HashMap<String, Uuid>();
        HashMap<TopicIdPartition, Uuid> directoryIds = new HashMap<TopicIdPartition, Uuid>();
        for (Map.Entry<Integer, PartitionRegistration> entry : this.partitionChanges.entrySet()) {
            PartitionRegistration prevPartition;
            if (!Replicas.contains(entry.getValue().replicas, brokerId)) {
                prevPartition = this.image.partitions().get(entry.getKey());
                if (prevPartition != null && Replicas.contains(prevPartition.replicas, brokerId)) {
                    deletes.add(new TopicPartition(this.name(), entry.getKey().intValue()));
                }
            } else if (entry.getValue().leader == brokerId) {
                prevPartition = this.image.partitions().get(entry.getKey());
                if (prevPartition == null || prevPartition.partitionEpoch != entry.getValue().partitionEpoch) {
                    TopicPartition tp = new TopicPartition(this.name(), entry.getKey().intValue());
                    LocalReplicaChanges.PartitionInfo partitionInfo = new LocalReplicaChanges.PartitionInfo(this.id(), entry.getValue());
                    leaders.put(tp, partitionInfo);
                    if (prevPartition == null || prevPartition.leaderEpoch != entry.getValue().leaderEpoch) {
                        electedLeaders.put(tp, partitionInfo);
                    }
                    topicIds.putIfAbsent(this.name(), this.id());
                }
            } else {
                prevPartition = this.image.partitions().get(entry.getKey());
                if (prevPartition == null || prevPartition.partitionEpoch != entry.getValue().partitionEpoch) {
                    followers.put(new TopicPartition(this.name(), entry.getKey().intValue()), new LocalReplicaChanges.PartitionInfo(this.id(), entry.getValue()));
                    topicIds.putIfAbsent(this.name(), this.id());
                }
            }
            try {
                prevPartition = this.image.partitions().get(entry.getKey());
                if (prevPartition != null && prevPartition.directory(brokerId) == entry.getValue().directory(brokerId)) continue;
                directoryIds.put(new TopicIdPartition(this.id(), new TopicPartition(this.name(), entry.getKey().intValue())), entry.getValue().directory(brokerId));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return new LocalReplicaChanges(deletes, electedLeaders, leaders, followers, topicIds, directoryIds);
    }

    public String toString() {
        return "TopicDelta(partitionChanges=" + String.valueOf(this.partitionChanges) + ")";
    }
}

