/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.message.StreamsGroupHeartbeatResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractResponse;

public class StreamsGroupHeartbeatResponse
extends AbstractResponse {
    private final StreamsGroupHeartbeatResponseData data;

    public StreamsGroupHeartbeatResponse(StreamsGroupHeartbeatResponseData data) {
        super(ApiKeys.STREAMS_GROUP_HEARTBEAT);
        this.data = data;
    }

    @Override
    public StreamsGroupHeartbeatResponseData data() {
        return this.data;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return Collections.singletonMap(Errors.forCode(this.data.errorCode()), 1);
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    public static StreamsGroupHeartbeatResponse parse(Readable readable, short version) {
        return new StreamsGroupHeartbeatResponse(new StreamsGroupHeartbeatResponseData(readable, version));
    }

    public static enum Status {
        STALE_TOPOLOGY(0, "The topology epoch supplied is inconsistent with the topology for this streams group."),
        MISSING_SOURCE_TOPICS(1, "One or more source topics are missing or a source topic regex resolves to zero topics."),
        INCORRECTLY_PARTITIONED_TOPICS(2, "One or more topics expected to be copartitioned are not copartitioned."),
        MISSING_INTERNAL_TOPICS(3, "One or more internal topics are missing."),
        SHUTDOWN_APPLICATION(4, "A client requested the shutdown of the whole application."),
        ASSIGNMENT_DELAYED(5, "The assignment was delayed by the coordinator.");

        private static final Map<Byte, Status> CODE_TO_STATUS;
        private final byte code;
        private final String message;

        private Status(byte code, String message) {
            this.code = code;
            this.message = message;
        }

        public byte code() {
            return this.code;
        }

        public String message() {
            return this.message;
        }

        public static Status fromCode(byte code) {
            Status status = CODE_TO_STATUS.get(code);
            if (status == null) {
                throw new IllegalArgumentException("Unknown code " + code);
            }
            return status;
        }

        static {
            HashMap<Byte, Status> map = new HashMap<Byte, Status>();
            for (Status status : Status.values()) {
                map.put(status.code, status);
            }
            CODE_TO_STATUS = Collections.unmodifiableMap(map);
        }
    }
}

