/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.image;

import java.awt.AWTException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.VisibleForTesting;
import org.assertj.swing.annotation.RunsInEDT;
import org.assertj.swing.core.FocusOwnerFinder;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;
import org.assertj.swing.edt.GuiActionRunner;
import org.assertj.swing.image.ImageException;
import org.assertj.swing.image.ImageFileWriter;
import org.assertj.swing.image.ScreenshotTakerIF;
import org.assertj.swing.internal.annotation.IORuntimeException;
import org.assertj.swing.query.ComponentLocationOnScreenQuery;
import org.assertj.swing.query.ComponentSizeQuery;
import org.assertj.swing.util.RobotFactory;

public class ScreenshotTaker
implements ScreenshotTakerIF {
    private final Robot robot;
    private final ImageFileWriter writer;

    public ScreenshotTaker() {
        this(new ImageFileWriter(), new RobotFactory());
    }

    @VisibleForTesting
    ScreenshotTaker(@Nonnull ImageFileWriter writer, @Nonnull RobotFactory robotFactory) {
        this.writer = writer;
        try {
            this.robot = robotFactory.newRobotInLeftScreen();
        }
        catch (AWTException e) {
            throw new ImageException("Unable to create AWT Robot", e);
        }
    }

    @Override
    public void saveDesktopAsPng(String imageFilePath) {
        this.saveImage(this.takeDesktopScreenshot(), imageFilePath);
    }

    @Override
    public BufferedImage takeDesktopScreenshot() {
        Rectangle r = new Rectangle(Toolkit.getDefaultToolkit().getScreenSize());
        return this.takeScreenshot(r);
    }

    @Override
    public void saveComponentAsPng(@Nonnull Component c, @Nonnull String imageFilePath) {
        this.saveImage(this.takeScreenshotOf(c), imageFilePath);
    }

    @Override
    @Nonnull
    public BufferedImage takeScreenshotOf(@Nonnull Component c) {
        Point locationOnScreen = ComponentLocationOnScreenQuery.locationOnScreen(c);
        Dimension size = ComponentSizeQuery.sizeOf(c);
        Rectangle r = new Rectangle(locationOnScreen.x, locationOnScreen.y, size.width, size.height);
        return this.takeScreenshot(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private BufferedImage takeScreenshot(Rectangle r) {
        JTextComponent textComponent = ScreenshotTaker.findFocusOwnerAndHideItsCaret();
        this.robot.waitForIdle();
        try {
            BufferedImage bufferedImage = ScreenshotTaker.takeScreenshot(this.robot, r);
            return bufferedImage;
        }
        finally {
            this.showCaretIfPossible(textComponent);
        }
    }

    @RunsInEDT
    private static JTextComponent findFocusOwnerAndHideItsCaret() {
        return GuiActionRunner.execute(() -> {
            Component focusOwner = FocusOwnerFinder.focusOwner();
            if (!(focusOwner instanceof JTextComponent)) {
                return null;
            }
            JTextComponent textComponent = (JTextComponent)focusOwner;
            Caret caret = textComponent.getCaret();
            if (caret == null || !caret.isVisible()) {
                return null;
            }
            caret.setVisible(false);
            return textComponent;
        });
    }

    @Nonnull
    private static BufferedImage takeScreenshot(@Nonnull Robot robot, @Nonnull Rectangle r) {
        BufferedImage result = GuiActionRunner.execute(() -> robot.createScreenCapture(r));
        return (BufferedImage)Preconditions.checkNotNull((Object)result);
    }

    private void showCaretIfPossible(@Nullable JTextComponent textComponent) {
        if (textComponent == null) {
            return;
        }
        ScreenshotTaker.showCaretOf(textComponent);
        this.robot.waitForIdle();
    }

    @RunsInEDT
    private static void showCaretOf(@Nonnull JTextComponent textComponent) {
        GuiActionRunner.execute(() -> {
            Caret caret = textComponent.getCaret();
            if (caret != null) {
                caret.setVisible(true);
            }
        });
    }

    @Override
    public void saveImage(@Nonnull BufferedImage image, @Nonnull String filePath) {
        Preconditions.checkNotNullOrEmpty((CharSequence)filePath);
        if (!filePath.endsWith("png")) {
            String format = String.format("The file in path '%s' should have extension 'png'", filePath);
            throw new IllegalArgumentException(format);
        }
        try {
            this.writer.writeAsPng(image, filePath);
        }
        catch (IOException e) {
            String msg = String.format("Unable to save image as '%s'", filePath);
            throw new IORuntimeException(msg, e);
        }
    }
}

