/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.convert;

import com.intellij.ide.highlighter.DTDFileType;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.io.File;
import org.intellij.plugins.relaxNG.RelaxngBundle;
import org.intellij.plugins.relaxNG.compact.RncFileType;
import org.intellij.plugins.relaxNG.convert.ConvertSchemaDialog;
import org.intellij.plugins.relaxNG.convert.ConvertSchemaSettings;
import org.intellij.plugins.relaxNG.convert.IdeaDriver;
import org.intellij.plugins.relaxNG.convert.IdeaErrorHandler;
import org.intellij.plugins.relaxNG.convert.SchemaType;
import org.intellij.plugins.relaxNG.validation.RngValidateHandler;
import org.jetbrains.annotations.NotNull;

public class ConvertSchemaAction
extends AnAction {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ConvertSchemaAction.$$$reportNull$$$0(0);
        }
        VirtualFile[] files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (files != null && project != null) {
            SchemaType type = ConvertSchemaAction.getInputType(project, files);
            e.getPresentation().setEnabled(type != null);
            if (type == SchemaType.XML) {
                e.getPresentation().setText(RelaxngBundle.message("relaxng.convert-schema.action.title.xml-files", files.length));
            } else {
                e.getPresentation().setText(RelaxngBundle.message("relaxng.convert-schema.action.title.non-xml", new Object[0]));
            }
        } else {
            e.getPresentation().setEnabled(false);
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ConvertSchemaAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    private static SchemaType getInputType(Project project, VirtualFile ... files) {
        if (files.length == 0) {
            return null;
        }
        VirtualFile file = files[0];
        FileType type = file.getFileType();
        if (type == XmlFileType.INSTANCE) {
            XmlDocument document;
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
            if (psiFile instanceof XmlFile && (document = ((XmlFile)psiFile).getDocument()) != null && document.getRootTag() != null) {
                XmlTag rootTag = document.getRootTag();
                assert (rootTag != null);
                String uri = rootTag.getNamespace();
                if ("http://relaxng.org/ns/structure/1.0".equals(uri) && files.length == 1) {
                    return SchemaType.RNG;
                }
            }
            if (files.length > 1) {
                for (VirtualFile virtualFile : files) {
                    if (FileTypeRegistry.getInstance().isFileOfType(virtualFile, (FileType)XmlFileType.INSTANCE) && ConvertSchemaAction.getInputType(project, virtualFile) == null) continue;
                    return null;
                }
            }
            return SchemaType.XML;
        }
        if (type == DTDFileType.INSTANCE && files.length == 1) {
            return SchemaType.DTD;
        }
        if (type == RncFileType.getInstance() && files.length == 1) {
            return SchemaType.RNC;
        }
        return null;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ConvertSchemaAction.$$$reportNull$$$0(2);
        }
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (file != null && project != null) {
            VirtualFile[] files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
            assert (files != null);
            SchemaType type = ConvertSchemaAction.getInputType(project, files);
            ConvertSchemaDialog dialog = new ConvertSchemaDialog(project, type, file);
            if (!dialog.showAndGet()) {
                return;
            }
            RngValidateHandler.saveFiles(files);
            ConvertSchemaSettings settings = dialog.getSettings();
            IdeaErrorHandler errorHandler = new IdeaErrorHandler(project);
            new IdeaDriver(settings, project).convert(type, errorHandler, files);
            VirtualFile output = LocalFileSystem.getInstance().findFileByIoFile(new File(settings.getOutputDestination()));
            if (output != null) {
                output.refresh(false, true);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/relaxNG/convert/ConvertSchemaAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/relaxNG/convert/ConvertSchemaAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

