/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.fs;

import java.io.IOException;
import java.nio.file.Path;
import org.jkiss.code.NotNull;

public final class DBFPath
implements AutoCloseable {
    private final Path path;
    private final boolean ownsFileSystem;

    private DBFPath(Path path, boolean ownsFileSystem) {
        this.path = path;
        this.ownsFileSystem = ownsFileSystem;
    }

    public static DBFPath create(@NotNull Path path) {
        return new DBFPath(path, false);
    }

    public static DBFPath createExclusive(@NotNull Path path) {
        return new DBFPath(path, true);
    }

    public Path path() {
        return this.path;
    }

    @Override
    public void close() throws IOException {
        if (this.ownsFileSystem) {
            this.path.getFileSystem().close();
        }
    }

    public String toString() {
        return this.path.toString();
    }
}

