/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.data.hints;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.data.hints.DBDValueHintContext;
import org.jkiss.dbeaver.model.data.hints.DBDValueHintProvider;
import org.jkiss.dbeaver.model.data.hints.standard.VoidHintProvider;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.virtual.DBVContainer;
import org.jkiss.dbeaver.model.virtual.DBVEntity;
import org.jkiss.dbeaver.model.virtual.DBVObject;
import org.jkiss.dbeaver.model.virtual.DBVUtils;
import org.jkiss.dbeaver.registry.data.hints.AbstractValueBindingRegistry;
import org.jkiss.dbeaver.registry.data.hints.ValueHintContextConfiguration;
import org.jkiss.dbeaver.registry.data.hints.ValueHintProviderConfiguration;
import org.jkiss.dbeaver.registry.data.hints.ValueHintProviderDescriptor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public class ValueHintRegistry
extends AbstractValueBindingRegistry<DBDValueHintProvider, DBDValueHintContext, ValueHintProviderDescriptor> {
    private static final Log log = Log.getLog(ValueHintRegistry.class);
    public static final String CONFIG_FILE_NAME = "data-hints.json";
    private static final Gson gson = new GsonBuilder().create();
    private static final String HINT_CONFIG_PROPERTY = "data.hints.configuration";
    private static ValueHintRegistry instance = null;
    private final List<ValueHintProviderDescriptor> descriptors = new ArrayList<ValueHintProviderDescriptor>();
    private final ValueHintContextConfiguration globalContextConfiguration;

    public static synchronized ValueHintRegistry getInstance() {
        if (instance == null) {
            instance = new ValueHintRegistry(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private ValueHintRegistry(IExtensionRegistry registry) {
        IConfigurationElement[] extElements;
        for (IConfigurationElement ext : extElements = registry.getConfigurationElementsFor("org.jkiss.dbeaver.dataHintProvider")) {
            if (!"hintProvider".equals(ext.getName())) continue;
            this.descriptors.add(new ValueHintProviderDescriptor(ext));
        }
        this.globalContextConfiguration = new GlobalHintContextConfiguration();
    }

    public List<ValueHintProviderDescriptor> getHintDescriptors() {
        return this.getDescriptors();
    }

    public List<ValueHintProviderDescriptor> getHintDescriptors(@NotNull DBDValueHintProvider.HintObject forObject) {
        return this.getDescriptors().stream().filter(d -> d.getForObject() == forObject).toList();
    }

    @Override
    @NotNull
    protected List<ValueHintProviderDescriptor> getDescriptors() {
        return this.descriptors;
    }

    @Override
    @NotNull
    protected DBDValueHintProvider getDefaultValueBinding() {
        return VoidHintProvider.INSTANCE;
    }

    public ValueHintContextConfiguration getContextConfiguration(@Nullable DBPDataSourceContainer ds, @Nullable DBSEntity entity, boolean forceCreate) {
        ValueHintContextConfiguration configuration;
        if (entity != null && (configuration = this.findHintConfigFromVirtualObject(DBVUtils.getVirtualEntity(entity, forceCreate), forceCreate)) != null) {
            return configuration;
        }
        if (ds != null && (configuration = this.findHintConfigFromVirtualObject(ds.getVirtualModel(), forceCreate)) != null) {
            return configuration;
        }
        return this.globalContextConfiguration;
    }

    public boolean isHintEnabled(@NotNull ValueHintProviderDescriptor descriptor, @Nullable DBPDataSourceContainer ds, @Nullable DBSEntity entity) {
        Boolean isEnabled;
        if (entity != null && (isEnabled = this.isHintEnabledInVirtualObject(descriptor, DBVUtils.getVirtualEntity(entity, false))) != null) {
            return isEnabled;
        }
        if (ds != null && (isEnabled = this.isHintEnabledInVirtualObject(descriptor, ds.getVirtualModel())) != null) {
            return isEnabled;
        }
        return this.globalContextConfiguration.isHintEnabled(descriptor);
    }

    private Boolean isHintEnabledInVirtualObject(ValueHintProviderDescriptor descriptor, DBVObject vObject) {
        Object isEnabled;
        Map<String, Object> provConfig;
        Map dataHintsConfig;
        if (vObject != null && (dataHintsConfig = (Map)vObject.getProperty(HINT_CONFIG_PROPERTY)) != null && (provConfig = JSONUtils.getObjectOrNull(dataHintsConfig, descriptor.getId())) != null && (isEnabled = provConfig.get("enabled")) != null) {
            return CommonUtils.toBoolean((Object)isEnabled);
        }
        return null;
    }

    private ValueHintContextConfiguration findHintConfigFromVirtualObject(@Nullable DBVObject vObject, boolean forceCreate) {
        Map dataHintsConfig;
        if (vObject != null && ((dataHintsConfig = (Map)vObject.getProperty(HINT_CONFIG_PROPERTY)) != null || forceCreate)) {
            return new VirtualHintContextConfiguration(vObject, vObject instanceof DBVEntity ? DBDValueHintContext.HintConfigurationLevel.ENTITY : DBDValueHintContext.HintConfigurationLevel.DATASOURCE);
        }
        return null;
    }

    public ValueHintProviderDescriptor getDescriptorByInstance(DBDValueHintProvider provider) {
        for (ValueHintProviderDescriptor descriptor : this.descriptors) {
            if (descriptor.getInstance() != provider) continue;
            return descriptor;
        }
        return null;
    }

    private static class GlobalHintContextConfiguration
    extends ValueHintContextConfiguration {
        public GlobalHintContextConfiguration() {
            super(DBDValueHintContext.HintConfigurationLevel.GLOBAL);
            try {
                String configContent = DBWorkbench.getPlatform().getConfigurationController().loadConfigurationFile(ValueHintRegistry.CONFIG_FILE_NAME);
                if (configContent != null) {
                    LinkedHashMap configurationMap = (LinkedHashMap)gson.fromJson(configContent, new TypeToken<Map<String, ValueHintProviderConfiguration>>(this){}.getType());
                    if (configurationMap == null) {
                        configurationMap = new LinkedHashMap();
                    }
                    this.setConfigurationMap(configurationMap);
                }
            }
            catch (Exception e) {
                log.error("Error loading hint providers configuration", e);
            }
        }

        @Override
        public ValueHintContextConfiguration getParent() {
            return null;
        }

        @Override
        public void saveConfiguration() {
            try {
                String json = gson.toJson(this.getConfigurationMap());
                DBWorkbench.getPlatform().getConfigurationController().saveConfigurationFile(ValueHintRegistry.CONFIG_FILE_NAME, json);
            }
            catch (DBException e) {
                log.error("Error saving hint providers configuration", e);
            }
        }

        @Override
        public void deleteConfiguration() {
            log.error("Global configuration cannot be deleted");
        }
    }

    private static class VirtualHintContextConfiguration
    extends ValueHintContextConfiguration {
        private final DBVObject vObject;

        public VirtualHintContextConfiguration(@NotNull DBVObject vObject, @NotNull DBDValueHintContext.HintConfigurationLevel level) {
            super(level);
            this.vObject = vObject;
            try {
                Map dataHintsConfig = (Map)vObject.getProperty(ValueHintRegistry.HINT_CONFIG_PROPERTY);
                if (dataHintsConfig != null) {
                    for (Map.Entry pc : dataHintsConfig.entrySet()) {
                        Object v = pc.getValue();
                        if (!(v instanceof Map)) continue;
                        Map map = (Map)v;
                        ValueHintProviderConfiguration configuration = JSONUtils.deserializeObject(map, ValueHintProviderConfiguration.class);
                        this.configurationMap.put((String)pc.getKey(), configuration);
                    }
                } else {
                    vObject.setProperty(ValueHintRegistry.HINT_CONFIG_PROPERTY, new LinkedHashMap());
                }
            }
            catch (Exception e) {
                log.debug("Error reading hints configuration", e);
            }
        }

        @Override
        public ValueHintContextConfiguration getParent() {
            if (this.vObject instanceof DBVContainer) {
                return ValueHintRegistry.getInstance().globalContextConfiguration;
            }
            return ValueHintRegistry.getInstance().getContextConfiguration(this.vObject.getDataSourceContainer(), null, false);
        }

        @Override
        public void saveConfiguration() {
            LinkedHashMap dataHintsConfig = new LinkedHashMap();
            for (Map.Entry hpc : this.configurationMap.entrySet()) {
                LinkedHashMap<String, Object> hpMap = new LinkedHashMap<String, Object>();
                hpMap.put("enabled", ((ValueHintProviderConfiguration)hpc.getValue()).isEnabled());
                hpMap.put("parameters", ((ValueHintProviderConfiguration)hpc.getValue()).getParameters());
                dataHintsConfig.put((String)hpc.getKey(), hpMap);
            }
            this.vObject.setProperty(ValueHintRegistry.HINT_CONFIG_PROPERTY, dataHintsConfig);
            this.persistConfiguration();
        }

        @Override
        public void deleteConfiguration() {
            this.vObject.setProperty(ValueHintRegistry.HINT_CONFIG_PROPERTY, null);
            this.persistConfiguration();
        }

        private void persistConfiguration() {
            DBPDataSourceContainer dataSourceContainer = this.vObject.getDataSourceContainer();
            if (dataSourceContainer == null) {
                log.error("Error saving virtual config for hints: not datasource container");
            } else {
                dataSourceContainer.persistConfiguration();
            }
        }
    }
}

