/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.BeanUtils;
import org.jkiss.utils.CommonUtils;

public class DialogSettingsMap
extends AbstractMap<String, Object> {
    private static final Log log = Log.getLog(DialogSettingsMap.class);
    private final IDialogSettings settings;

    public DialogSettingsMap(IDialogSettings settings) {
        this.settings = settings;
    }

    @Override
    @NotNull
    public Set<Map.Entry<String, Object>> entrySet() {
        LinkedHashSet<Map.Entry<String, Object>> entries = new LinkedHashSet<Map.Entry<String, Object>>();
        for (IDialogSettings iDialogSettings : ArrayUtils.safeArray((Object[])this.settings.getSections())) {
            entries.add(new AbstractMap.SimpleEntry<String, DialogSettingsMap>(iDialogSettings.getName(), new DialogSettingsMap(iDialogSettings)));
        }
        for (Map.Entry entry : this.getItemsInternal().entrySet()) {
            entries.add(new AbstractMap.SimpleEntry((String)entry.getKey(), entry.getValue()));
        }
        for (Map.Entry entry : this.getArrayItemsInternal().entrySet()) {
            entries.add(new AbstractMap.SimpleEntry((String)entry.getKey(), entry.getValue()));
        }
        return entries;
    }

    @Override
    public Object get(Object key) {
        return this.getOrDefault(key, (Object)null);
    }

    @Override
    public Object getOrDefault(Object key, Object defaultValue) {
        String keyValue = this.settings.get((String)key);
        if (keyValue != null) {
            return keyValue;
        }
        IDialogSettings section = this.settings.getSection((String)key);
        if (section != null) {
            return new DialogSettingsMap(section);
        }
        return defaultValue;
    }

    @Override
    public Object put(String key, Object value) {
        return this.putIfAbsent(key, value);
    }

    @Override
    public Object putIfAbsent(String key, Object value) {
        if (value instanceof Map) {
            DialogSettingsMap map = new DialogSettingsMap(this.settings.addNewSection(key));
            map.putAll((Map)value);
            return map;
        }
        if (ArrayUtils.isArray((Object)value)) {
            Object[] src = (Object[])value;
            String[] dst = new String[src.length];
            for (int i = 0; i < src.length; ++i) {
                dst[i] = CommonUtils.toString((Object)src[i]);
            }
            this.settings.put(key, dst);
        } else {
            this.settings.put(key, CommonUtils.toString((Object)value));
        }
        return value;
    }

    @Override
    public boolean remove(Object key, Object value) {
        return false;
    }

    @Override
    public int hashCode() {
        return this.settings.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof DialogSettingsMap && this.settings.equals((Object)((DialogSettingsMap)o).settings);
    }

    @NotNull
    private Map<String, String> getItemsInternal() {
        try {
            return (Map)BeanUtils.getFieldValue((Object)this.settings, (String)"items");
        }
        catch (Throwable e) {
            log.error((Object)"Can't read items from settings", e);
            return Collections.emptyMap();
        }
    }

    @NotNull
    private Map<String, String[]> getArrayItemsInternal() {
        try {
            return (Map)BeanUtils.getFieldValue((Object)this.settings, (String)"arrayItems");
        }
        catch (Throwable e) {
            log.error((Object)"Can't read array items from settings", e);
            return Collections.emptyMap();
        }
    }
}

