/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.folders;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Widget;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ui.ConComposite;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.folders.ITabbedFolder;
import org.jkiss.dbeaver.ui.controls.folders.ITabbedFolderContainer;
import org.jkiss.dbeaver.ui.controls.folders.ITabbedFolderListener;
import org.jkiss.dbeaver.ui.controls.folders.TabbedFolderInfo;
import org.jkiss.dbeaver.ui.controls.folders.TabbedFolderList;
import org.jkiss.dbeaver.ui.controls.folders.TabbedFolderState;
import org.jkiss.dbeaver.ui.controls.folders.TabbedFoldersRegistry;
import org.jkiss.dbeaver.ui.css.CSSUtils;

public class TabbedFolderComposite
extends ConComposite
implements ITabbedFolderContainer {
    @NotNull
    private final Composite compositePane;
    @Nullable
    private TabbedFolderInfo[] folders;
    private final Map<TabbedFolderInfo, Composite> contentsMap = new HashMap<TabbedFolderInfo, Composite>();
    private final List<ITabbedFolderListener> listeners = new ArrayList<ITabbedFolderListener>();
    private FolderPane[] folderPanes;
    private FolderPane lastActiveFolder = null;
    private TabbedFolderState folderState;
    private boolean inLayoutUpdate;

    private void shiftPane(FolderPane curPane, int shift) {
        FolderPane nextPane = this.getNextFolderPane(curPane);
        ((GridData)curPane.editorPane.getLayoutData()).heightHint += shift;
        ((GridData)nextPane.editorPane.getLayoutData()).heightHint -= shift;
        this.reLayout();
    }

    private void reLayout() {
        this.inLayoutUpdate = true;
        try {
            this.compositePane.layout();
        }
        finally {
            this.inLayoutUpdate = false;
        }
    }

    private FolderPane getNextFolderPane(FolderPane pane) {
        for (int i = 0; i < this.folderPanes.length - 1; ++i) {
            if (pane != this.folderPanes[i]) continue;
            return this.folderPanes[i + 1];
        }
        return null;
    }

    public TabbedFolderComposite(Composite parent, int style) {
        super(parent, style);
        GridLayout gl = new GridLayout(2, false);
        gl.horizontalSpacing = 0;
        gl.verticalSpacing = 0;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        this.setLayout((Layout)gl);
        this.compositePane = new ConComposite(this, 0);
        gl = new GridLayout(2, false);
        gl.horizontalSpacing = 0;
        gl.verticalSpacing = 0;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        this.compositePane.setLayout((Layout)gl);
        this.compositePane.setLayoutData((Object)new GridData(1808));
        this.addTraverseListener(e -> {
            FolderPane pane = this.getActiveFolderPane();
            if (pane != null) {
                pane.folderList.handleTraverse(e);
            }
        });
        this.addDisposeListener(e -> {
            for (TabbedFolderInfo folderDescription : this.contentsMap.keySet()) {
                folderDescription.getContents().dispose();
            }
        });
    }

    public void setBackground(Color color) {
        super.setBackground(color);
    }

    public int getTabsWidth() {
        FolderPane pane = this.getActiveFolderPane();
        return pane == null ? 0 : pane.folderList.computeSize((int)-1, (int)-1).x;
    }

    public void setFolders(@NotNull String objectId, @NotNull TabbedFolderInfo[] folders) {
        this.folders = folders;
        this.folderState = TabbedFoldersRegistry.getInstance().getFolderState(objectId);
        ArrayList groups = new ArrayList();
        ArrayList<TabbedFolderInfo> curGroup = null;
        for (TabbedFolderInfo folder : folders) {
            if (folder.isEmbeddable()) {
                curGroup = new ArrayList<TabbedFolderInfo>();
                groups.add(curGroup);
                curGroup.add(folder);
                curGroup = null;
                continue;
            }
            if (curGroup == null) {
                curGroup = new ArrayList();
                groups.add(curGroup);
            }
            curGroup.add(folder);
        }
        this.folderPanes = new FolderPane[groups.size()];
        for (int i = 0; i < groups.size(); ++i) {
            List group = (List)groups.get(i);
            FolderPane folderPane = new FolderPane(this.compositePane, i >= groups.size() - 1);
            folderPane.setFolders(group.toArray(new TabbedFolderInfo[group.size()]));
            this.folderPanes[i] = folderPane;
        }
        int maxWidth = 0;
        for (FolderPane folderPane : this.folderPanes) {
            int width = folderPane.folderList.computeSize((int)-1, (int)-1, (boolean)false).x;
            if (width <= maxWidth) continue;
            maxWidth = width;
        }
        for (int i = 0; i < this.folderPanes.length; ++i) {
            FolderPane folderPane = this.folderPanes[i];
            GridData gd = (GridData)folderPane.folderList.getLayoutData();
            TabbedFolderState.TabState tabState = this.folderState.getTabState(folderPane.folders[0].getId(), true);
            gd.widthHint = maxWidth;
            gd.minimumHeight = folderPane.folderList.getTabHeight();
        }
        this.reLayout();
    }

    @NotNull
    public TabbedFolderState getFolderState() {
        return this.folderState;
    }

    @Nullable
    public TabbedFolderInfo[] getFolders() {
        return this.folders;
    }

    @Override
    public ITabbedFolder getActiveFolder() {
        return this.getActiveFolder(true);
    }

    public ITabbedFolder getActiveFolder(boolean activate) {
        FolderPane pane = this.getActiveFolderPane();
        if (pane != null) {
            return this.getActiveFolder(pane, activate);
        }
        return null;
    }

    private FolderPane getActiveFolderPane() {
        if (this.folderPanes.length == 1) {
            return this.folderPanes[0];
        }
        Control focusControl = this.getDisplay().getFocusControl();
        for (FolderPane folderPane : this.folderPanes) {
            if (!UIUtils.isParent((Control)folderPane.editorPane, focusControl)) continue;
            this.lastActiveFolder = folderPane;
            return folderPane;
        }
        if (this.lastActiveFolder != null) {
            return this.lastActiveFolder;
        }
        return null;
    }

    private ITabbedFolder getActiveFolder(FolderPane folderPane, boolean activate) {
        TabbedFolderList folderList = folderPane.folderList;
        int selectionIndex = folderList.getSelectionIndex();
        if (selectionIndex < 0) {
            if (!activate) {
                return null;
            }
            selectionIndex = 0;
            folderList.select(selectionIndex);
        }
        return folderList.getElementAt(selectionIndex).getInfo().getContents();
    }

    @Override
    public boolean switchFolder(@Nullable String folderId) {
        return this.switchFolder(folderId, true);
    }

    public boolean switchFolder(@Nullable String folderId, boolean setFocus) {
        for (FolderPane folderPane : this.folderPanes) {
            for (int i = 0; i < folderPane.folderList.getNumberOfElements(); ++i) {
                if (folderId != null && !folderPane.folderList.getElementAt(i).getInfo().getId().equals(folderId)) continue;
                if (folderPane.folderList.getSelectionIndex() != i) {
                    folderPane.folderList.select(i, setFocus);
                    this.lastActiveFolder = folderPane;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    @Override
    public void addFolderListener(ITabbedFolderListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeFolderListener(ITabbedFolderListener listener) {
        this.listeners.remove(listener);
    }

    private class FolderPane {
        TabbedFolderInfo[] folders;
        TabbedFolderList folderList;
        Composite editorPane;
        @Nullable
        private Control curContent;
        @Nullable
        private ITabbedFolder curFolder;
        @Nullable
        private final Sash sash;

        public FolderPane(Composite parent, boolean last) {
            this.folderList = new TabbedFolderList(parent, !last);
            CSSUtils.markConnectionTypeColor((Widget)this.folderList);
            GridData gd = new GridData(1040);
            if (!last) {
                gd.verticalSpan = 2;
            }
            this.folderList.setLayoutData(gd);
            this.editorPane = UIUtils.createPlaceholder(parent, 1);
            gd = new GridData(1808);
            gd.heightHint = this.folderList.getTabHeight();
            this.editorPane.setLayoutData((Object)gd);
            if (!last) {
                this.sash = new Sash(parent, 0);
                gd = new GridData(768);
                gd.heightHint = 7;
                this.sash.setLayoutData((Object)gd);
                this.sash.addPaintListener(e -> {
                    e.gc.setForeground(this.folderList.widgetForeground);
                    e.gc.fillRectangle(0, 1, e.width, e.height - 2);
                    e.gc.setForeground(this.folderList.widgetNormalShadow);
                    e.gc.drawLine(0, 0, e.width - 1, 0);
                    e.gc.drawLine(0, e.height - 1, e.width - 1, e.height - 1);
                });
                this.sash.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void widgetSelected(SelectionEvent e) {
                        Rectangle sashBounds = FolderPane.this.sash.getBounds();
                        int shift = e.y - sashBounds.y;
                        if (shift > 0 && shift > TabbedFolderComposite.this.getNextFolderPane((FolderPane)FolderPane.this).editorPane.getBounds().height - FolderPane.this.folderList.getTabHeight()) {
                            e.doit = false;
                            return;
                        }
                        if (shift < 0 && Math.abs(shift) > FolderPane.this.editorPane.getBounds().height - FolderPane.this.folderList.getTabHeight()) {
                            e.doit = false;
                            return;
                        }
                        if (Math.abs(shift) > 0) {
                            TabbedFolderComposite.this.setRedraw(false);
                            try {
                                TabbedFolderComposite.this.shiftPane(FolderPane.this, shift);
                            }
                            finally {
                                TabbedFolderComposite.this.setRedraw(true);
                            }
                        }
                    }
                });
            } else {
                this.sash = null;
            }
            this.folderList.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FolderPane.this.onFolderSwitch(FolderPane.this.folderList.getElementAt(FolderPane.this.folderList.getSelectionIndex()).getInfo());
                }
            });
        }

        public void setFolders(TabbedFolderInfo[] folders) {
            this.folders = folders;
            this.folderList.setFolders(this.folders);
        }

        private void onFolderSwitch(TabbedFolderInfo folder) {
            Composite newContent = TabbedFolderComposite.this.contentsMap.get(folder);
            ITabbedFolder newFolder = folder.getContents();
            if (newContent == null) {
                newContent = new Composite(this.editorPane, 0);
                newContent.setLayoutData((Object)new GridData(1808));
                newContent.setLayout((Layout)new FillLayout());
                newFolder.createControl(newContent);
                TabbedFolderComposite.this.contentsMap.put(folder, newContent);
            }
            if (this.curContent != null && this.curFolder != null) {
                this.curFolder.aboutToBeHidden();
            }
            newFolder.aboutToBeShown();
            if (this.curContent != null && this.curFolder != null) {
                this.curContent.setVisible(false);
                ((GridData)this.curContent.getLayoutData()).exclude = true;
            }
            ((GridData)newContent.getLayoutData()).exclude = false;
            newContent.setVisible(true);
            this.curContent = newContent;
            this.curFolder = newFolder;
            this.editorPane.layout();
            for (ITabbedFolderListener listener : TabbedFolderComposite.this.listeners) {
                listener.folderSelected(folder.getId());
            }
        }
    }
}

