/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.data.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.registry.data.hints.AbstractValueBindingRegistry;
import org.jkiss.dbeaver.ui.data.IStreamValueManager;
import org.jkiss.dbeaver.ui.data.IValueManager;
import org.jkiss.dbeaver.ui.data.managers.DefaultValueManager;
import org.jkiss.dbeaver.ui.data.registry.StreamValueManagerDescriptor;
import org.jkiss.dbeaver.ui.data.registry.ValueManagerDescriptor;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.MimeType;

public class ValueManagerRegistry
extends AbstractValueBindingRegistry<IValueManager, Object, ValueManagerDescriptor> {
    private static ValueManagerRegistry instance = null;
    private final List<ValueManagerDescriptor> managers = new ArrayList<ValueManagerDescriptor>();
    private final Map<String, StreamValueManagerDescriptor> streamManagers = new HashMap<String, StreamValueManagerDescriptor>();

    public static synchronized ValueManagerRegistry getInstance() {
        if (instance == null) {
            instance = new ValueManagerRegistry(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private ValueManagerRegistry(IExtensionRegistry registry) {
        IConfigurationElement[] extElements;
        for (IConfigurationElement ext : extElements = registry.getConfigurationElementsFor("org.jkiss.dbeaver.dataManager")) {
            if ("manager".equals(ext.getName())) {
                this.managers.add(new ValueManagerDescriptor(ext));
                continue;
            }
            if (!"streamManager".equals(ext.getName())) continue;
            StreamValueManagerDescriptor descriptor = new StreamValueManagerDescriptor(ext);
            this.streamManagers.put(descriptor.getId(), descriptor);
        }
    }

    @NotNull
    protected List<ValueManagerDescriptor> getDescriptors() {
        return this.managers;
    }

    @NotNull
    protected IValueManager getDefaultValueBinding() {
        return DefaultValueManager.INSTANCE;
    }

    @NotNull
    public static IValueManager findValueManager(@Nullable DBPDataSource dataSource, @NotNull DBSTypedObject typedObject, @NotNull Class<?> valueType) {
        return (IValueManager)ValueManagerRegistry.getInstance().getValueBinding(typedObject, dataSource, typedObject, valueType);
    }

    @NotNull
    public Collection<StreamValueManagerDescriptor> getAllStreamManagers() {
        return Collections.unmodifiableCollection(this.streamManagers.values());
    }

    @Nullable
    public StreamValueManagerDescriptor getStreamManager(@NotNull String id) {
        return this.streamManagers.get(id);
    }

    public Map<StreamValueManagerDescriptor, IStreamValueManager.MatchType> getApplicableStreamManagers(@NotNull DBRProgressMonitor monitor, @NotNull DBSTypedObject attribute, @Nullable DBDContent value) {
        boolean isTextContent = ContentUtils.isTextContent((DBDContent)value);
        LinkedHashMap<StreamValueManagerDescriptor, IStreamValueManager.MatchType> result = new LinkedHashMap<StreamValueManagerDescriptor, IStreamValueManager.MatchType>();
        block4: for (StreamValueManagerDescriptor contentManager : this.streamManagers.values()) {
            if (isTextContent && !contentManager.supportsText()) continue;
            IStreamValueManager.MatchType matchType = contentManager.getInstance().matchesTo(monitor, attribute, value);
            switch (matchType) {
                case NONE: {
                    continue block4;
                }
                case EXCLUSIVE: {
                    result.clear();
                    result.put(contentManager, matchType);
                    return result;
                }
            }
            result.put(contentManager, matchType);
        }
        return result;
    }

    public Map<StreamValueManagerDescriptor, IStreamValueManager.MatchType> getStreamManagersByMimeType(@NotNull String mimeType, String primaryType) {
        MimeType mime = new MimeType(mimeType);
        MimeType primaryMime = primaryType == null ? null : new MimeType(primaryType);
        LinkedHashMap<StreamValueManagerDescriptor, IStreamValueManager.MatchType> result = new LinkedHashMap<StreamValueManagerDescriptor, IStreamValueManager.MatchType>();
        block0: for (StreamValueManagerDescriptor contentManager : this.streamManagers.values()) {
            for (String sm : contentManager.getSupportedMime()) {
                if (CommonUtils.isEmpty((String)sm) || !mime.match(sm)) continue;
                if (!CommonUtils.isEmpty((String)contentManager.getPrimaryMime()) && primaryMime != null && primaryMime.match(contentManager.getPrimaryMime())) {
                    result.put(contentManager, IStreamValueManager.MatchType.PRIMARY);
                    continue block0;
                }
                result.put(contentManager, IStreamValueManager.MatchType.DEFAULT);
                continue block0;
            }
        }
        return result;
    }
}

