/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.erd.router;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.ui.editors.erd.internal.ERDUIActivator;
import org.jkiss.dbeaver.ui.editors.erd.notations.ERDNotationRegistry;
import org.jkiss.dbeaver.ui.editors.erd.router.ERDConnectionRouterDescriptor;

public class ERDConnectionRouterRegistry {
    private static final String EXTENSION_ID = "org.jkiss.dbeaver.ui.editors.erd.routing";
    private static final Log log = Log.getLog(ERDNotationRegistry.class);
    private static ERDConnectionRouterRegistry instance;
    private final Map<String, ERDConnectionRouterDescriptor> connectionRouterDescriptors = new LinkedHashMap<String, ERDConnectionRouterDescriptor>();
    private ERDConnectionRouterDescriptor activeRouterDescriptor;

    private ERDConnectionRouterRegistry(IExtensionRegistry registry) {
        IConfigurationElement[] cfgElements;
        for (IConfigurationElement cfe : cfgElements = registry.getConfigurationElementsFor(EXTENSION_ID)) {
            try {
                this.addDescriptor(new ERDConnectionRouterDescriptor(cfe));
            }
            catch (CoreException e) {
                log.error((Object)e.getStatus());
            }
        }
    }

    private DBPPreferenceStore getPreferenceStore() {
        return ERDUIActivator.getDefault().getPreferences();
    }

    private void addDescriptor(@NotNull ERDConnectionRouterDescriptor descriptor) {
        if (this.connectionRouterDescriptors.containsKey(descriptor.getId())) {
            log.error((Object)("ER Diagram Connection router is already defined for id:" + descriptor.getId()));
            return;
        }
        this.connectionRouterDescriptors.put(descriptor.getId(), descriptor);
    }

    public static synchronized ERDConnectionRouterRegistry getInstance() {
        if (instance == null) {
            instance = new ERDConnectionRouterRegistry(Platform.getExtensionRegistry());
        }
        return instance;
    }

    @NotNull
    public List<ERDConnectionRouterDescriptor> getDescriptors() {
        ArrayList<ERDConnectionRouterDescriptor> descriptors = new ArrayList<ERDConnectionRouterDescriptor>();
        for (ERDConnectionRouterDescriptor descriptor : this.connectionRouterDescriptors.values()) {
            descriptors.add(descriptor);
        }
        return descriptors;
    }

    @Nullable
    public ERDConnectionRouterDescriptor getDescriptorById(String id) {
        if (!this.connectionRouterDescriptors.containsKey(id)) {
            for (ERDConnectionRouterDescriptor descriptor : this.connectionRouterDescriptors.values()) {
                if (!descriptor.getName().equals(id)) continue;
                return descriptor;
            }
        }
        return this.connectionRouterDescriptors.get(id);
    }

    @NotNull
    public ERDConnectionRouterDescriptor getActiveRouter() {
        if (this.activeRouterDescriptor != null) {
            return this.activeRouterDescriptor;
        }
        for (ERDConnectionRouterDescriptor router : this.connectionRouterDescriptors.values()) {
            if (!router.isDefaultRouter()) continue;
            this.activeRouterDescriptor = router;
            break;
        }
        if (this.activeRouterDescriptor == null) {
            this.activeRouterDescriptor = this.getDescriptorById(this.getPreferenceStore().getString("erd.routing.type"));
        }
        if (this.activeRouterDescriptor == null) {
            this.activeRouterDescriptor = this.getDefaultDescriptor();
        }
        return this.activeRouterDescriptor;
    }

    public void setActiveRouter(ERDConnectionRouterDescriptor connectionRouter) {
        this.activeRouterDescriptor = connectionRouter;
        this.getPreferenceStore().setValue("erd.routing.type", this.activeRouterDescriptor.getId());
    }

    @NotNull
    public ERDConnectionRouterDescriptor getDefaultDescriptor() {
        return Objects.requireNonNull(this.getDescriptorById("org.jkiss.dbeaver.erd.router.shortest.path"));
    }
}

