/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.xml;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.swt.widgets.Display;
import org.jkiss.dbeaver.ui.editors.xml.XMLEditor;

public class XMLReconcilingStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension {
    private static final int START_TAG = 1;
    private static final int LEAF_TAG = 2;
    private static final int END_TAG = 3;
    private static final int EOR_TAG = 4;
    private static final int COMMENT_TAG = 5;
    private static final int PI_TAG = 6;
    private XMLEditor editor;
    private IDocument document;
    private final List<Position> positions = new ArrayList<Position>();
    private int cNextPos = 0;
    private int cNewLines = 0;
    private char cLastNLChar = (char)32;
    private int fOffset;
    private int fRangeEnd;

    public XMLEditor getEditor() {
        return this.editor;
    }

    public void setEditor(XMLEditor editor) {
        this.editor = editor;
    }

    public void setDocument(IDocument document) {
        this.document = document;
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        this.initialReconcile();
    }

    public void reconcile(IRegion partition) {
        this.initialReconcile();
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
    }

    public void initialReconcile() {
        this.fOffset = 0;
        this.fRangeEnd = this.document.getLength();
        this.calculatePositions();
    }

    private void calculatePositions() {
        this.positions.clear();
        this.cNextPos = this.fOffset;
        try {
            this.recursiveTokens(0);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                XMLReconcilingStrategy.this.editor.updateFoldingStructure(XMLReconcilingStrategy.this.positions);
            }
        });
    }

    private int recursiveTokens(int depth) throws BadLocationException {
        int newLines = 0;
        while (this.cNextPos < this.fRangeEnd) {
            while (this.cNextPos < this.fRangeEnd) {
                char ch = this.document.getChar(this.cNextPos++);
                block0 : switch (ch) {
                    case '<': {
                        int startOffset = this.cNextPos - 1;
                        int startNewLines = newLines;
                        int classification = this.classifyTag();
                        newLines += this.cNewLines;
                        switch (classification) {
                            case 1: {
                                if ((newLines += this.recursiveTokens(depth + 1)) <= startNewLines + 1) break block0;
                                this.emitPosition(startOffset, this.cNextPos - startOffset);
                                break block0;
                            }
                            case 2: {
                                if (newLines <= startNewLines + 1) break block0;
                                this.emitPosition(startOffset, this.cNextPos - startOffset);
                                break block0;
                            }
                            case 5: {
                                if (newLines <= startNewLines + 1) break block0;
                                this.emitPosition(startOffset, this.cNextPos - startOffset);
                                break block0;
                            }
                            case 6: {
                                break block0;
                            }
                            case 3: 
                            case 4: {
                                return newLines;
                            }
                        }
                        break;
                    }
                    case '\n': 
                    case '\r': {
                        if (ch != this.cLastNLChar && ' ' != this.cLastNLChar) break;
                        ++newLines;
                        this.cLastNLChar = ch;
                        break;
                    }
                }
            }
        }
        return newLines;
    }

    private void emitPosition(int startOffset, int length) {
        this.positions.add(new Position(startOffset, length));
    }

    private int classifyTag() {
        try {
            char ch = this.document.getChar(this.cNextPos++);
            this.cNewLines = 0;
            if ('?' == ch) {
                boolean piFlag = false;
                while (this.cNextPos < this.fRangeEnd) {
                    if ('>' == (ch = this.document.getChar(this.cNextPos++)) && piFlag) {
                        return 6;
                    }
                    piFlag = '?' == ch;
                }
                return 4;
            }
            if ('!' == ch) {
                ++this.cNextPos;
                ++this.cNextPos;
                int commEnd = 0;
                while (this.cNextPos < this.fRangeEnd) {
                    if ('>' == (ch = this.document.getChar(this.cNextPos++)) && commEnd >= 2) {
                        return 5;
                    }
                    if (!('\n' != ch && '\r' != ch || ch != this.cLastNLChar && ' ' != this.cLastNLChar)) {
                        ++this.cNewLines;
                        this.cLastNLChar = ch;
                    }
                    if ('-' == ch) {
                        ++commEnd;
                        continue;
                    }
                    commEnd = 0;
                }
                return 4;
            }
            while (' ' == ch || '\t' == ch || '\n' == ch || '\r' == ch) {
                ch = this.document.getChar(this.cNextPos++);
                if (this.cNextPos <= this.fRangeEnd) continue;
                return 4;
            }
            if ('/' == ch) {
                while (this.cNextPos < this.fRangeEnd) {
                    if ('>' == (ch = this.document.getChar(this.cNextPos++))) {
                        this.cNewLines += this.eatToEndOfLine();
                        return 3;
                    }
                    if ('\"' == ch) {
                        ch = this.document.getChar(this.cNextPos++);
                        while (this.cNextPos < this.fRangeEnd && '\"' != ch) {
                            ch = this.document.getChar(this.cNextPos++);
                        }
                        continue;
                    }
                    if ('\'' != ch) continue;
                    ch = this.document.getChar(this.cNextPos++);
                    while (this.cNextPos < this.fRangeEnd && '\'' != ch) {
                        ch = this.document.getChar(this.cNextPos++);
                    }
                }
                return 4;
            }
            block14: while (this.cNextPos < this.fRangeEnd) {
                ch = this.document.getChar(this.cNextPos++);
                switch (ch) {
                    case '/': {
                        while (this.cNextPos < this.fRangeEnd) {
                            if ('>' != (ch = this.document.getChar(this.cNextPos++))) continue;
                            this.cNewLines += this.eatToEndOfLine();
                            return 2;
                        }
                        return 4;
                    }
                    case '\"': {
                        while (this.cNextPos < this.fRangeEnd) {
                            if ('\"' != (ch = this.document.getChar(this.cNextPos++))) continue;
                            continue block14;
                        }
                        return 4;
                    }
                    case '\'': {
                        while (this.cNextPos < this.fRangeEnd) {
                            if ('\'' != (ch = this.document.getChar(this.cNextPos++))) continue;
                            continue block14;
                        }
                        return 4;
                    }
                    case '>': {
                        this.cNewLines += this.eatToEndOfLine();
                        return 1;
                    }
                }
            }
            return 4;
        }
        catch (BadLocationException e) {
            return 4;
        }
    }

    private int eatToEndOfLine() throws BadLocationException {
        if (this.cNextPos >= this.fRangeEnd) {
            return 0;
        }
        char ch = this.document.getChar(this.cNextPos++);
        while (this.cNextPos < this.fRangeEnd && (' ' == ch || '\t' == ch)) {
            ch = this.document.getChar(this.cNextPos++);
        }
        if (this.cNextPos >= this.fRangeEnd) {
            --this.cNextPos;
            return 0;
        }
        if ('\n' == ch) {
            if (this.cNextPos < this.fRangeEnd) {
                if ('\r' != (ch = this.document.getChar(this.cNextPos++))) {
                    --this.cNextPos;
                }
            } else {
                --this.cNextPos;
            }
            return 1;
        }
        if ('\r' == ch) {
            if (this.cNextPos < this.fRangeEnd) {
                if ('\n' != (ch = this.document.getChar(this.cNextPos++))) {
                    --this.cNextPos;
                }
            } else {
                --this.cNextPos;
            }
            return 1;
        }
        return 0;
    }
}

