/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.codeexplorer.task;

import com.google.gson.annotations.SerializedName;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.freeplane.core.util.TypeReference;
import org.freeplane.features.attribute.Attribute;
import org.freeplane.features.attribute.NodeAttributeTableModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.text.DetailModel;
import org.freeplane.plugin.codeexplorer.task.CodeNodeAttribute;
import org.freeplane.plugin.codeexplorer.task.CodeNodeDetails;

public class CodeNodeUserContent
implements Comparable<CodeNodeUserContent> {
    private static final Comparator<CodeNodeUserContent> COMPARING_USER_CONTENT_BY_ID = Comparator.comparing(CodeNodeUserContent::getNodeIdWithoutGroupIndex);
    @SerializedName(value="nodeId")
    private String nodeIdWithoutGroupIndex;
    @SerializedName(value="details")
    private Optional<CodeNodeDetails> details;
    @SerializedName(value="attributes")
    private List<CodeNodeAttribute> attributes;

    public CodeNodeUserContent(String nodeIdWithoutGroupIndex, Optional<CodeNodeDetails> details, List<CodeNodeAttribute> attributes) {
        this.nodeIdWithoutGroupIndex = nodeIdWithoutGroupIndex;
        this.details = details;
        this.attributes = attributes;
    }

    void initialize() {
        if (this.details == null) {
            this.details = Optional.empty();
        }
        if (this.attributes == null) {
            this.attributes = Collections.emptyList();
        }
    }

    public String getNodeIdWithoutGroupIndex() {
        return this.nodeIdWithoutGroupIndex;
    }

    public Optional<CodeNodeDetails> getDetails() {
        return this.details;
    }

    public List<CodeNodeAttribute> getAttributes() {
        return this.attributes;
    }

    public String toString() {
        return "CodeNodeUserContent [nodeId=" + this.nodeIdWithoutGroupIndex + ", details=" + this.details + ", attributes=" + this.attributes + "]";
    }

    @Override
    public int compareTo(CodeNodeUserContent other) {
        return COMPARING_USER_CONTENT_BY_ID.compare(this, other);
    }

    public int hashCode() {
        return Objects.hash(this.nodeIdWithoutGroupIndex);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CodeNodeUserContent other = (CodeNodeUserContent)obj;
        return Objects.equals(this.nodeIdWithoutGroupIndex, other.nodeIdWithoutGroupIndex);
    }

    public static class Factory {
        public static final Factory INSTANCE = new Factory();

        public CodeNodeUserContent contentOf(NodeModel node) {
            String id = node.getID();
            Optional<CodeNodeDetails> details = Optional.ofNullable(DetailModel.getDetail((NodeModel)node)).map(x -> this.toCodeNodeDetails((DetailModel)x)).filter(x -> !x.getContent().isEmpty());
            List<CodeNodeAttribute> attributes = this.attributes(node).filter(attribute -> !attribute.isManaged()).map(this::toCodeNodeAttribute).collect(Collectors.toList());
            String idWithoutGroupIndex = node.isRoot() ? id : id.substring(0, id.lastIndexOf(91));
            return new CodeNodeUserContent(idWithoutGroupIndex, details, attributes);
        }

        private CodeNodeDetails toCodeNodeDetails(DetailModel details) {
            return new CodeNodeDetails(details.getText(), details.isHidden());
        }

        private CodeNodeAttribute toCodeNodeAttribute(Attribute attribute) {
            Object value = attribute.getValue();
            CodeNodeAttribute.ContentType contentType = value instanceof String ? CodeNodeAttribute.ContentType.STRING : CodeNodeAttribute.ContentType.OBJECT;
            return new CodeNodeAttribute(contentType, attribute.getName(), contentType == CodeNodeAttribute.ContentType.STRING ? (String)value : TypeReference.toSpec((Object)value));
        }

        public DetailModel fromCodeNodeDetails(CodeNodeDetails x) {
            return new DetailModel(null, x.getContent(), null, x.isHidden());
        }

        public Attribute fromCodeNodeAttribute(CodeNodeAttribute attribute) {
            String valueSpec = attribute.getValue();
            return new Attribute(attribute.getName(), attribute.getContentType() == CodeNodeAttribute.ContentType.STRING ? valueSpec : TypeReference.create((String)valueSpec));
        }

        public boolean hasCustomContent(NodeModel node) {
            return this.hasDetails(node) || this.hasCustomAttributes(node);
        }

        private boolean hasDetails(NodeModel node) {
            return DetailModel.getDetail((NodeModel)node) != null;
        }

        private boolean hasCustomAttributes(NodeModel node) {
            return this.customAttributes(node).anyMatch(x -> true);
        }

        private Stream<Attribute> customAttributes(NodeModel node) {
            Stream<Attribute> stream = this.attributes(node);
            return stream.filter(a -> !a.isManaged());
        }

        private Stream<Attribute> attributes(NodeModel node) {
            NodeAttributeTableModel attributes = NodeAttributeTableModel.getModel((NodeModel)node);
            Stream<Attribute> stream = attributes != null && attributes.getRowCount() > 0 ? attributes.getAttributes().stream() : Stream.empty();
            return stream;
        }
    }
}

