/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.lang.reflect.Array;
import java.util.Objects;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Symbol;
import org.mozilla.javascript.SymbolKey;
import org.mozilla.javascript.SymbolScriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;

public class NativeJavaArray
extends NativeJavaObject
implements SymbolScriptable {
    private static final long serialVersionUID = -924022554283675333L;
    Object array;
    int length;
    Class<?> cls;

    @Override
    public String getClassName() {
        return "JavaArray";
    }

    public static NativeJavaArray wrap(Scriptable scriptable, Object object) {
        return new NativeJavaArray(scriptable, object);
    }

    @Override
    public Object unwrap() {
        return this.array;
    }

    public NativeJavaArray(Scriptable scriptable, Object object) {
        super(scriptable, null, ScriptRuntime.ObjectClass);
        Class<?> clazz = object.getClass();
        if (!clazz.isArray()) {
            throw new RuntimeException("Array expected");
        }
        this.array = object;
        this.length = Array.getLength(object);
        this.cls = clazz.getComponentType();
    }

    @Override
    public boolean has(String string, Scriptable scriptable) {
        return string.equals("length") || super.has(string, scriptable);
    }

    @Override
    public boolean has(int n, Scriptable scriptable) {
        return 0 <= n && n < this.length;
    }

    @Override
    public boolean has(Symbol symbol, Scriptable scriptable) {
        return SymbolKey.IS_CONCAT_SPREADABLE.equals(symbol);
    }

    @Override
    public Object get(String string, Scriptable scriptable) {
        if (string.equals("length")) {
            return this.length;
        }
        Object object = super.get(string, scriptable);
        if (object == NOT_FOUND && !ScriptableObject.hasProperty(this.getPrototype(), string)) {
            throw Context.reportRuntimeErrorById("msg.java.member.not.found", this.array.getClass().getName(), string);
        }
        return object;
    }

    @Override
    public Object get(int n, Scriptable scriptable) {
        if (0 <= n && n < this.length) {
            Context context = Context.getContext();
            Object object = Array.get(this.array, n);
            return context.getWrapFactory().wrap(context, this, object, this.cls);
        }
        return Undefined.instance;
    }

    @Override
    public Object get(Symbol symbol, Scriptable scriptable) {
        if (SymbolKey.IS_CONCAT_SPREADABLE.equals(symbol)) {
            return Boolean.TRUE;
        }
        return Scriptable.NOT_FOUND;
    }

    @Override
    public void put(String string, Scriptable scriptable, Object object) {
        if (!string.equals("length")) {
            throw Context.reportRuntimeErrorById("msg.java.array.member.not.found", string);
        }
    }

    @Override
    public void put(int n, Scriptable scriptable, Object object) {
        if (0 > n || n >= this.length) {
            throw Context.reportRuntimeErrorById("msg.java.array.index.out.of.bounds", String.valueOf(n), String.valueOf(this.length - 1));
        }
        Array.set(this.array, n, Context.jsToJava(object, this.cls));
    }

    @Override
    public void delete(Symbol symbol) {
    }

    @Override
    public Object getDefaultValue(Class<?> clazz) {
        if (clazz == null || clazz == ScriptRuntime.StringClass) {
            return this.array.toString();
        }
        if (clazz == ScriptRuntime.BooleanClass) {
            return Boolean.TRUE;
        }
        if (clazz == ScriptRuntime.NumberClass) {
            return ScriptRuntime.NaNobj;
        }
        return this;
    }

    @Override
    public Object[] getIds() {
        Object[] objectArray = new Object[this.length];
        int n = this.length;
        while (--n >= 0) {
            objectArray[n] = n;
        }
        return objectArray;
    }

    @Override
    public boolean hasInstance(Scriptable scriptable) {
        if (!(scriptable instanceof Wrapper)) {
            return false;
        }
        Object object = ((Wrapper)((Object)scriptable)).unwrap();
        return this.cls.isInstance(object);
    }

    @Override
    public Scriptable getPrototype() {
        if (this.prototype == null) {
            this.prototype = ScriptableObject.getArrayPrototype(this.getParentScope());
        }
        return this.prototype;
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof NativeJavaArray && Objects.equals(((NativeJavaArray)object).array, this.array);
    }

    @Override
    public int hashCode() {
        return this.array == null ? 0 : this.array.hashCode();
    }
}

