/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.gui.search.results;

import ghidra.features.bsim.gui.search.results.BSimMatchResult;
import ghidra.features.bsim.gui.search.results.BSimResultStatus;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;

public class BSimApplyResult {
    private String target;
    private String source;
    private BSimResultStatus status;
    private Address address;
    private String message;

    public BSimApplyResult(BSimMatchResult result, BSimResultStatus status, String message) {
        this(result.getOriginalFunctionName(), result.getSimilarFunctionName(), status, result.getAddress(), message);
    }

    public BSimApplyResult(Function target, Function source, BSimResultStatus status, String message) {
        this(target.getName(true), source.getName(true), status, target.getEntryPoint(), message);
    }

    public BSimApplyResult(String target, String source, BSimResultStatus status, Address address, String message) {
        this.target = target;
        this.source = source;
        this.status = status;
        this.address = address;
        this.message = message;
    }

    public String getTargetFunctionName() {
        return this.target;
    }

    public String getSourceFunctionName() {
        return this.source;
    }

    public BSimResultStatus getStatus() {
        return this.status;
    }

    public Address getAddress() {
        return this.address;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean isError() {
        return this.status == BSimResultStatus.ERROR;
    }

    public boolean isIgnored() {
        return this.status == BSimResultStatus.IGNORED;
    }
}

