/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.datatable;

import docking.ComponentProvider;
import docking.DefaultActionContext;
import ghidra.framework.main.datatable.DomainFileContext;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.ProjectData;
import java.awt.Component;
import java.util.Collections;
import java.util.List;

public class ProjectDataContext
extends DefaultActionContext
implements DomainFileContext {
    private List<DomainFolder> selectedFolders;
    private List<DomainFile> selectedFiles;
    private Component comp;
    private boolean isActiveProject;
    private ProjectData projectData;

    public ProjectDataContext(ComponentProvider provider, ProjectData projectData, Object contextObject, List<DomainFolder> selectedFolders, List<DomainFile> selectedFiles, Component comp, boolean isActiveProject) {
        super(provider, contextObject, comp);
        this.projectData = projectData;
        this.selectedFolders = selectedFolders;
        this.selectedFiles = selectedFiles;
        this.comp = comp;
        this.isActiveProject = isActiveProject;
    }

    @Override
    public List<DomainFile> getSelectedFiles() {
        if (this.selectedFiles == null) {
            return Collections.emptyList();
        }
        return this.selectedFiles;
    }

    public List<DomainFolder> getSelectedFolders() {
        if (this.selectedFolders == null) {
            return Collections.emptyList();
        }
        return this.selectedFolders;
    }

    public boolean hasExactlyOneFileOrFolder() {
        return this.getFolderCount() + this.getFileCount() == 1;
    }

    public boolean hasOneOrMoreFilesAndFolders() {
        return this.getFolderCount() + this.getFileCount() > 0;
    }

    public int getFolderCount() {
        if (this.selectedFolders == null) {
            return 0;
        }
        return this.selectedFolders.size();
    }

    @Override
    public int getFileCount() {
        if (this.selectedFiles == null) {
            return 0;
        }
        return this.selectedFiles.size();
    }

    public ProjectData getProjectData() {
        return this.projectData;
    }

    public Component getComponent() {
        return this.comp;
    }

    @Override
    public boolean isInActiveProject() {
        return this.isActiveProject;
    }

    public boolean isReadOnlyProject() {
        if (this.projectData == null) {
            return false;
        }
        return !this.projectData.getRootFolder().isInWritableProject();
    }

    public boolean containsRootFolder() {
        if (this.getFolderCount() == 0) {
            return false;
        }
        List<DomainFolder> folders = this.getSelectedFolders();
        for (DomainFolder domainFolder : folders) {
            if (domainFolder.getParent() != null) continue;
            return true;
        }
        return false;
    }
}

