/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table.constraint;

import docking.widgets.table.constraint.SingleValueColumnConstraint;
import docking.widgets.table.constraint.TableFilterContext;
import docking.widgets.table.constraint.provider.EditorProvider;
import java.time.LocalDate;
import java.time.chrono.ChronoLocalDate;

public class AtLeastDateColumnConstraint
extends SingleValueColumnConstraint<LocalDate> {
    public AtLeastDateColumnConstraint(LocalDate minValue, EditorProvider<LocalDate> editorProvider) {
        super("On or After Date", minValue, editorProvider, "date");
    }

    @Override
    public boolean accepts(LocalDate value, TableFilterContext context) {
        if (value == null) {
            return false;
        }
        return value.compareTo((ChronoLocalDate)this.getConstraintValue()) >= 0;
    }

    @Override
    public SingleValueColumnConstraint<LocalDate> copy(LocalDate newValue) {
        return new AtLeastDateColumnConstraint(newValue, this.editorProvider);
    }
}

