/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.actions;

import docking.action.MenuData;
import docking.action.ToolBarData;
import generic.theme.GIcon;
import ghidra.feature.vt.api.main.VTMarkupItemApplyActionType;
import ghidra.feature.vt.gui.actions.AbstractMarkupItemAction;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.feature.vt.gui.plugin.VTPlugin;
import ghidra.feature.vt.gui.util.VTMatchApplyChoices;
import ghidra.framework.options.ToolOptions;
import ghidra.util.HelpLocation;
import javax.swing.Icon;
import resources.MultiIcon;
import resources.ResourceManager;
import resources.icons.TranslateIcon;

public class ReplaceDefaultMarkupItemAction
extends AbstractMarkupItemAction {
    private static final String MENU_GROUP = "A_VT_Apply_Edit";

    public ReplaceDefaultMarkupItemAction(VTController controller, boolean addToToolbar) {
        super(controller, "Apply (Replace Default Only)");
        Icon replacedIcon = VTPlugin.REPLACED_ICON;
        Object warningIcon = new GIcon("icon.warning");
        warningIcon = ResourceManager.getScaledIcon((Icon)warningIcon, (int)12, (int)12);
        int warningIconWidth = warningIcon.getIconWidth();
        int warningIconHeight = warningIcon.getIconHeight();
        MultiIcon multiIcon = new MultiIcon(replacedIcon);
        int refreshIconWidth = replacedIcon.getIconWidth();
        int refreshIconHeight = replacedIcon.getIconHeight();
        int x = refreshIconWidth - warningIconWidth;
        int y = refreshIconHeight - warningIconHeight;
        TranslateIcon translateIcon = new TranslateIcon((Icon)warningIcon, x, y);
        multiIcon.addIcon((Icon)translateIcon);
        if (addToToolbar) {
            this.setToolBarData(new ToolBarData((Icon)multiIcon, MENU_GROUP));
        }
        MenuData menuData = new MenuData(new String[]{"Apply (Replace Default Only)"}, replacedIcon, MENU_GROUP);
        menuData.setMenuSubGroup("2");
        this.setPopupMenuData(menuData);
        this.setEnabled(false);
        this.setHelpLocation(new HelpLocation("VersionTrackingPlugin", "Replace_Default_Markup_Item"));
    }

    @Override
    public ToolOptions getApplyOptions() {
        ToolOptions options = this.controller.getOptions();
        ToolOptions vtOptions = options.copy();
        vtOptions.setEnum("Apply Markup Options.Function Name", (Enum)VTMatchApplyChoices.FunctionNameChoices.REPLACE_DEFAULT_ONLY);
        vtOptions.setEnum("Apply Markup Options.Labels", (Enum)VTMatchApplyChoices.LabelChoices.REPLACE_DEFAULT_ONLY);
        vtOptions.setEnum("Apply Markup Options.Function Return Type", (Enum)VTMatchApplyChoices.ParameterDataTypeChoices.REPLACE_UNDEFINED_DATA_TYPES_ONLY);
        vtOptions.setEnum("Apply Markup Options.Function Parameter Data Types", (Enum)VTMatchApplyChoices.ParameterDataTypeChoices.REPLACE_UNDEFINED_DATA_TYPES_ONLY);
        vtOptions.setEnum("Apply Markup Options.Function Parameter Names", (Enum)VTMatchApplyChoices.SourcePriorityChoices.REPLACE_DEFAULTS_ONLY);
        vtOptions.setEnum("Apply Markup Options.Data Match Data Type", (Enum)VTMatchApplyChoices.SourcePriorityChoices.REPLACE_DEFAULTS_ONLY);
        return vtOptions;
    }

    @Override
    public VTMarkupItemApplyActionType getActionType() {
        return VTMarkupItemApplyActionType.REPLACE_DEFAULT_ONLY;
    }
}

