/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.timeoverview;

import ghidra.app.plugin.core.debug.gui.timeoverview.TimeOverviewColorPlugin;
import ghidra.app.plugin.core.debug.gui.timeoverview.timetype.TimeType;
import ghidra.debug.api.tracemgr.DebuggerCoordinates;
import ghidra.framework.model.DomainObjectChangeRecord;
import ghidra.framework.model.DomainObjectEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.model.EventType;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceDomainObjectListener;
import ghidra.trace.model.bookmark.TraceBookmark;
import ghidra.trace.model.breakpoint.TraceBreakpointLocation;
import ghidra.trace.model.breakpoint.TraceBreakpointManager;
import ghidra.trace.model.memory.TraceMemoryManager;
import ghidra.trace.model.memory.TraceMemoryRegion;
import ghidra.trace.model.modules.TraceModule;
import ghidra.trace.model.modules.TraceModuleManager;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.model.thread.TraceThreadManager;
import ghidra.trace.util.TraceEvent;
import ghidra.trace.util.TraceEvents;
import ghidra.util.Swing;
import java.util.Objects;

public class TimeOverviewEventListener
extends TraceDomainObjectListener {
    private TimeOverviewColorPlugin p;
    private DebuggerCoordinates current = DebuggerCoordinates.NOWHERE;

    public TimeOverviewEventListener(TimeOverviewColorPlugin plugin) {
        this.p = plugin;
        this.listenForUntyped((EventType)DomainObjectEvent.RESTORED, this::objectRestored);
        this.listenFor((TraceEvent)TraceEvents.THREAD_ADDED, this::threadAdded);
        this.listenFor((TraceEvent)TraceEvents.THREAD_CHANGED, this::threadChanged);
        this.listenFor((TraceEvent)TraceEvents.THREAD_LIFESPAN_CHANGED, this::threadChanged);
        this.listenFor((TraceEvent)TraceEvents.THREAD_DELETED, this::threadDeleted);
        this.listenFor((TraceEvent)TraceEvents.MODULE_ADDED, this::moduleAdded);
        this.listenFor((TraceEvent)TraceEvents.MODULE_CHANGED, this::moduleChanged);
        this.listenFor((TraceEvent)TraceEvents.MODULE_LIFESPAN_CHANGED, this::moduleChanged);
        this.listenFor((TraceEvent)TraceEvents.MODULE_DELETED, this::moduleDeleted);
        this.listenFor((TraceEvent)TraceEvents.REGION_ADDED, this::regionAdded);
        this.listenFor((TraceEvent)TraceEvents.REGION_CHANGED, this::regionChanged);
        this.listenFor((TraceEvent)TraceEvents.REGION_LIFESPAN_CHANGED, this::regionChanged);
        this.listenFor((TraceEvent)TraceEvents.REGION_DELETED, this::regionDeleted);
        this.listenFor((TraceEvent)TraceEvents.BREAKPOINT_ADDED, this::bptAdded);
        this.listenFor((TraceEvent)TraceEvents.BREAKPOINT_CHANGED, this::bptChanged);
        this.listenFor((TraceEvent)TraceEvents.BREAKPOINT_LIFESPAN_CHANGED, this::bptChanged);
        this.listenFor((TraceEvent)TraceEvents.BREAKPOINT_DELETED, this::bptDeleted);
        this.listenFor((TraceEvent)TraceEvents.BOOKMARK_ADDED, this::bookmarkAdded);
        this.listenFor((TraceEvent)TraceEvents.BOOKMARK_CHANGED, this::bookmarkChanged);
        this.listenFor((TraceEvent)TraceEvents.BOOKMARK_LIFESPAN_CHANGED, this::bookmarkChanged);
        this.listenFor((TraceEvent)TraceEvents.BOOKMARK_DELETED, this::bookmarkDeleted);
    }

    public void coordinatesActivated(DebuggerCoordinates coordinates) {
        this.setCoordinates(coordinates);
        Trace trace = coordinates.getTrace();
        if (trace != null) {
            Swing.runLater(() -> this.processTrace(trace));
        }
    }

    protected void addListener() {
        Trace trace = this.current.getTrace();
        if (trace != null) {
            trace.addListener((DomainObjectListener)this);
        }
    }

    protected void removeListener() {
        Trace trace = this.current.getTrace();
        if (trace != null) {
            trace.removeListener((DomainObjectListener)this);
        }
    }

    public void setCoordinates(DebuggerCoordinates coordinates) {
        boolean doListeners;
        boolean bl = doListeners = !Objects.equals(this.current.getTrace(), coordinates.getTrace());
        if (doListeners) {
            this.removeListener();
        }
        this.current = coordinates;
        if (doListeners) {
            this.addListener();
        }
    }

    private void processTrace(Trace trace) {
        TraceThreadManager threadManager = trace.getThreadManager();
        for (Object thread : threadManager.getAllThreads()) {
            this.threadChanged((TraceThread)thread);
        }
        TraceModuleManager moduleManager = trace.getModuleManager();
        for (Object module : moduleManager.getAllModules()) {
            this.moduleChanged((TraceModule)module);
        }
        TraceMemoryManager memoryManager = trace.getMemoryManager();
        for (TraceMemoryRegion region : memoryManager.getAllRegions()) {
            this.regionChanged(region);
        }
        TraceBreakpointManager breakpointManager = trace.getBreakpointManager();
        for (TraceBreakpointLocation bpt : breakpointManager.getAllBreakpointLocations()) {
            this.bptChanged(bpt);
        }
    }

    private void threadAdded(TraceThread thread) {
        TraceObject obj = thread.getObject();
        obj.getOrderedValues((Lifespan)Lifespan.ALL, "_range", true).forEach(v -> {
            long snap = v.getMinSnap();
            this.p.updateMap(snap, TimeType.BPT_ADDED, thread.getName(snap), true);
        });
    }

    private void threadChanged(TraceThread thread) {
        TraceObject obj = thread.getObject();
        obj.getOrderedValues((Lifespan)Lifespan.ALL, "_tid", true).forEach(v -> {
            long snapMax;
            long snapMin = v.getMinSnap();
            if (snapMin == (snapMax = v.getMaxSnap())) {
                this.p.updateMap(snapMin, TimeType.THREAD_CHANGED, thread.getName(snapMin), true);
            } else {
                this.p.updateMap(snapMin, TimeType.THREAD_ADDED, thread.getName(snapMin), true);
                this.p.updateMap(snapMax, TimeType.THREAD_REMOVED, thread.getName(snapMax), true);
            }
        });
    }

    private void threadDeleted(TraceThread thread) {
        TraceObject obj = thread.getObject();
        obj.getOrderedValues((Lifespan)Lifespan.ALL, "_range", true).forEach(v -> {
            long snap = v.getMaxSnap();
            this.p.updateMap(snap, TimeType.THREAD_REMOVED, thread.getName(snap), true);
        });
    }

    private void moduleAdded(TraceModule module) {
        TraceObject obj = module.getObject();
        obj.getOrderedValues((Lifespan)Lifespan.ALL, "_range", true).forEach(v -> {
            long snap = v.getMinSnap();
            this.p.updateMap(snap, TimeType.MODULE_ADDED, module.getName(snap), true);
        });
    }

    private void moduleChanged(TraceModule module) {
        TraceObject obj = module.getObject();
        obj.getOrderedValues((Lifespan)Lifespan.ALL, "_range", true).forEach(v -> {
            long snapMax;
            long snapMin = v.getMinSnap();
            if (snapMin == (snapMax = v.getMaxSnap())) {
                this.p.updateMap(snapMin, TimeType.MODULE_CHANGED, module.getName(snapMin), true);
            } else {
                this.p.updateMap(snapMin, TimeType.MODULE_ADDED, module.getName(snapMin), true);
                this.p.updateMap(snapMax, TimeType.MODULE_REMOVED, module.getName(snapMax), true);
            }
        });
    }

    private void moduleDeleted(TraceModule module) {
        TraceObject obj = module.getObject();
        obj.getOrderedValues((Lifespan)Lifespan.ALL, "_range", true).forEach(v -> {
            long snap = v.getMaxSnap();
            this.p.updateMap(snap, TimeType.MODULE_REMOVED, module.getName(snap), true);
        });
    }

    private void regionAdded(TraceMemoryRegion region) {
        TraceObject obj = region.getObject();
        obj.getOrderedValues((Lifespan)Lifespan.ALL, "_range", true).forEach(v -> {
            long snap = v.getMinSnap();
            this.p.updateMap(snap, TimeType.REGION_ADDED, region.getName(snap), true);
        });
    }

    private void regionChanged(TraceMemoryRegion region) {
        TraceObject obj = region.getObject();
        obj.getOrderedValues((Lifespan)Lifespan.ALL, "_range", true).forEach(v -> {
            long snapMax;
            long snapMin = v.getMinSnap();
            if (snapMin == (snapMax = v.getMaxSnap())) {
                this.p.updateMap(snapMin, TimeType.REGION_CHANGED, region.getName(snapMin), true);
            } else {
                this.p.updateMap(snapMin, TimeType.REGION_ADDED, region.getName(snapMin), true);
                this.p.updateMap(snapMax, TimeType.REGION_REMOVED, region.getName(snapMax), true);
            }
        });
    }

    private void regionDeleted(TraceMemoryRegion region) {
        TraceObject obj = region.getObject();
        obj.getOrderedValues((Lifespan)Lifespan.ALL, "_range", true).forEach(v -> {
            long snap = v.getMaxSnap();
            this.p.updateMap(snap, TimeType.REGION_REMOVED, region.getName(snap), true);
        });
    }

    private void bptAdded(TraceBreakpointLocation bpt) {
        TraceObject obj = bpt.getObject();
        obj.getOrderedValues((Lifespan)Lifespan.ALL, "_range", true).forEach(v -> {
            long snap = v.getMinSnap();
            this.p.updateMap(snap, TimeType.BPT_ADDED, bpt.getName(snap), true);
        });
    }

    private void bptChanged(TraceBreakpointLocation bpt) {
        TraceObject obj = bpt.getObject();
        obj.getOrderedValues((Lifespan)Lifespan.ALL, "_range", true).forEach(v -> {
            long snapMax;
            long snapMin = v.getMinSnap();
            if (snapMin == (snapMax = v.getMaxSnap())) {
                this.p.updateMap(snapMin, TimeType.BPT_CHANGED, bpt.getName(snapMin), true);
            } else {
                this.p.updateMap(snapMin, TimeType.BPT_ADDED, bpt.getName(snapMin), true);
                this.p.updateMap(snapMax, TimeType.BPT_REMOVED, bpt.getName(snapMax), true);
            }
        });
    }

    private void bptDeleted(TraceBreakpointLocation bpt) {
        TraceObject obj = bpt.getObject();
        obj.getOrderedValues((Lifespan)Lifespan.ALL, "_range", true).forEach(v -> {
            long snap = v.getMaxSnap();
            this.p.updateMap(snap, TimeType.BPT_REMOVED, bpt.getName(snap), true);
        });
    }

    private void bookmarkAdded(TraceBookmark bookmark) {
        long snap = bookmark.getLifespan().lmin();
        this.p.updateMap(snap, TimeType.BOOKMARK_ADDED, bookmark.getComment(), true);
    }

    private void bookmarkChanged(TraceBookmark bookmark) {
        long snapMin = bookmark.getLifespan().lmin();
        this.p.updateMap(snapMin, TimeType.BOOKMARK_CHANGED, bookmark.getComment(), false);
    }

    private void bookmarkDeleted(TraceBookmark bookmark) {
        long snap = bookmark.getLifespan().lmax();
        this.p.updateMap(snap, TimeType.BOOKMARK_REMOVED, bookmark.getComment(), true);
    }

    private void objectRestored(DomainObjectChangeRecord domainobjectchangerecord1) {
        this.p.updateMap();
    }
}

