/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.objectiveC;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC1_Constants;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC1_MethodList;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC1_ProtocolList;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC1_State;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC1_Utilities;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC_MethodType;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.symbol.Namespace;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class ObjectiveC1_Category
implements StructConverter {
    public static final long SIZEOF = 0L;
    private ObjectiveC1_State _state;
    private long _index;
    private String category_name;
    private String class_name;
    private ObjectiveC1_MethodList instance_methods;
    private ObjectiveC1_MethodList class_methods;
    private ObjectiveC1_ProtocolList protocols;
    private int unknown0;
    private int unknown1;

    public ObjectiveC1_Category(ObjectiveC1_State state, BinaryReader reader) throws IOException {
        this._state = state;
        this._index = reader.getPointerIndex();
        this.category_name = reader.readAsciiString(reader.readNextInt());
        this.class_name = reader.readAsciiString(reader.readNextInt());
        this.instance_methods = new ObjectiveC1_MethodList(state, reader.clone(reader.readNextInt()), ObjectiveC_MethodType.INSTANCE);
        this.class_methods = new ObjectiveC1_MethodList(state, reader.clone(reader.readNextInt()), ObjectiveC_MethodType.CLASS);
        this.protocols = new ObjectiveC1_ProtocolList(state, reader.clone(reader.readNextInt()));
        if (state.isARM) {
            this.unknown0 = reader.readNextInt();
            this.unknown1 = reader.readNextInt();
        }
    }

    public String getCategoryName() {
        return this.category_name;
    }

    public String getClassName() {
        return this.class_name;
    }

    public ObjectiveC1_MethodList getInstanceMethods() {
        return this.instance_methods;
    }

    public ObjectiveC1_MethodList getClassMethods() {
        return this.class_methods;
    }

    public ObjectiveC1_ProtocolList getProtocols() {
        return this.protocols;
    }

    public int getUnknown0() {
        return this.unknown0;
    }

    public int getUnknown1() {
        return this.unknown1;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        String name = "objc_category";
        StructureDataType struct = new StructureDataType(name, 0);
        struct.setCategoryPath(ObjectiveC1_Constants.CATEGORY_PATH);
        struct.add((DataType)PointerDataType.getPointer((DataType)ASCII, (int)this._state.pointerSize), "category_name", null);
        struct.add((DataType)PointerDataType.getPointer((DataType)ASCII, (int)this._state.pointerSize), "class_name", null);
        struct.add((DataType)PointerDataType.getPointer((DataType)ObjectiveC1_MethodList.toGenericDataType(this._state), (int)this._state.pointerSize), "instance_methods", null);
        struct.add((DataType)PointerDataType.getPointer((DataType)ObjectiveC1_MethodList.toGenericDataType(this._state), (int)this._state.pointerSize), "class_methods", null);
        struct.add((DataType)PointerDataType.getPointer((DataType)ObjectiveC1_ProtocolList.toGenericDataType(this._state), (int)this._state.pointerSize), "protocols", null);
        if (this._state.isARM) {
            struct.add(DWORD, "unknown0", null);
            struct.add(DWORD, "unknown1", null);
        }
        return struct;
    }

    public void applyTo() throws Exception {
        if (this._state.beenApplied.contains(this._index)) {
            return;
        }
        this._state.beenApplied.add(this._index);
        Address address = this._state.program.getAddressFactory().getDefaultAddressSpace().getAddress(this._index);
        DataType dt = this.toDataType();
        this._state.program.getListing().clearCodeUnits(address, address.add((long)(dt.getLength() - 1)), false);
        this._state.program.getListing().createData(address, dt);
        Namespace namespace = ObjectiveC1_Utilities.createNamespace(this._state.program, "objc", "Categories", this.class_name + "(" + this.category_name + ")");
        this.instance_methods.applyTo(namespace);
        this.class_methods.applyTo(namespace);
        this.protocols.applyTo();
    }
}

