/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import docking.widgets.fieldpanel.field.AttributedString;
import docking.widgets.fieldpanel.field.FieldElement;
import docking.widgets.fieldpanel.field.TextFieldElement;
import docking.widgets.fieldpanel.support.FieldLocation;
import docking.widgets.fieldpanel.support.RowColLocation;
import generic.theme.GColor;
import ghidra.app.util.ListingHighlightProvider;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.field.ListingColors;
import ghidra.app.util.viewer.field.ListingField;
import ghidra.app.util.viewer.field.ListingTextField;
import ghidra.app.util.viewer.format.FieldFormatModel;
import ghidra.app.util.viewer.proxy.ProxyObj;
import ghidra.framework.options.Options;
import ghidra.framework.options.ToolOptions;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.mem.MemoryBlockSourceInfo;
import ghidra.program.model.mem.MemoryBlockType;
import ghidra.program.util.MemoryBlockStartFieldLocation;
import ghidra.program.util.ProgramLocation;
import java.awt.Color;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class MemoryBlockStartFieldFactory
extends FieldFactory {
    private static final String FIELD_NAME = "Memory Block Start";

    public MemoryBlockStartFieldFactory() {
        super(FIELD_NAME);
    }

    private MemoryBlockStartFieldFactory(FieldFormatModel model, ListingHighlightProvider hlProvider, Options displayOptions, Options fieldOptions) {
        super(FIELD_NAME, model, hlProvider, displayOptions, fieldOptions);
    }

    @Override
    public ListingField getField(ProxyObj<?> proxy, int varWidth) {
        if (!this.enabled) {
            return null;
        }
        Object obj = proxy.getObject();
        if (!(obj instanceof CodeUnit)) {
            return null;
        }
        CodeUnit cu = (CodeUnit)obj;
        List<AttributedString> attributedStrings = this.createBlockStartText(cu);
        if (attributedStrings == null || attributedStrings.isEmpty()) {
            return null;
        }
        List<FieldElement> elements = this.createFieldElements(attributedStrings);
        ListingTextField ltf = ListingTextField.createMultilineTextField(this, proxy, elements, this.startX + varWidth, this.width, 10, this.hlProvider);
        ltf.setPrimary(true);
        return ltf;
    }

    @Override
    public ProgramLocation getProgramLocation(int row, int col, ListingField bf) {
        String[] comments;
        Object proxyObject = bf.getProxy().getObject();
        if (!(proxyObject instanceof CodeUnit)) {
            return null;
        }
        CodeUnit cu = (CodeUnit)proxyObject;
        List<AttributedString> attributedStrings = this.createBlockStartText(cu);
        if (attributedStrings == null) {
            comments = new String[]{};
        } else {
            comments = new String[attributedStrings.size()];
            for (int i = 0; i < comments.length; ++i) {
                comments[i] = attributedStrings.get(i).getText();
            }
        }
        return new MemoryBlockStartFieldLocation(cu.getProgram(), cu.getMinAddress(), null, row, col, comments, 0);
    }

    @Override
    public FieldLocation getFieldLocation(ListingField listingField, BigInteger index, int fieldNum, ProgramLocation programLoc) {
        if (!(programLoc instanceof MemoryBlockStartFieldLocation)) {
            return null;
        }
        MemoryBlockStartFieldLocation blockLocation = (MemoryBlockStartFieldLocation)programLoc;
        Object obj = listingField.getProxy().getObject();
        if (obj instanceof CodeUnit) {
            CodeUnit cu = (CodeUnit)obj;
            MemoryBlock block = cu.getMemory().getBlock(cu.getAddress());
            if (block == null) {
                return null;
            }
            if (cu.getMinAddress().equals((Object)block.getStart()) && listingField instanceof ListingTextField) {
                ListingTextField listingTextField = (ListingTextField)listingField;
                RowColLocation location = listingTextField.dataToScreenLocation(blockLocation.getRow(), blockLocation.getCharOffset());
                return new FieldLocation(index, fieldNum, location.row(), location.col());
            }
        }
        return null;
    }

    @Override
    public boolean acceptsType(int category, Class<?> proxyObjectClass) {
        return category == 1;
    }

    @Override
    public FieldFactory newInstance(FieldFormatModel formatModel, ListingHighlightProvider provider, ToolOptions displayOptions, ToolOptions fieldOptions) {
        return new MemoryBlockStartFieldFactory(formatModel, provider, (Options)displayOptions, (Options)fieldOptions);
    }

    protected List<AttributedString> createBlockStartText(CodeUnit cu) {
        ArrayList<AttributedString> lines = new ArrayList<AttributedString>();
        MemoryBlock block = cu.getMemory().getBlock(cu.getAddress());
        if (block == null) {
            return null;
        }
        if (!cu.getMinAddress().equals((Object)block.getStart())) {
            return null;
        }
        MemoryBlockType blockType = block.getType();
        Object type = "";
        if (blockType != MemoryBlockType.DEFAULT) {
            type = block.isMapped() ? " (" + ((MemoryBlockSourceInfo)block.getSourceInfos().get(0)).getDescription() + ")" : " (" + String.valueOf(blockType) + ")";
        }
        String line1 = block.getName() + (String)type;
        String line2 = block.getComment();
        String line3 = block.getStart().toString(true) + "-" + block.getEnd().toString(true);
        GColor color = ListingColors.BLOCK_START;
        AttributedString borderAS = new AttributedString("//", (Color)color, this.getMetrics());
        lines.add(borderAS);
        lines.add(new AttributedString("// " + line1, (Color)color, this.getMetrics()));
        if (line2 != null && !line2.isEmpty()) {
            lines.add(new AttributedString("// " + line2, (Color)color, this.getMetrics()));
        }
        lines.add(new AttributedString("// " + line3, (Color)color, this.getMetrics()));
        lines.add(borderAS);
        return lines;
    }

    private List<FieldElement> createFieldElements(List<AttributedString> attributedStrings) {
        ArrayList<FieldElement> elements = new ArrayList<FieldElement>();
        int lineNum = 0;
        for (AttributedString line : attributedStrings) {
            TextFieldElement blockElement = new TextFieldElement(line, lineNum, 0);
            elements.add((FieldElement)blockElement);
            ++lineNum;
        }
        return elements;
    }
}

