/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompiler.taint;

import generic.theme.GColor;
import ghidra.app.plugin.core.decompiler.taint.TaintPlugin;
import ghidra.app.plugin.core.decompiler.taint.TaintProvider;
import ghidra.app.plugin.core.decompiler.taint.TaintState;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.Plugin;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import java.awt.Color;

public class TaintOptions {
    public static final String OP_KEY_TAINT_FACTS_DIR = "Taint.Directories.Facts";
    public static final String OP_KEY_TAINT_OUTPUT_DIR = "Taint.Directories.Output";
    public static final String OP_KEY_TAINT_ENGINE_PATH = "Taint.Directories.Engine";
    public static final String OP_KEY_TAINT_QUERY = "Taint.Query.Current Query";
    public static final String OP_KEY_TAINT_DB = "Taint.Query.Index";
    public static final String OP_KEY_TAINT_QUERY_ENGINE = "Taint.Query Engine";
    public static final String OP_KEY_TAINT_QUERY_DIRECTION = "Taint.Force Direction";
    public static final String OP_KEY_TAINT_QUERY_OUTPUT_FORM = "Taint.Output Format";
    public static final String TAINT_HIGHLIGHT = "Taint.Highlight Color";
    public static final String TAINT_HIGHLIGHT_STYLE = "Taint.Highlight Style";
    public static final String TAINT_ALL_ACCESS = "Taint.Match on Fields";
    private static final Boolean TAINT_ALL_ACCESS_PATHS = true;
    public static final String DEFAULT_TAINT_ENGINE_PATH = "";
    public static final String DEFAULT_TAINT_FACTS_DIR = "";
    public static final String DEFAULT_TAINT_OUTPUT_DIR = "";
    public static final String DEFAULT_TAINT_QUERY = "taintquery.dl";
    public static final String DEFAULT_TAINT_DB = "ctadlir.db";
    public static final Boolean DEFAULT_GET_PATHS = true;
    private static final GColor TAINT_HIGHLIGHT_COLOR = new GColor("color.bg.listing.highlighter.middle.mouse");
    private static final TaintPlugin.Highlighter TAINT_HIGHLIGHT_STYLE_DEFAULT = TaintPlugin.Highlighter.DEFAULT;
    private String taintEnginePath;
    private String taintFactsDir;
    private String taintOutputDir;
    private String taintQuery;
    private String taintDB;
    private String taintQueryEngine;
    private TaintPlugin.TaintDirection taintQueryDirection;
    private TaintPlugin.TaintFormat taintQueryOutputForm;
    private TaintPlugin.Highlighter taintHighlightStyle;
    private Color taintHighlightColor;
    private Boolean taintUseAllAccess;
    private TaintProvider taintProvider;

    public static String makeDBName(String base, String binary_name) {
        StringBuilder sb = new StringBuilder();
        String[] parts = base.split("\\.");
        for (int i = 0; i < parts.length; ++i) {
            if (i > 0) {
                sb.append(".");
            }
            if (i == 2) {
                sb.append(binary_name);
                sb.append(".");
            }
            sb.append(parts[i]);
        }
        return sb.toString();
    }

    public TaintOptions(TaintProvider provider) {
        this.taintProvider = provider;
        this.taintEnginePath = "";
        this.taintFactsDir = "";
        this.taintOutputDir = "";
        this.taintQuery = DEFAULT_TAINT_QUERY;
        this.taintDB = DEFAULT_TAINT_DB;
        this.taintQueryOutputForm = TaintPlugin.TaintFormat.ALL;
        this.taintQueryDirection = TaintPlugin.TaintDirection.DEFAULT;
        this.taintUseAllAccess = TAINT_ALL_ACCESS_PATHS;
    }

    public void registerOptions(Plugin ownerPlugin, ToolOptions opt, Program program) {
        opt.registerOption(OP_KEY_TAINT_QUERY_OUTPUT_FORM, (Object)TaintPlugin.TaintFormat.ALL, new HelpLocation("DecompilePlugin", "Taint Output Type"), "The type of Source-Sink query output (e.g., sarif, summary, text)");
        opt.registerOption(OP_KEY_TAINT_QUERY_ENGINE, (Object)"", new HelpLocation("DecompilePlugin", "Taint Query Engine"), "The query engine (e.g., angr, ctadl)");
        opt.registerOption(OP_KEY_TAINT_ENGINE_PATH, (Object)"", new HelpLocation("DecompilePlugin", "Taint Engine Directory"), "Base path to external taint engine (Source-Sink executable).");
        opt.registerOption(OP_KEY_TAINT_FACTS_DIR, (Object)"", new HelpLocation("DecompilePlugin", "Taint Facts Directory"), "Base Path to facts directory");
        opt.registerOption(OP_KEY_TAINT_OUTPUT_DIR, (Object)"", new HelpLocation("DecompilePlugin", "Taint Output Directory"), "Base Path to output directory");
        opt.registerOption(OP_KEY_TAINT_QUERY, (Object)DEFAULT_TAINT_QUERY, new HelpLocation("DecompilePlugin", "TaintQuery"), "File where the query text that Ghidra produces is written.");
        opt.registerOption(OP_KEY_TAINT_DB, (Object)DEFAULT_TAINT_DB, new HelpLocation("DecompilePlugin", "Taint Database"), "File where the index is written for the binary.");
        opt.registerThemeColorBinding(TAINT_HIGHLIGHT, TAINT_HIGHLIGHT_COLOR.getId(), new HelpLocation("DecompilePlugin", "TaintTokenColor"), "Color used for highlighting tainted variables.");
        opt.registerOption(TAINT_ALL_ACCESS, (Object)TAINT_ALL_ACCESS_PATHS, new HelpLocation("DecompilePlugin", "TaintAllAccess"), "Use all access paths.");
        this.grabFromToolAndProgram(ownerPlugin, opt, program);
    }

    public void grabFromToolAndProgram(Plugin ownerPlugin, ToolOptions opt, Program program) {
        TaintPlugin plugin;
        TaintState state;
        String engine = opt.getString(OP_KEY_TAINT_QUERY_ENGINE, "").trim();
        if (!engine.equals(this.taintQueryEngine) && (state = TaintState.newInstance(plugin = (TaintPlugin)ownerPlugin, engine)) != null) {
            plugin.setTaintState(state);
            this.taintQueryEngine = engine;
        }
        this.taintEnginePath = opt.getString(OP_KEY_TAINT_ENGINE_PATH, "");
        this.taintFactsDir = opt.getString(OP_KEY_TAINT_FACTS_DIR, "");
        this.taintQuery = opt.getString(OP_KEY_TAINT_QUERY, "");
        this.taintOutputDir = opt.getString(OP_KEY_TAINT_OUTPUT_DIR, "");
        this.taintDB = opt.getString(OP_KEY_TAINT_DB, "");
        this.taintQueryDirection = (TaintPlugin.TaintDirection)opt.getEnum(OP_KEY_TAINT_QUERY_DIRECTION, (Enum)TaintPlugin.TaintDirection.DEFAULT);
        this.taintQueryOutputForm = (TaintPlugin.TaintFormat)opt.getEnum(OP_KEY_TAINT_QUERY_OUTPUT_FORM, (Enum)TaintPlugin.TaintFormat.ALL);
        this.taintHighlightStyle = (TaintPlugin.Highlighter)opt.getEnum(TAINT_HIGHLIGHT_STYLE, (Enum)TAINT_HIGHLIGHT_STYLE_DEFAULT);
        this.taintHighlightColor = opt.getColor(TAINT_HIGHLIGHT, (Color)TAINT_HIGHLIGHT_COLOR);
        this.taintUseAllAccess = opt.getBoolean(TAINT_ALL_ACCESS, TAINT_ALL_ACCESS_PATHS.booleanValue());
    }

    public TaintPlugin.TaintFormat getTaintOutputForm() {
        return this.taintQueryOutputForm;
    }

    public String getTaintEngineType() {
        return this.taintQueryEngine;
    }

    public String getTaintEnginePath() {
        return this.taintEnginePath;
    }

    public String getTaintFactsDirectory() {
        return this.taintFactsDir;
    }

    public String getTaintOutputDirectory() {
        return this.taintOutputDir;
    }

    public String getTaintQueryDLName() {
        return this.taintQuery;
    }

    public String getTaintQueryDBName() {
        return this.taintDB;
    }

    public String getTaintQueryDBName(String name) {
        return TaintOptions.makeDBName(this.taintDB, name);
    }

    public String getTaintIndexDBName() {
        return this.taintDB;
    }

    public String getTaintIndexDBName(String name) {
        return TaintOptions.makeDBName(this.taintDB, name);
    }

    public Color getTaintHighlightColor() {
        return this.taintHighlightColor;
    }

    public TaintPlugin.Highlighter getTaintHighlightStyle() {
        return this.taintHighlightStyle;
    }

    public TaintPlugin.TaintDirection getTaintDirection() {
        return this.taintQueryDirection;
    }

    public Boolean getTaintUseAllAccess() {
        return this.taintUseAllAccess;
    }

    public void setTaintQueryEngine(String engine) {
        this.taintQueryEngine = engine;
        this.taintProvider.setOption(OP_KEY_TAINT_QUERY_ENGINE, engine);
    }

    public void setTaintOutputForm(TaintPlugin.TaintFormat form) {
        this.taintQueryOutputForm = form;
        this.taintProvider.setOption(OP_KEY_TAINT_QUERY_OUTPUT_FORM, form.getOptionString());
    }

    public void setTaintFactsDirectory(String path) {
        this.taintFactsDir = path;
        this.taintProvider.setOption("", path);
    }

    public void setTaintOutputDirectory(String path) {
        this.taintOutputDir = path;
        this.taintProvider.setOption(OP_KEY_TAINT_OUTPUT_DIR, path);
    }

    public void setTaintQueryName(String filename) {
        this.taintQuery = filename;
        this.taintProvider.setOption(OP_KEY_TAINT_QUERY, filename);
    }

    public void setTaintIndexDBName(String filename) {
        this.taintDB = filename;
        this.taintProvider.setOption(OP_KEY_TAINT_DB, filename);
    }

    public void setTaintHighlightColor(Color color) {
        this.taintHighlightColor = color;
        this.taintProvider.setColor(TAINT_HIGHLIGHT, color);
    }

    public void setTaintHighlightStyle(TaintPlugin.Highlighter style) {
        this.taintHighlightStyle = style;
        this.taintProvider.setOption(TAINT_HIGHLIGHT_STYLE, style.getOptionString());
        this.taintProvider.changeHighlighter(style);
    }

    public void setTaintDirection(TaintPlugin.TaintDirection direction) {
        this.taintQueryDirection = direction;
        this.taintProvider.setOption(OP_KEY_TAINT_QUERY_DIRECTION, direction.getOptionString());
    }

    public void setTaintAllAccess(Boolean allAccess) {
        this.taintUseAllAccess = allAccess;
    }
}

