---
stage: Security Risk Management
group: Security Policies
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: マージリクエスト承認ポリシーを使用してGitLabのセキュリティルールを適用し、プロジェクト全体のスキャン、承認、およびコンプライアンスを自動化する方法について説明します。
title: セキュリティポリシープロジェクト
---

{{< details >}}

- プラン: Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

セキュリティポリシープロジェクトを使用すると、複数のプロジェクトにわたってポリシーを適用できます。セキュリティポリシープロジェクトは、ポリシーのみを格納するための特別なタイプのプロジェクトです。セキュリティポリシープロジェクトに含まれるポリシーを適用するには、セキュリティポリシープロジェクトを、ポリシーを適用するプロジェクト、サブグループ、またはグループにリンクします。セキュリティポリシープロジェクトには複数のポリシーを含めることができますが、それらはまとめて適用されます。グループまたはサブグループで適用されたセキュリティポリシープロジェクトは、すべてのサブグループとそのプロジェクトを含め、その階層以下のすべてに適用されます。

マージリクエストで適用されたポリシーの変更は、マージリクエストがマージされるとすぐに有効になります。マージリクエストを経由せず、デフォルトブランチに直接コミットされた変更は、ポリシーの変更が有効になるまでに最大10分かかります。

ポリシーは、`.gitlab/security-policies/policy.yml` YAMLファイルに保存されます。

## セキュリティポリシープロジェクトの実装 {#security-policy-project-implementation}

セキュリティポリシープロジェクトの実装オプションは、GitLab.com、GitLab Dedicated、GitLab Self-Managedで若干異なります。主な違いは、GitLab.comではサブグループのみを作成できることです。職務分離を確実にするには、よりきめ細かい権限設定が必要です。

### GitLab.comネームスペースでポリシーをグローバルに適用する {#enforce-policies-globally-in-your-gitlabcom-namespace}

{{< details >}}

- プラン: Ultimate
- 提供形態: GitLab.com

{{< /details >}}

前提要件: 

- セキュリティポリシープロジェクトにリンクするには、オーナーロールまたは`manage_security_policy_link`権限を持つ[カスタムロール](../../../custom_roles/_index.md)が必要です。詳細については、[職務分離](_index.md#separation-of-duties)を参照してください。

GitLab.comネームスペース内のすべてのサブグループとプロジェクト全体でポリシーをグローバルに適用するための概要ワークフロー:

1. トップレベルグループから**ポリシー**タブにアクセスします。
1. サブグループで、**ポリシー**タブに移動し、テストポリシーを作成します。

   テスト用にポリシーを無効にして作成できます。ポリシーを作成すると、トップレベルグループの下に新しいセキュリティポリシープロジェクトが自動的に作成されます。このプロジェクトは、`policy.yml`またはpolicy-as-codeを保存するために使用されます。
1. 必要に応じて、新しく作成したプロジェクトの権限を確認および設定します。

   デフォルトでは、オーナーとメンテナーはポリシーを作成、編集、および削除できます。デベロッパーはポリシーの変更を提案できますが、マージすることはできません。
1. サブグループ内に作成されたセキュリティポリシープロジェクトで、必要なポリシーを作成します。

   作成した`Security Policy Management`プロジェクトの**ポリシー**タブにあるポリシーエディタを使用できます。または、新しく作成したセキュリティポリシープロジェクト`Security Policy Management - security policy project`に保存されている`policy.yml`ファイルで、ポリシーを直接更新することもできます。
1. グループ、サブグループ、またはプロジェクトをセキュリティポリシープロジェクトにリンクします。

   サブグループのオーナー、または適切な権限を持つプロジェクトのオーナーは、**ポリシー**ページにアクセスし、セキュリティポリシープロジェクトへのリンクを作成できます。プロジェクトの名前は、フルパス表記とし、「- security policy project」で終わる必要があります。リンクされているすべてのグループ、サブグループ、プロジェクトは、セキュリティポリシープロジェクトで作成されたポリシーによって「適用可能」になります。詳細については、[セキュリティポリシープロジェクトへのリンク](#link-to-a-security-policy-project)を参照してください。
1. デフォルトでは、ポリシーが有効になると、リンクされているグループ、サブグループ、プロジェクト内のすべてのプロジェクトにそのポリシーが適用されます。

   よりきめ細かく適用するには、ポリシースコープを追加します。ポリシースコープを使用すると、特定のプロジェクトセット、またはコンプライアンスフレームワークラベルを含むプロジェクトに対してポリシーを適用できます。
1. たとえば、継承された権限のブロックや、ポリシー変更に対する追加のレビューまたは承認の要求など、追加の制限が必要な場合は、セキュリティポリシープロジェクトのみにスコープが設定された追加のポリシーを作成し、追加の承認を適用します。

### GitLab DedicatedまたはGitLab Self-Managedでポリシーをグローバルに適用する {#enforce-policies-globally-in-gitlab-dedicated-or-gitlab-self-managed}

{{< details >}}

- プラン: Ultimate
- 提供形態: GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

{{< alert type="note" >}}

GitLab Self-Managedでは、[コンプライアンスとセキュリティポリシーグループ](compliance_and_security_policy_groups.md)を使用して、インスタンス全体のセキュリティポリシーを適用することもできます。

{{< /alert >}}

前提要件: 

- セキュリティポリシープロジェクトにリンクするには、オーナーロールまたは`manage_security_policy_link`権限を持つ[カスタムロール](../../../custom_roles/_index.md)が必要です。詳細については、[職務分離](_index.md#separation-of-duties)を参照してください。
- インスタンス全体で承認グループをグローバルにサポートするには、[GitLabインスタンスアプリケーションの設定](../../../../api/settings.md)で`security_policy_global_group_approvers_enabled`を有効にします。

複数のグループ全体にポリシーを適用するための概要ワークフロー:

1. ポリシーを格納し、職務分離を確保するために、別のグループを作成します。

   別のスタンドアロングループを作成することで、権限を継承するユーザーの数を最小限に抑えることができます。
1. 新しいグループで、**ポリシー**タブにアクセスします。

   このタブにはポリシーエディタがあり、UIによりポリシーの作成や管理ができます。
1. テストポリシーを作成します（テスト目的でポリシーを無効な状態で作成できます）。

   ポリシーを作成すると、グループの下に新しいセキュリティポリシープロジェクトが自動的に作成されます。このプロジェクトは、`policy.yml`またはpolicy-as-codeを保存するために使用されます。
1. 必要に応じて、新しく作成したプロジェクトの権限を確認および設定します。

   デフォルトでは、オーナーとメンテナーはポリシーを作成、編集、および削除できます。デベロッパーはポリシーの変更を提案できますが、マージすることはできません。
1. サブグループで作成したセキュリティポリシープロジェクトで、必要なポリシーを作成します。

   作成した`Security Policy Management`プロジェクトのポリシータブにあるポリシーエディタを使用できます。または、新しく作成したセキュリティポリシープロジェクト`Security Policy Management - security policy project`に保存されている`policy.yml`ファイルで、ポリシーを直接更新することもできます。
1. グループ、サブグループ、またはプロジェクトをセキュリティポリシープロジェクトにリンクします。

   サブグループのオーナー、または適切な権限を持つプロジェクトのオーナーは、**ポリシー**ページにアクセスし、セキュリティポリシープロジェクトへのリンクを作成できます。プロジェクトの名前は、フルパス表記とし、「- security policy project」で終わる必要があります。リンクされているすべてのグループ、サブグループ、プロジェクトは、セキュリティポリシープロジェクトで作成されたポリシーによって「適用可能」になります。詳細については、[セキュリティポリシープロジェクトへのリンク](#link-to-a-security-policy-project)を参照してください。
1. デフォルトでは、ポリシーが有効になると、リンクされているグループ、サブグループ、プロジェクト内のすべてのプロジェクトにそのポリシーが適用されます。よりきめ細かく適用するには、ポリシースコープを追加します。ポリシースコープを使用すると、特定のプロジェクトセット、またはコンプライアンスフレームワークラベルを含むプロジェクトに対してポリシーを適用できます。
1. たとえば、継承された権限のブロックや、ポリシー変更に対する追加のレビューまたは承認の要求など、追加の制限が必要な場合は、セキュリティポリシープロジェクトのみにスコープが設定された追加のポリシーを作成し、追加の承認を適用します。

## セキュリティポリシープロジェクトへのリンク {#link-to-a-security-policy-project}

セキュリティポリシープロジェクトに含まれるポリシーをグループ、サブグループ、またはプロジェクトに対して適用するには、それらをリンクします。デフォルトでは、リンクされているすべてのエンティティに適用されます。ポリシーごとにきめ細かくポリシーを適用するには、各ポリシーでスコープを設定します。

前提要件: 

- セキュリティポリシープロジェクトにリンクするには、オーナーロールまたは`manage_security_policy_link`権限を持つ[カスタムロール](../../../custom_roles/_index.md)が必要です。詳細については、[職務分離](../_index.md#separation-of-duties)を参照してください。

グループ、サブグループ、またはプロジェクトをセキュリティポリシープロジェクトにリンクするには:

1. 左側のサイドバーで、**検索または移動先**を選択し、プロジェクト、サブグループ、またはグループを見つけます。
1. 左側のサイドバーで、**セキュリティ** > **ポリシー**を選択します。
1. **Edit Policy Project**（ポリシープロジェクトを編集）を選択し、ドロップダウンリストからリンクするプロジェクトを検索して選択します。
1. **保存**を選択します。

セキュリティポリシープロジェクトのリンクを解除するには、同じ手順に従いますが、ダイアログでゴミ箱アイコンを選択します。同じトップレベルグループ内の別のサブグループから、または完全に異なるトップレベルグループからセキュリティポリシープロジェクトにリンクできます。ただし、[パイプライン実行ポリシー](../pipeline_execution_policies.md#schema)を適用する場合、パイプラインをトリガーするには、ユーザーには少なくとも、そのポリシーで参照されているCI/CD設定を含むプロジェクトに対する読み取り専用アクセス権が必要です。

### リンクされたセキュリティポリシープロジェクトを表示する {#viewing-the-linked-security-policy-project}

プロジェクトポリシーページへのアクセス権があり、プロジェクトオーナーではないすべてのユーザーには、関連付けられたセキュリティポリシープロジェクトにリンクするボタンが表示されます。

1つのセキュリティポリシープロジェクトを複数のグループまたはプロジェクトにリンクできます。リンクされた1つのグループまたはプロジェクトのセキュリティポリシーを表示する権限を持つすべてのユーザーは、他のリンクされたグループおよびプロジェクトでどのセキュリティポリシーが適用されているかを判断できます。

## ポリシー制限の変更 {#changing-policy-limits}

{{< details >}}

- 提供形態: GitLab Self-Managed

{{< /details >}}

{{< history >}}

- GitLab 18.3で[構成可能な制限が導入](https://gitlab.com/groups/gitlab-org/-/epics/8084)されました。

{{< /history >}}

パフォーマンス上の理由から、GitLabは、セキュリティポリシープロジェクトで設定できるポリシーの数を制限しています。

{{< alert type="warning" >}}

制限を、セキュリティポリシープロジェクトに現在保存されているポリシーの数より少なくすると、GitLabは制限を超えたポリシーを適用しません。ポリシーを再度有効にするには、制限を、最大のセキュリティポリシープロジェクトのポリシーの数と一致するように増やします。

{{< /alert >}}

デフォルトの制限は次のとおりです:

| ポリシーの種類                       | デフォルトのポリシー制限   |
| --------------------------------- | ---------------------- |
| マージリクエスト承認ポリシー   | 5                      |
| スキャン実行ポリシー           | 5                      |
| パイプライン実行ポリシー       | 5                      |
| 脆弱性管理ポリシー | 5                      |

GitLab Self-Managedインスタンスでは、管理者はインスタンス全体のインスタンス制限を調整できます。各ポリシータイプの上限は20個です。管理者は、特定のトップレベルグループの制限を変更することもできます。

### インスタンスのポリシー制限を変更する {#change-the-policy-limits-for-an-instance}

組織がセキュリティポリシープロジェクトに保存できるポリシーの最大数を変更するには:

1. **管理者エリア** > **設定** > **セキュリティとコンプライアンス**に移動します。
1. **セキュリティポリシー**セクションを展開します。
1. 変更するポリシーの種類ごとに、**Maximum number of {policy type} allowed per security policy configuration**（セキュリティポリシー設定ごとに許可される{ポリシーの種類}の最大数）の新しい値を設定します。
1. **変更を保存**を選択します。

#### トップレベルグループのポリシー制限を変更する {#change-the-policy-limits-for-a-top-level-group}

グループ制限は、設定またはデフォルトのインスタンス制限を超える可能性があります。トップレベルグループのセキュリティポリシープロジェクトに組織が保存できるポリシーの最大数を変更するには:

{{< alert type="note" >}}

これらの制限を増やすと、特に多数の複雑なポリシーを適用する場合、システムパフォーマンスに影響を与える可能性があります。

{{< /alert >}}

トップレベルグループの制限値を調整するには:

1. **管理者エリア** > **概要** > **グループ**に移動します。
1. 変更するトップレベルグループの行で、**編集**を選択します。
1. 変更するポリシーの種類ごとに、**Maximum number of {policy type} allowed per security policy configuration**（セキュリティポリシー設定ごとに許可される{ポリシーの種類}の最大数）の新しい値を設定します。
1. **変更を保存**を選択します。

個々のグループの制限を`0`に設定すると、システムはインスタンス全体のデフォルト値を使用します。これにより、制限がゼロのグループでも、デフォルトのインスタンス構成に従ってポリシーを作成できます。

## セキュリティポリシープロジェクトの削除 {#delete-a-security-policy-project}

{{< history >}}

- セキュリティポリシープロジェクトの削除に対する保護は、GitLab 17.8で`reject_security_policy_project_deletion`フラグとともに導入されました。デフォルトでは有効になっています。
- セキュリティポリシープロジェクトを含むグループの削除に対する保護は、GitLab 17.9で`reject_security_policy_project_deletion_groups`フラグとともに導入されました。デフォルトでは有効になっています。
- セキュリティポリシープロジェクトとセキュリティポリシープロジェクトを含むグループの削除に対する保護は、GitLab 17.10で一般提供されています。機能フラグ`reject_security_policy_project_deletion`および`reject_security_policy_project_deletion_groups`は削除されました。

{{< /history >}}

セキュリティポリシープロジェクトまたはその親グループの1つを削除するには、他のグループまたはプロジェクトから削除対象へのリンクをすべて削除する必要があります。そうしないと、リンクされたセキュリティポリシープロジェクトまたは親グループを削除する際にエラーメッセージが表示されます。
