---
stage: GitLab Delivery
group: Operate
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: Read through the GitLab installation methods.
title: Install GitLab
---

You can install GitLab on most GNU/Linux distributions, on several
cloud providers, and in Kubernetes clusters.
To get the best experience, you should balance performance, reliability,
ease of administration (backups, upgrades, and troubleshooting) with the cost of hosting.

{{< cards >}}

- [Installation requirements](requirements.md)
- [Installation methods](install_methods.md)
- [Install GitLab on a cloud provider](cloud_providers.md)
- [Offline GitLab](../topics/offline/_index.md)
- [Reference architectures](../administration/reference_architectures/_index.md)
- [Upgrade GitLab](../update/_index.md)
- [Install GitLab Runner](https://docs.gitlab.com/runner/install/ "Run CI/CD jobs in a pipeline.")
- [Configure GitLab Runner](https://docs.gitlab.com/runner/configuration/ "Configuration and monitoring options.")
- [Install GitLab AI Gateway](install_ai_gateway.md)

{{< /cards >}}
