/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.cmd;

import java.util.ArrayList;
import java.util.List;
import tim.prune.cmd.Command;
import tim.prune.cmd.InsertMediaCmd;
import tim.prune.cmd.MediaInsertion;
import tim.prune.data.AudioClip;
import tim.prune.data.MediaObject;
import tim.prune.data.Photo;
import tim.prune.data.TrackInfo;

public class RemoveMediaCmd
extends Command {
    protected final ArrayList<MediaObject> _media = new ArrayList();

    public RemoveMediaCmd(List<MediaObject> list) {
        this(null, list);
    }

    RemoveMediaCmd(Command command, List<MediaObject> list) {
        super(command);
        if (list != null) {
            this._media.addAll(list);
        }
    }

    @Override
    public int getUpdateFlags() {
        return 16;
    }

    @Override
    protected boolean executeCommand(TrackInfo trackInfo) {
        for (MediaObject mediaObject : this._media) {
            if (mediaObject instanceof Photo) {
                trackInfo.getPhotoList().delete((Photo)mediaObject);
                continue;
            }
            if (mediaObject instanceof AudioClip) {
                trackInfo.getAudioList().delete((AudioClip)mediaObject);
                continue;
            }
            return false;
        }
        return !this._media.isEmpty();
    }

    @Override
    protected Command makeInverse(TrackInfo trackInfo) {
        ArrayList<MediaInsertion> arrayList = new ArrayList<MediaInsertion>();
        for (MediaObject mediaObject : this._media) {
            MediaObject mediaObject2;
            if (mediaObject instanceof Photo) {
                mediaObject2 = (Photo)mediaObject;
                arrayList.add(new MediaInsertion(mediaObject2, trackInfo.getPhotoList().getIndexOf((Photo)mediaObject2)));
                continue;
            }
            if (!(mediaObject instanceof AudioClip)) continue;
            mediaObject2 = (AudioClip)mediaObject;
            arrayList.add(new MediaInsertion(mediaObject2, trackInfo.getAudioList().getIndexOf((AudioClip)mediaObject2)));
        }
        return new InsertMediaCmd(this, arrayList);
    }
}

