/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang;

import com.intellij.lang.ITokenTypeRemapper;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.WhitespaceSkippedCallback;
import com.intellij.lang.WhitespacesAndCommentsBinder;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface SyntaxTreeBuilder {
    @NotNull
    public CharSequence getOriginalText();

    public void advanceLexer();

    @Nullable
    public IElementType getTokenType();

    public void setTokenTypeRemapper(@Nullable ITokenTypeRemapper var1);

    public void remapCurrentToken(@NotNull IElementType var1);

    default public void remapCurrentTokenAndRestoreOnRollback(@NotNull IElementType type) {
        if (type == null) {
            SyntaxTreeBuilder.$$$reportNull$$$0(0);
        }
        throw new UnsupportedOperationException();
    }

    public void setWhitespaceSkippedCallback(@Nullable WhitespaceSkippedCallback var1);

    @Nullable
    public IElementType lookAhead(int var1);

    @Nullable
    public IElementType rawLookup(int var1);

    public int rawTokenTypeStart(int var1);

    public int rawTokenIndex();

    @NonNls
    @Nullable
    public String getTokenText();

    default public void rawAdvanceLexer(int steps) {
        if (steps < 0) {
            throw new IllegalArgumentException("Steps must be a positive integer - lexer can only be advanced. Use Marker.rollbackTo if you want to rollback PSI building.");
        }
        if (steps == 0) {
            return;
        }
        int offset = this.rawTokenTypeStart(steps);
        while (!this.eof() && this.getCurrentOffset() < offset) {
            this.advanceLexer();
        }
    }

    public int getCurrentOffset();

    @NotNull
    public Marker mark();

    public void error(@NlsContexts.ParsingError @NotNull String var1);

    public boolean eof();

    public void setDebugMode(boolean var1);

    public void enforceCommentTokens(@NotNull TokenSet var1);

    @Nullable
    public LighterASTNode getLatestDoneMarker();

    @NotNull
    default public List<? extends Production> getProductions() {
        throw new UnsupportedOperationException("not implemented for this kind of Builder");
    }

    default public boolean isWhitespaceOrComment(@NotNull IElementType elementType) {
        if (elementType == null) {
            SyntaxTreeBuilder.$$$reportNull$$$0(1);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/SyntaxTreeBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "remapCurrentTokenAndRestoreOnRollback";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isWhitespaceOrComment";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface Marker
    extends Production {
        @NotNull
        public Marker precede();

        public void drop();

        public void rollbackTo();

        public void done(@NotNull IElementType var1);

        public void collapse(@NotNull IElementType var1);

        public void doneBefore(@NotNull IElementType var1, @NotNull Marker var2);

        public void doneBefore(@NotNull IElementType var1, @NotNull Marker var2, @NlsContexts.ParsingError @NotNull String var3);

        public void error(@NlsContexts.ParsingError @NotNull String var1);

        public void errorBefore(@NlsContexts.ParsingError @NotNull String var1, @NotNull Marker var2);

        public void setCustomEdgeTokenBinders(@Nullable WhitespacesAndCommentsBinder var1, @Nullable WhitespacesAndCommentsBinder var2);
    }

    public static interface Production
    extends LighterASTNode {
        @Override
        default public IElementType getTokenType() {
            throw new UnsupportedOperationException("not implemented for this kind of markers");
        }

        @Override
        default public int getStartOffset() {
            throw new UnsupportedOperationException("not implemented for this kind of markers");
        }

        @Override
        default public int getEndOffset() {
            throw new UnsupportedOperationException("not implemented for this kind of markers");
        }

        default public int getStartIndex() {
            throw new UnsupportedOperationException("not implemented for this kind of markers");
        }

        default public int getEndIndex() {
            throw new UnsupportedOperationException("not implemented for this kind of markers");
        }

        @NlsContexts.DetailedDescription
        @Nullable
        default public String getErrorMessage() {
            return null;
        }

        default public boolean isCollapsed() {
            return false;
        }
    }
}

