/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.util.lang.ClassPath;
import com.intellij.util.lang.ClasspathCache;
import com.intellij.util.lang.EmptyZipFile;
import com.intellij.util.lang.HashMapZipFile;
import com.intellij.util.lang.ImmutableZipEntry;
import com.intellij.util.lang.ImmutableZipFile;
import com.intellij.util.lang.JarLoader;
import com.intellij.util.lang.Resource;
import com.intellij.util.lang.ResourceFile;
import com.intellij.util.lang.ZipFile;
import com.intellij.util.lang.ZipFilePool;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.nio.ByteBuffer;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ZipResourceFile
implements ResourceFile {
    private final ZipFile zipFile;
    private final boolean defineClassUsingBytes;

    ZipResourceFile(@NotNull Path file, boolean defineClassUsingBytes, @Nullable ZipFilePool zipFilePool) {
        if (file == null) {
            ZipResourceFile.$$$reportNull$$$0(0);
        }
        this.defineClassUsingBytes = defineClassUsingBytes;
        try {
            if (zipFilePool == null) {
                this.zipFile = ZipFile.load(file);
            } else {
                Object zipFile = zipFilePool.loadZipFile(file);
                this.zipFile = (ZipFile)zipFile;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void processResources(@NotNull String dir, @NotNull Predicate<? super String> nameFilter, @NotNull BiConsumer<? super String, ? super InputStream> consumer) throws IOException {
        if (dir == null) {
            ZipResourceFile.$$$reportNull$$$0(1);
        }
        if (nameFilter == null) {
            ZipResourceFile.$$$reportNull$$$0(2);
        }
        if (consumer == null) {
            ZipResourceFile.$$$reportNull$$$0(3);
        }
        this.zipFile.processResources(dir, nameFilter, consumer);
    }

    @Override
    @Nullable
    public Attributes loadManifestAttributes() throws IOException {
        try (InputStream stream = this.zipFile.getInputStream("META-INF/MANIFEST.MF");){
            if (stream == null) {
                Attributes attributes = null;
                return attributes;
            }
            Attributes attributes = new Manifest(stream).getMainAttributes();
            return attributes;
        }
    }

    @Override
    @NotNull
    public ClasspathCache.IndexRegistrar buildClassPathCacheData() {
        if (this.zipFile instanceof ImmutableZipFile) {
            final ImmutableZipFile file = (ImmutableZipFile)this.zipFile;
            return new ClasspathCache.IndexRegistrar(){

                @Override
                public int classPackageCount() {
                    return file.classPackages.length;
                }

                @Override
                public int resourcePackageCount() {
                    return file.resourcePackages.length;
                }

                @Override
                public long[] classPackages() {
                    return file.classPackages;
                }

                @Override
                public long[] resourcePackages() {
                    return file.resourcePackages;
                }
            };
        }
        if (this.zipFile instanceof EmptyZipFile) {
            return new ClasspathCache.LoaderDataBuilder();
        }
        return this.computePackageIndex();
    }

    @NotNull
    private ClasspathCache.LoaderDataBuilder computePackageIndex() {
        ClasspathCache.LoaderDataBuilder builder = new ClasspathCache.LoaderDataBuilder();
        for (ImmutableZipEntry entry : ((HashMapZipFile)this.zipFile).getRawNameSet()) {
            if (entry == null) continue;
            builder.addPackageFromName(entry.name);
        }
        ClasspathCache.LoaderDataBuilder loaderDataBuilder = builder;
        if (loaderDataBuilder == null) {
            ZipResourceFile.$$$reportNull$$$0(4);
        }
        return loaderDataBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Class<?> findClass(String fileName, String className, JarLoader jarLoader, ClassPath.ClassDataConsumer classConsumer) throws IOException {
        if (!this.defineClassUsingBytes && classConsumer.isByteBufferSupported(className)) {
            ByteBuffer buffer = this.zipFile.getByteBuffer(fileName);
            if (buffer == null) {
                return null;
            }
            try {
                Class<?> clazz = classConsumer.consumeClassData(className, buffer);
                return clazz;
            }
            finally {
                this.zipFile.releaseBuffer(buffer);
            }
        }
        byte[] data = this.zipFile.getData(fileName);
        if (data == null) {
            return null;
        }
        return classConsumer.consumeClassData(className, data);
    }

    @Override
    @Nullable
    public Resource getResource(@NotNull String name, @NotNull JarLoader jarLoader) {
        ZipFile.ZipResource entry;
        if (name == null) {
            ZipResourceFile.$$$reportNull$$$0(5);
        }
        if (jarLoader == null) {
            ZipResourceFile.$$$reportNull$$$0(6);
        }
        return (entry = this.zipFile.getResource(name)) == null ? null : new ZipFileResource(jarLoader, entry, name);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameFilter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/lang/ZipResourceFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jarLoader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/lang/ZipResourceFile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "computePackageIndex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processResources";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getResource";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class ZipFileResource
    implements Resource {
        private final JarLoader jarLoader;
        private URL url;
        private final String name;
        private final ZipFile.ZipResource entry;

        private ZipFileResource(@NotNull JarLoader jarLoader, @NotNull ZipFile.ZipResource entry, @NotNull String name) {
            if (jarLoader == null) {
                ZipFileResource.$$$reportNull$$$0(0);
            }
            if (entry == null) {
                ZipFileResource.$$$reportNull$$$0(1);
            }
            if (name == null) {
                ZipFileResource.$$$reportNull$$$0(2);
            }
            this.jarLoader = jarLoader;
            this.entry = entry;
            this.name = name;
        }

        public String toString() {
            return "ZipFileResource(name=" + String.valueOf(this.entry) + ")";
        }

        @Override
        @NotNull
        public URL getURL() {
            URL result = this.url;
            if (result == null) {
                MyJarUrlStreamHandler handler = new MyJarUrlStreamHandler(this.entry, this.jarLoader);
                try {
                    result = new URL(this.jarLoader.url, this.name, handler);
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
                this.url = result;
                handler.original = result;
            }
            URL uRL = result;
            if (uRL == null) {
                ZipFileResource.$$$reportNull$$$0(3);
            }
            return uRL;
        }

        @Override
        @NotNull
        public InputStream getInputStream() throws IOException {
            InputStream inputStream = this.entry.getInputStream();
            if (inputStream == null) {
                ZipFileResource.$$$reportNull$$$0(4);
            }
            return inputStream;
        }

        @Override
        public byte @NotNull [] getBytes() throws IOException {
            byte[] byArray = this.entry.getData();
            if (byArray == null) {
                ZipFileResource.$$$reportNull$$$0(5);
            }
            return byArray;
        }

        @Override
        @NotNull
        public ByteBuffer getByteBuffer() throws IOException {
            ByteBuffer byteBuffer = this.entry.getByteBuffer();
            if (byteBuffer == null) {
                ZipFileResource.$$$reportNull$$$0(6);
            }
            return byteBuffer;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jarLoader";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "entry";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/lang/ZipResourceFile$ZipFileResource";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/lang/ZipResourceFile$ZipFileResource";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getURL";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInputStream";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBytes";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getByteBuffer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class MyJarUrlConnection
    extends JarURLConnection {
        private ZipFile.ZipResource effectiveEntry;
        private final JarLoader jarLoader;
        private byte[] data;

        MyJarUrlConnection(@NotNull URL url, @NotNull ZipFile.ZipResource entry, @NotNull JarLoader jarLoader) throws MalformedURLException {
            if (url == null) {
                MyJarUrlConnection.$$$reportNull$$$0(0);
            }
            if (entry == null) {
                MyJarUrlConnection.$$$reportNull$$$0(1);
            }
            if (jarLoader == null) {
                MyJarUrlConnection.$$$reportNull$$$0(2);
            }
            super(url);
            String entryName = this.getEntryName();
            this.effectiveEntry = entryName == null || entryName.equals(entry.getPath()) ? entry : null;
            this.jarLoader = jarLoader;
        }

        private byte[] getData() throws IOException {
            byte[] result = this.data;
            if (result == null) {
                this.connect();
                this.data = result = this.effectiveEntry.getData();
            }
            return result;
        }

        @Override
        public void connect() throws IOException {
            if (this.effectiveEntry == null) {
                Resource resource = this.jarLoader.zipFile.getResource(this.getEntryName(), this.jarLoader);
                if (resource == null) {
                    throw new NoSuchFileException("Cannot find `" + this.getEntryName() + "` in " + String.valueOf(this.jarLoader.getPath()));
                }
                this.effectiveEntry = ((ZipFileResource)resource).entry;
            }
        }

        @Override
        public Object getContent() throws IOException {
            return this.getData();
        }

        @Override
        public InputStream getInputStream() throws IOException {
            this.connect();
            return this.effectiveEntry.getInputStream();
        }

        @Override
        public long getContentLengthLong() {
            return this.getContentLength();
        }

        @Override
        public int getContentLength() {
            try {
                this.connect();
            }
            catch (IOException e) {
                return -1;
            }
            return this.effectiveEntry.getUncompressedSize();
        }

        @Override
        public JarFile getJarFile() throws IOException {
            System.out.println("Do not use URL connection as JarURLConnection");
            return new JarFile(this.jarLoader.getPath().toFile());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "url";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "entry";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "jarLoader";
                    break;
                }
            }
            objectArray[1] = "com/intellij/util/lang/ZipResourceFile$MyJarUrlConnection";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class MyUrlConnection
    extends URLConnection {
        private ZipFile.ZipResource entry;
        private final JarLoader jarLoader;
        private byte[] data;

        MyUrlConnection(@NotNull URL url, @Nullable ZipFile.ZipResource entry, @NotNull JarLoader jarLoader) {
            if (url == null) {
                MyUrlConnection.$$$reportNull$$$0(0);
            }
            if (jarLoader == null) {
                MyUrlConnection.$$$reportNull$$$0(1);
            }
            super(url);
            this.entry = entry;
            this.jarLoader = jarLoader;
        }

        private byte[] getData() throws IOException {
            byte[] result = this.data;
            if (result == null) {
                this.data = result = this.getEntry().getData();
            }
            return result;
        }

        private ZipFile.ZipResource getEntry() throws IOException {
            ZipFile.ZipResource result = this.entry;
            if (result == null) {
                Resource resource;
                String spec = this.url.getFile();
                int index = spec.indexOf("!/");
                if (index != -1) {
                    index += 2;
                }
                String entryName = index != -1 && index != spec.length() ? spec.substring(index) : null;
                Resource resource2 = resource = entryName == null ? null : this.jarLoader.zipFile.getResource(entryName, this.jarLoader);
                if (resource == null) {
                    throw new NoSuchFileException("Cannot find `" + spec + "` in " + String.valueOf(this.jarLoader.getPath()));
                }
                this.entry = result = ((ZipFileResource)resource).entry;
            }
            return result;
        }

        @Override
        public void connect() {
        }

        @Override
        public Object getContent() throws IOException {
            return this.getData();
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this.getEntry().getInputStream();
        }

        @Override
        public int getContentLength() {
            try {
                return this.getEntry().getUncompressedSize();
            }
            catch (IOException e) {
                return -1;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "url";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "jarLoader";
                    break;
                }
            }
            objectArray[1] = "com/intellij/util/lang/ZipResourceFile$MyUrlConnection";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class MyJarUrlStreamHandler
    extends URLStreamHandler {
        @NotNull
        private final ZipFile.ZipResource entry;
        @NotNull
        private final JarLoader jarLoader;
        private URL original;

        private MyJarUrlStreamHandler(@NotNull ZipFile.ZipResource entry, @NotNull JarLoader jarLoader) {
            if (entry == null) {
                MyJarUrlStreamHandler.$$$reportNull$$$0(0);
            }
            if (jarLoader == null) {
                MyJarUrlStreamHandler.$$$reportNull$$$0(1);
            }
            this.entry = entry;
            this.jarLoader = jarLoader;
        }

        @Override
        protected URLConnection openConnection(URL url) throws MalformedURLException {
            if (this.jarLoader.configuration.mimicJarUrlConnection) {
                return new MyJarUrlConnection(url, this.entry, this.jarLoader);
            }
            return new MyUrlConnection(url, url == this.original || url.equals(this.original) ? this.entry : null, this.jarLoader);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "entry";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "jarLoader";
                    break;
                }
            }
            objectArray[1] = "com/intellij/util/lang/ZipResourceFile$MyJarUrlStreamHandler";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

