/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.externalSystem.dependency.analyzer.AbstractDependencyAnalyzerAction;
import com.intellij.openapi.externalSystem.dependency.analyzer.DAModule;
import com.intellij.openapi.externalSystem.dependency.analyzer.DependencyAnalyzerDependency;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenUtil;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\n\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/idea/maven/project/actions/ProjectViewDependencyAnalyzerAction;", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/AbstractDependencyAnalyzerAction;", "Lcom/intellij/openapi/module/Module;", "<init>", "()V", "getSystemId", "Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getSelectedData", "getModule", "selectedData", "getDependencyData", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerDependency$Data;", "getDependencyScope", "", "isEnabledAndVisible", "", "intellij.maven"})
public final class ProjectViewDependencyAnalyzerAction
extends AbstractDependencyAnalyzerAction<Module> {
    @NotNull
    public ProjectSystemId getSystemId(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return MavenUtil.SYSTEM_ID;
    }

    @Nullable
    public Module getSelectedData(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return null;
        }
        Project project2 = project;
        Module module = (Module)e.getData(PlatformCoreDataKeys.MODULE);
        if (module == null) {
            return null;
        }
        Module module2 = module;
        if (MavenProjectsManager.getInstance(project2).isMavenizedModule(module2)) {
            return module2;
        }
        return null;
    }

    @NotNull
    public Module getModule(@NotNull AnActionEvent e, @NotNull Module selectedData) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)selectedData, (String)"selectedData");
        return selectedData;
    }

    @NotNull
    public DependencyAnalyzerDependency.Data getDependencyData(@NotNull AnActionEvent e, @NotNull Module selectedData) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)selectedData, (String)"selectedData");
        String string = selectedData.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return (DependencyAnalyzerDependency.Data)new DAModule(string);
    }

    @Nullable
    public Void getDependencyScope(@NotNull AnActionEvent e, @NotNull Module selectedData) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)selectedData, (String)"selectedData");
        return null;
    }

    public boolean isEnabledAndVisible(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return super.isEnabledAndVisible(e) && (!e.isFromContextMenu() || e.getData(LangDataKeys.MODULE_CONTEXT_ARRAY) != null);
    }
}

