/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.language.util;

import com.intellij.editorconfig.common.syntax.psi.EditorConfigEnumerationPattern;
import com.intellij.editorconfig.common.syntax.psi.EditorConfigHeader;
import com.intellij.editorconfig.common.syntax.psi.EditorConfigPattern;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.util.PsiTreeUtil;
import dk.brics.automaton.Automaton;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.editorconfig.core.EditorConfigAutomatonBuilder;
import org.editorconfig.language.codeinsight.inspections.EditorConfigEmptyHeaderInspectionKt;
import org.editorconfig.language.codeinsight.inspections.EditorConfigNumerousWildcardsInspectionKt;
import org.editorconfig.language.codeinsight.inspections.EditorConfigPatternEnumerationRedundancyInspectionKt;
import org.editorconfig.language.util.EditorConfigPsiTreeUtil;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0015\u0010\u0004\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0002H\u0086\u0004\u001a\u0015\u0010\u0006\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0086\u0004\u001a\u0015\u0010\u0004\u001a\u00020\u0001*\u00020\b2\u0006\u0010\u0005\u001a\u00020\bH\u0086\u0004\u001a\u0015\u0010\u0004\u001a\u00020\u0001*\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0086\u0004\u001a\u0015\u0010\u000b\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0086\u0004\u001a\u0015\u0010\u000b\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0086\u0004\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\"\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"isValidGlob", "", "Lcom/intellij/editorconfig/common/syntax/psi/EditorConfigHeader;", "(Lcom/intellij/editorconfig/common/syntax/psi/EditorConfigHeader;)Z", "isSubcaseOf", "general", "isEquivalentTo", "other", "Lcom/intellij/editorconfig/common/syntax/psi/EditorConfigPattern;", "generalAutomaton", "Ldk/brics/automaton/Automaton;", "matches", "string", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "Log", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.editorconfig.backend"})
@SourceDebugExtension(value={"SMAP\nEditorConfigGlobUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorConfigGlobUtils.kt\norg/editorconfig/language/util/EditorConfigGlobUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,70:1\n1761#2,3:71\n13#3:74\n*S KotlinDebug\n*F\n+ 1 EditorConfigGlobUtils.kt\norg/editorconfig/language/util/EditorConfigGlobUtilsKt\n*L\n27#1:71,3\n69#1:74\n*E\n"})
public final class EditorConfigGlobUtilsKt {
    @NotNull
    private static final Logger Log;

    public static final boolean isValidGlob(@NotNull EditorConfigHeader $this$isValidGlob) {
        boolean bl;
        block8: {
            Intrinsics.checkNotNullParameter((Object)$this$isValidGlob, (String)"<this>");
            if ($this$isValidGlob.getHeader().textMatches((CharSequence)"[")) {
                return false;
            }
            if (EditorConfigPsiTreeUtil.INSTANCE.containsErrors((PsiElement)$this$isValidGlob.getHeader())) {
                return false;
            }
            if ($this$isValidGlob.getNextSibling() instanceof PsiErrorElement) {
                return false;
            }
            if (EditorConfigEmptyHeaderInspectionKt.isEmptyHeader($this$isValidGlob.getHeader())) {
                return false;
            }
            if (EditorConfigNumerousWildcardsInspectionKt.hasNumerousWildcards($this$isValidGlob.getHeader())) {
                return false;
            }
            Class[] classArray = new Class[]{EditorConfigEnumerationPattern.class};
            Collection collection = PsiTreeUtil.findChildrenOfAnyType((PsiElement)((PsiElement)$this$isValidGlob.getHeader()), (Class[])classArray);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"findChildrenOfAnyType(...)");
            Iterable $this$any$iv = collection;
            boolean $i$f$any = false;
            if (((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    EditorConfigEnumerationPattern it = (EditorConfigEnumerationPattern)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)it);
                    if (!EditorConfigPatternEnumerationRedundancyInspectionKt.hasRedundancy(it)) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        return !bl;
    }

    public static final boolean isSubcaseOf(@NotNull EditorConfigHeader $this$isSubcaseOf, @NotNull EditorConfigHeader general) {
        Intrinsics.checkNotNullParameter((Object)$this$isSubcaseOf, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)general, (String)"general");
        if (!EditorConfigGlobUtilsKt.isValidGlob($this$isSubcaseOf)) {
            return false;
        }
        if (!EditorConfigGlobUtilsKt.isValidGlob(general)) {
            return false;
        }
        Automaton subcaseAutomaton = EditorConfigAutomatonBuilder.INSTANCE.getCachedHeaderAutomaton($this$isSubcaseOf);
        Automaton generalAutomaton = EditorConfigAutomatonBuilder.INSTANCE.getCachedHeaderAutomaton(general);
        return subcaseAutomaton.subsetOf(generalAutomaton);
    }

    public static final boolean isEquivalentTo(@NotNull EditorConfigHeader $this$isEquivalentTo, @NotNull EditorConfigHeader other) {
        Intrinsics.checkNotNullParameter((Object)$this$isEquivalentTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (!EditorConfigGlobUtilsKt.isValidGlob($this$isEquivalentTo.getHeader())) {
            return false;
        }
        if (!EditorConfigGlobUtilsKt.isValidGlob(other.getHeader())) {
            return false;
        }
        Automaton thisAutomaton = EditorConfigAutomatonBuilder.INSTANCE.getCachedHeaderAutomaton($this$isEquivalentTo);
        Automaton otherAutomaton = EditorConfigAutomatonBuilder.INSTANCE.getCachedHeaderAutomaton(other);
        return Intrinsics.areEqual((Object)thisAutomaton, (Object)otherAutomaton);
    }

    public static final boolean isSubcaseOf(@NotNull EditorConfigPattern $this$isSubcaseOf, @NotNull EditorConfigPattern general) {
        Intrinsics.checkNotNullParameter((Object)$this$isSubcaseOf, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)general, (String)"general");
        if (!EditorConfigGlobUtilsKt.isValidGlob(general.getHeader())) {
            return false;
        }
        Automaton generalAutomaton = EditorConfigAutomatonBuilder.INSTANCE.getCachedPatternAutomaton(general);
        return EditorConfigGlobUtilsKt.isSubcaseOf($this$isSubcaseOf, generalAutomaton);
    }

    public static final boolean isSubcaseOf(@NotNull EditorConfigPattern $this$isSubcaseOf, @NotNull Automaton generalAutomaton) {
        Intrinsics.checkNotNullParameter((Object)$this$isSubcaseOf, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)generalAutomaton, (String)"generalAutomaton");
        if (!EditorConfigGlobUtilsKt.isValidGlob($this$isSubcaseOf.getHeader())) {
            return false;
        }
        Automaton subcaseAutomaton = EditorConfigAutomatonBuilder.INSTANCE.getCachedPatternAutomaton($this$isSubcaseOf);
        return subcaseAutomaton.subsetOf(generalAutomaton);
    }

    public static final boolean matches(@NotNull EditorConfigHeader $this$matches, @NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)$this$matches, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        Log.assertTrue(EditorConfigGlobUtilsKt.isValidGlob($this$matches.getHeader()));
        EditorConfigHeader editorConfigHeader = $this$matches.getSection().getHeader();
        Intrinsics.checkNotNullExpressionValue((Object)editorConfigHeader, (String)"getHeader(...)");
        return EditorConfigAutomatonBuilder.INSTANCE.getCachedHeaderRunAutomaton(editorConfigHeader).run(string);
    }

    public static final boolean matches(@NotNull EditorConfigHeader $this$matches, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)$this$matches, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Log.assertTrue(EditorConfigGlobUtilsKt.isValidGlob($this$matches.getHeader()));
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return EditorConfigGlobUtilsKt.matches($this$matches, string);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(EditorConfigHeader.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        Log = logger;
    }
}

