/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.core.trace.impl;

import com.intellij.debugger.streams.core.lib.HandlerFactory;
import com.intellij.debugger.streams.core.trace.IntermediateCallHandler;
import com.intellij.debugger.streams.core.trace.TerminatorCallHandler;
import com.intellij.debugger.streams.core.trace.TraceExpressionBuilder;
import com.intellij.debugger.streams.core.trace.TraceHandler;
import com.intellij.debugger.streams.core.trace.dsl.ArrayVariable;
import com.intellij.debugger.streams.core.trace.dsl.CodeBlock;
import com.intellij.debugger.streams.core.trace.dsl.CodeContext;
import com.intellij.debugger.streams.core.trace.dsl.Convertable;
import com.intellij.debugger.streams.core.trace.dsl.Dsl;
import com.intellij.debugger.streams.core.trace.dsl.Expression;
import com.intellij.debugger.streams.core.trace.dsl.Lambda;
import com.intellij.debugger.streams.core.trace.dsl.LambdaBody;
import com.intellij.debugger.streams.core.trace.dsl.Statement;
import com.intellij.debugger.streams.core.trace.dsl.Types;
import com.intellij.debugger.streams.core.trace.dsl.Variable;
import com.intellij.debugger.streams.core.trace.dsl.VariableDeclaration;
import com.intellij.debugger.streams.core.trace.dsl.impl.TextExpression;
import com.intellij.debugger.streams.core.trace.impl.handler.type.GenericType;
import com.intellij.debugger.streams.core.wrapper.IntermediateStreamCall;
import com.intellij.debugger.streams.core.wrapper.QualifierExpression;
import com.intellij.debugger.streams.core.wrapper.StreamCall;
import com.intellij.debugger.streams.core.wrapper.StreamChain;
import com.intellij.debugger.streams.core.wrapper.TerminatorStreamCall;
import com.intellij.debugger.streams.core.wrapper.impl.StreamChainImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J&\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u001e\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020\u001aH\u0014J&\u0010#\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010$\u001a\u00020%H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0084D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006&"}, d2={"Lcom/intellij/debugger/streams/core/trace/impl/TraceExpressionBuilderBase;", "Lcom/intellij/debugger/streams/core/trace/TraceExpressionBuilder;", "dsl", "Lcom/intellij/debugger/streams/core/trace/dsl/Dsl;", "handlerFactory", "Lcom/intellij/debugger/streams/core/lib/HandlerFactory;", "<init>", "(Lcom/intellij/debugger/streams/core/trace/dsl/Dsl;Lcom/intellij/debugger/streams/core/lib/HandlerFactory;)V", "getDsl", "()Lcom/intellij/debugger/streams/core/trace/dsl/Dsl;", "resultVariableName", "", "getResultVariableName", "()Ljava/lang/String;", "createTraceExpression", "chain", "Lcom/intellij/debugger/streams/core/wrapper/StreamChain;", "buildTraceChain", "intermediateCallHandlers", "", "Lcom/intellij/debugger/streams/core/trace/IntermediateCallHandler;", "terminatorHandler", "Lcom/intellij/debugger/streams/core/trace/TerminatorCallHandler;", "createTimePeekCall", "Lcom/intellij/debugger/streams/core/wrapper/IntermediateStreamCall;", "elementType", "Lcom/intellij/debugger/streams/core/trace/impl/handler/type/GenericType;", "buildDeclarations", "Lcom/intellij/debugger/streams/core/trace/dsl/CodeBlock;", "intermediateCallsHandlers", "buildStreamExpression", "streamResult", "Lcom/intellij/debugger/streams/core/trace/dsl/Variable;", "evaluationResultArrayElementType", "resultType", "buildFillInfo", "info", "Lcom/intellij/debugger/streams/core/trace/dsl/ArrayVariable;", "intellij.debugger.streams.core"})
@SourceDebugExtension(value={"SMAP\nTraceExpressionBuilderBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TraceExpressionBuilderBase.kt\ncom/intellij/debugger/streams/core/trace/impl/TraceExpressionBuilderBase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,146:1\n1604#2,4:147\n1374#2:153\n1460#2,5:154\n1869#2,2:159\n1869#2,2:161\n37#3,2:151\n*S KotlinDebug\n*F\n+ 1 TraceExpressionBuilderBase.kt\ncom/intellij/debugger/streams/core/trace/impl/TraceExpressionBuilderBase\n*L\n27#1:147,4\n100#1:153\n100#1:154,5\n100#1:159,2\n101#1:161,2\n135#1:151,2\n*E\n"})
public abstract class TraceExpressionBuilderBase
implements TraceExpressionBuilder {
    @NotNull
    private final Dsl dsl;
    @NotNull
    private final HandlerFactory handlerFactory;
    @NotNull
    private final String resultVariableName;

    public TraceExpressionBuilderBase(@NotNull Dsl dsl, @NotNull HandlerFactory handlerFactory) {
        Intrinsics.checkNotNullParameter((Object)dsl, (String)"dsl");
        Intrinsics.checkNotNullParameter((Object)handlerFactory, (String)"handlerFactory");
        this.dsl = dsl;
        this.handlerFactory = handlerFactory;
        this.resultVariableName = "myRes";
    }

    @NotNull
    protected final Dsl getDsl() {
        return this.dsl;
    }

    @NotNull
    protected final String getResultVariableName() {
        return this.resultVariableName;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String createTraceExpression(@NotNull StreamChain chain) {
        void destination$iv;
        void $this$mapIndexedTo$iv;
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        List<IntermediateStreamCall> list = chain.getIntermediateCalls();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getIntermediateCalls(...)");
        Iterable iterable = list;
        Collection collection = new ArrayList();
        HandlerFactory handlerFactory = this.handlerFactory;
        boolean $i$f$mapIndexedTo = false;
        int index$iv = 0;
        for (Object item$iv : $this$mapIndexedTo$iv) {
            void p1;
            void p0;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IntermediateStreamCall intermediateStreamCall = (IntermediateStreamCall)item$iv;
            int n2 = n;
            void var14_16 = destination$iv;
            boolean bl = false;
            var14_16.add(handlerFactory.getForIntermediate((int)p0, (IntermediateStreamCall)p1));
        }
        ArrayList intermediateHandlers = (ArrayList)destination$iv;
        TerminatorStreamCall terminatorStreamCall = chain.getTerminationCall();
        Intrinsics.checkNotNullExpressionValue((Object)terminatorStreamCall, (String)"getTerminationCall(...)");
        TerminatorStreamCall terminatorCall = terminatorStreamCall;
        TerminatorCallHandler terminatorHandler = this.handlerFactory.getForTermination(terminatorCall, "evaluationResult[0]");
        StreamChain traceChain = this.buildTraceChain(chain, intermediateHandlers, terminatorHandler);
        int infoArraySize = 2 + intermediateHandlers.size();
        ArrayVariable info = this.dsl.array(this.dsl.getTypes().getANY(), "info");
        Variable streamResult = this.dsl.variable(this.dsl.getTypes().nullable((Function1<? super Types, ? extends GenericType>)((Function1)TraceExpressionBuilderBase::createTraceExpression$lambda$0)), "streamResult");
        CodeBlock declarations = this.buildDeclarations(intermediateHandlers, terminatorHandler);
        CodeBlock tracingCall = this.buildStreamExpression(traceChain, streamResult);
        CodeBlock fillingInfoArray = this.buildFillInfo(intermediateHandlers, terminatorHandler, info);
        Variable result = this.dsl.variable(this.dsl.getTypes().getANY(), this.resultVariableName);
        return this.dsl.code((Function1<? super CodeContext, Unit>)((Function1)arg_0 -> TraceExpressionBuilderBase.createTraceExpression$lambda$1(info, infoArraySize, declarations, tracingCall, fillingInfoArray, result, streamResult, arg_0)));
    }

    private final StreamChain buildTraceChain(StreamChain chain, List<? extends IntermediateCallHandler> intermediateCallHandlers, TerminatorCallHandler terminatorHandler) {
        boolean bl;
        List newIntermediateCalls = new ArrayList();
        QualifierExpression qualifierExpression = chain.getQualifierExpression();
        Intrinsics.checkNotNullExpressionValue((Object)qualifierExpression, (String)"getQualifierExpression(...)");
        QualifierExpression qualifierExpression2 = qualifierExpression;
        GenericType genericType = qualifierExpression2.getTypeAfter();
        Intrinsics.checkNotNullExpressionValue((Object)genericType, (String)"getTypeAfter(...)");
        newIntermediateCalls.add(this.createTimePeekCall(genericType));
        List<IntermediateStreamCall> list = chain.getIntermediateCalls();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getIntermediateCalls(...)");
        List<IntermediateStreamCall> intermediateCalls = list;
        boolean bl2 = bl = intermediateCalls.size() == intermediateCallHandlers.size();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        for (Pair pair : CollectionsKt.zip((Iterable)intermediateCalls, (Iterable)intermediateCallHandlers)) {
            IntermediateStreamCall call = (IntermediateStreamCall)pair.component1();
            IntermediateCallHandler handler = (IntermediateCallHandler)pair.component2();
            List<IntermediateStreamCall> list2 = handler.additionalCallsBefore();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"additionalCallsBefore(...)");
            newIntermediateCalls.addAll((Collection)list2);
            StreamCall streamCall = handler.transformCall((StreamCall)call);
            Intrinsics.checkNotNullExpressionValue((Object)streamCall, (String)"transformCall(...)");
            newIntermediateCalls.add(streamCall);
            List<IntermediateStreamCall> list3 = handler.additionalInseparableCalls();
            Intrinsics.checkNotNullExpressionValue(list3, (String)"additionalInseparableCalls(...)");
            newIntermediateCalls.addAll((Collection)list3);
            GenericType genericType2 = call.getTypeAfter();
            Intrinsics.checkNotNullExpressionValue((Object)genericType2, (String)"getTypeAfter(...)");
            newIntermediateCalls.add(this.createTimePeekCall(genericType2));
            List<IntermediateStreamCall> list4 = handler.additionalCallsAfter();
            Intrinsics.checkNotNullExpressionValue(list4, (String)"additionalCallsAfter(...)");
            newIntermediateCalls.addAll((Collection)list4);
        }
        List<IntermediateStreamCall> list5 = terminatorHandler.additionalCallsBefore();
        Intrinsics.checkNotNullExpressionValue(list5, (String)"additionalCallsBefore(...)");
        newIntermediateCalls.addAll((Collection)list5);
        StreamCall streamCall = terminatorHandler.transformCall((StreamCall)chain.getTerminationCall());
        Intrinsics.checkNotNullExpressionValue((Object)streamCall, (String)"transformCall(...)");
        TerminatorStreamCall terminatorCall = (TerminatorStreamCall)streamCall;
        return new StreamChainImpl(qualifierExpression2, newIntermediateCalls, terminatorCall, chain.getContext());
    }

    private final IntermediateStreamCall createTimePeekCall(GenericType elementType) {
        Lambda lambda = this.dsl.lambda("x", (Function2<? super LambdaBody, ? super Expression, Unit>)((Function2)(arg_0, arg_1) -> TraceExpressionBuilderBase.createTimePeekCall$lambda$0(this, arg_0, arg_1)));
        return this.dsl.createPeekCall(elementType, lambda);
    }

    private final CodeBlock buildDeclarations(List<? extends IntermediateCallHandler> intermediateCallsHandlers, TerminatorCallHandler terminatorHandler) {
        return this.dsl.block((Function1<? super CodeContext, Unit>)((Function1)arg_0 -> TraceExpressionBuilderBase.buildDeclarations$lambda$0(intermediateCallsHandlers, terminatorHandler, arg_0)));
    }

    private final CodeBlock buildStreamExpression(StreamChain chain, Variable streamResult) {
        GenericType genericType = chain.getTerminationCall().getResultType();
        Intrinsics.checkNotNullExpressionValue((Object)genericType, (String)"getResultType(...)");
        GenericType resultType = genericType;
        return this.dsl.block((Function1<? super CodeContext, Unit>)((Function1)arg_0 -> TraceExpressionBuilderBase.buildStreamExpression$lambda$0(streamResult, this, resultType, chain, arg_0)));
    }

    @NotNull
    protected GenericType evaluationResultArrayElementType(@NotNull GenericType resultType) {
        Intrinsics.checkNotNullParameter((Object)resultType, (String)"resultType");
        return resultType;
    }

    private final CodeBlock buildFillInfo(List<? extends IntermediateCallHandler> intermediateCallsHandlers, TerminatorCallHandler terminatorHandler, ArrayVariable info) {
        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
        Collection $this$toTypedArray$iv = intermediateCallsHandlers;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        spreadBuilder.addSpread((Object)thisCollection$iv.toArray(new IntermediateCallHandler[0]));
        spreadBuilder.add((Object)terminatorHandler);
        List handlers = CollectionsKt.listOf((Object[])spreadBuilder.toArray((Object[])new TraceHandler[spreadBuilder.size()]));
        return this.dsl.block((Function1<? super CodeContext, Unit>)((Function1)arg_0 -> TraceExpressionBuilderBase.buildFillInfo$lambda$0(handlers, info, arg_0)));
    }

    private static final GenericType createTraceExpression$lambda$0(Types $this$nullable) {
        Intrinsics.checkNotNullParameter((Object)$this$nullable, (String)"$this$nullable");
        return $this$nullable.getANY();
    }

    private static final Unit createTraceExpression$lambda$1(ArrayVariable $info, int $infoArraySize, CodeBlock $declarations, CodeBlock $tracingCall, CodeBlock $fillingInfoArray, Variable $result, Variable $streamResult, CodeContext $this$code) {
        Intrinsics.checkNotNullParameter((Object)$this$code, (String)"$this$code");
        $this$code.scope((Function1<? super CodeBlock, Unit>)((Function1)arg_0 -> TraceExpressionBuilderBase.createTraceExpression$lambda$1$0($this$code, $info, $infoArraySize, $declarations, $tracingCall, $fillingInfoArray, $result, $streamResult, arg_0)));
        return Unit.INSTANCE;
    }

    private static final Unit createTraceExpression$lambda$1$0(CodeContext $this_code, ArrayVariable $info, int $infoArraySize, CodeBlock $declarations, CodeBlock $tracingCall, CodeBlock $fillingInfoArray, Variable $result, Variable $streamResult, CodeBlock $this$scope) {
        Intrinsics.checkNotNullParameter((Object)$this$scope, (String)"$this$scope");
        Variable startTime = $this$scope.declare($this_code.variable($this_code.getTypes().getLONG(), "startTime"), $this_code.currentNanoseconds(), false);
        $this$scope.declare($info, $this_code.newSizedArray($this_code.getTypes().getANY(), $infoArraySize), false);
        $this$scope.declare($this_code.timeDeclaration());
        $this$scope.add($declarations);
        $this$scope.add($tracingCall);
        $this$scope.add($fillingInfoArray);
        Expression[] expressionArray = new Expression[]{$this_code.getExpr($this_code.currentNanoseconds() + " - " + Convertable.toCode$default(startTime, 0, 1, null))};
        Variable elapsedTime = $this$scope.declare($this_code.array($this_code.getTypes().getLONG(), "elapsedTime"), $this_code.newArray($this_code.getTypes().getLONG(), expressionArray), false);
        expressionArray = new Expression[]{$info, $streamResult, elapsedTime};
        $this$scope.assign($result, $this_code.newArray($this_code.getTypes().getANY(), expressionArray));
        return Unit.INSTANCE;
    }

    private static final Unit createTimePeekCall$lambda$0(TraceExpressionBuilderBase this$0, LambdaBody $this$lambda, Expression it) {
        Intrinsics.checkNotNullParameter((Object)$this$lambda, (String)"$this$lambda");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this$lambda.doReturn(this$0.dsl.updateTime());
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit buildDeclarations$lambda$0(List $intermediateCallsHandlers, TerminatorCallHandler $terminatorHandler, CodeContext $this$block) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$block, (String)"$this$block");
        Iterable $this$flatMap$iv = $intermediateCallsHandlers;
        boolean $i$f$flatMap = false;
        Iterator iterator = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            IntermediateCallHandler it = (IntermediateCallHandler)element$iv$iv;
            boolean bl = false;
            List<VariableDeclaration> list = it.additionalVariablesDeclaration();
            Intrinsics.checkNotNullExpressionValue(list, (String)"additionalVariablesDeclaration(...)");
            Iterable list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VariableDeclaration it = (VariableDeclaration)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            $this$block.declare(it);
        }
        List<VariableDeclaration> list = $terminatorHandler.additionalVariablesDeclaration();
        Intrinsics.checkNotNullExpressionValue(list, (String)"additionalVariablesDeclaration(...)");
        $this$forEach$iv = list;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VariableDeclaration it = (VariableDeclaration)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            $this$block.declare(it);
        }
        return Unit.INSTANCE;
    }

    private static final Unit buildStreamExpression$lambda$0(Variable $streamResult, TraceExpressionBuilderBase this$0, GenericType $resultType, StreamChain $chain, CodeContext $this$block) {
        Intrinsics.checkNotNullParameter((Object)$this$block, (String)"$this$block");
        $this$block.declare($streamResult, $this$block.getNullExpression(), true);
        GenericType elementType = this$0.evaluationResultArrayElementType($resultType);
        ArrayVariable evaluationResult = $this$block.array(elementType, "evaluationResult");
        if (!Intrinsics.areEqual((Object)$resultType, (Object)$this$block.getTypes().getVOID())) {
            Expression[] expressionArray = new Expression[]{new TextExpression(elementType.getDefaultValue())};
            $this$block.declare(evaluationResult, $this$block.newArray(elementType, expressionArray), true);
        }
        $this$block.tryBlock((Function1<? super CodeBlock, Unit>)((Function1)arg_0 -> TraceExpressionBuilderBase.buildStreamExpression$lambda$0$0($resultType, $this$block, $streamResult, evaluationResult, $chain, arg_0))).catch($this$block.variable($this$block.getTypes().getEXCEPTION(), "t"), (Function1<? super CodeBlock, Unit>)((Function1)arg_0 -> TraceExpressionBuilderBase.buildStreamExpression$lambda$0$1($streamResult, $this$block, arg_0)));
        return Unit.INSTANCE;
    }

    private static final Unit buildStreamExpression$lambda$0$0(GenericType $resultType, CodeContext $this_block, Variable $streamResult, ArrayVariable $evaluationResult, StreamChain $chain, CodeBlock $this$tryBlock) {
        Intrinsics.checkNotNullParameter((Object)$this$tryBlock, (String)"$this$tryBlock");
        if (Intrinsics.areEqual((Object)$resultType, (Object)$this_block.getTypes().getVOID())) {
            $this$tryBlock.assign($streamResult, $this_block.newSizedArray($this_block.getTypes().getANY(), 1));
            $this$tryBlock.statement((Function0<? extends Statement>)((Function0)() -> TraceExpressionBuilderBase.buildStreamExpression$lambda$0$0$0($chain)));
        } else {
            $this$tryBlock.statement((Function0<? extends Statement>)((Function0)() -> TraceExpressionBuilderBase.buildStreamExpression$lambda$0$0$1($evaluationResult, $chain)));
            $this$tryBlock.assign($streamResult, $evaluationResult);
        }
        return Unit.INSTANCE;
    }

    private static final Statement buildStreamExpression$lambda$0$0$0(StreamChain $chain) {
        String string = $chain.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return new TextExpression(string);
    }

    private static final Statement buildStreamExpression$lambda$0$0$1(ArrayVariable $evaluationResult, StreamChain $chain) {
        String string = $chain.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return $evaluationResult.set(0, (Expression)new TextExpression(string));
    }

    private static final Unit buildStreamExpression$lambda$0$1(Variable $streamResult, CodeContext $this_block, CodeBlock $this$catch) {
        Intrinsics.checkNotNullParameter((Object)$this$catch, (String)"$this$catch");
        Expression[] expressionArray = new Expression[]{$this_block.getExpr("t")};
        $this$catch.assign($streamResult, $this_block.newArray($this_block.getTypes().getEXCEPTION(), expressionArray));
        return Unit.INSTANCE;
    }

    private static final Unit buildFillInfo$lambda$0(List $handlers, ArrayVariable $info, CodeContext $this$block) {
        Intrinsics.checkNotNullParameter((Object)$this$block, (String)"$this$block");
        Iterator iterator = ((Iterable)$handlers).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int i = n++;
            TraceHandler handler = (TraceHandler)iterator.next();
            $this$block.scope((Function1<? super CodeBlock, Unit>)((Function1)arg_0 -> TraceExpressionBuilderBase.buildFillInfo$lambda$0$0(handler, $info, i, arg_0)));
        }
        return Unit.INSTANCE;
    }

    private static final Unit buildFillInfo$lambda$0$0(TraceHandler $handler, ArrayVariable $info, int $i, CodeBlock $this$scope) {
        Intrinsics.checkNotNullParameter((Object)$this$scope, (String)"$this$scope");
        CodeBlock codeBlock = $handler.prepareResult();
        Intrinsics.checkNotNullExpressionValue((Object)codeBlock, (String)"prepareResult(...)");
        $this$scope.add(codeBlock);
        $this$scope.statement((Function0<? extends Statement>)((Function0)() -> TraceExpressionBuilderBase.buildFillInfo$lambda$0$0$0($info, $i, $handler)));
        return Unit.INSTANCE;
    }

    private static final Statement buildFillInfo$lambda$0$0$0(ArrayVariable $info, int $i, TraceHandler $handler) {
        Expression expression = $handler.getResultExpression();
        Intrinsics.checkNotNullExpressionValue((Object)expression, (String)"getResultExpression(...)");
        return $info.set($i, expression);
    }
}

