/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.index.updater.jetty;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.HttpEventListenerWrapper;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.http.HttpHeaders;
import org.eclipse.jetty.io.Buffer;
import org.sonatype.nexus.index.updater.jetty.NtlmConnectionHelper;
import org.sonatype.nexus.index.updater.jetty.ResourceExchange;

public class NtlmListener
extends HttpEventListenerWrapper {
    private static NtlmConnectionHelper _helper;
    private final HttpExchange _exchange;
    private final Set<String> _authTypes = new HashSet<String>();
    private boolean _requestComplete;
    private boolean _responseComplete;
    private boolean _unAuthorized;

    public NtlmListener(HttpDestination destination, HttpExchange ex) {
        super(ex.getEventListener(), true);
        this._exchange = ex;
    }

    protected String scrapeAuthenticationType(String authString) {
        int idx = authString.indexOf(" ");
        return (idx < 0 ? authString : authString.substring(0, idx)).trim().toLowerCase();
    }

    public void onResponseStatus(Buffer version, int status, Buffer reason) throws IOException {
        boolean bl = this._unAuthorized = status == 401;
        if (this._unAuthorized) {
            this.setDelegatingRequests(false);
            this.setDelegatingResponses(false);
        }
        super.onResponseStatus(version, status, reason);
    }

    public void onResponseHeader(Buffer name, Buffer value) throws IOException {
        if (this._unAuthorized) {
            int header = HttpHeaders.CACHE.getOrdinal(name);
            switch (header) {
                case 51: {
                    String authString = value.toString();
                    this._authTypes.add(this.scrapeAuthenticationType(authString));
                }
            }
        }
        super.onResponseHeader(name, value);
    }

    public void onRequestComplete() throws IOException {
        this._requestComplete = true;
        this.checkExchangeComplete();
        super.onRequestComplete();
    }

    public void onResponseComplete() throws IOException {
        this._responseComplete = true;
        this.checkExchangeComplete();
        super.onResponseComplete();
    }

    public void checkExchangeComplete() throws IOException {
        if (this._unAuthorized && this._requestComplete && this._responseComplete) {
            this.setDelegatingRequests(true);
            this.setDelegatingResponses(true);
            if (_helper != null && this._authTypes.contains("ntlm") && this._exchange instanceof ResourceExchange) {
                _helper.send((ResourceExchange)this._exchange);
            } else {
                this.setDelegationResult(false);
            }
        }
    }

    public static void setHelper(NtlmConnectionHelper helper) {
        _helper = helper;
    }
}

