/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema;

import com.intellij.json.JsonBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.PairProcessor;
import com.intellij.util.PatternUtil;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.SynchronizedClearableLazy;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.OptionTag;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import com.jetbrains.jsonSchema.JsonMappingKind;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonSchemaVersion;
import com.jetbrains.jsonSchema.impl.light.legacy.JsonSchemaObjectReadingUtils;
import com.jetbrains.jsonSchema.remote.JsonFileResolver;
import com.jetbrains.jsonSchema.settings.mappings.JsonSchemaVersionConverter;
import java.io.File;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="SchemaInfo")
public final class UserDefinedJsonSchemaConfiguration {
    private static final Comparator<Item> ITEM_COMPARATOR = (o1, o2) -> {
        if (o1.isPattern() != o2.isPattern()) {
            return o1.isPattern() ? -1 : 1;
        }
        if (o1.isDirectory() != o2.isDirectory()) {
            return o1.isDirectory() ? -1 : 1;
        }
        return o1.path.compareToIgnoreCase(o2.path);
    };
    @Nls
    private String name;
    @Nullable
    @Nls
    private String generatedName;
    public String relativePathToSchema;
    @OptionTag(converter=JsonSchemaVersionConverter.class)
    @NotNull
    public JsonSchemaVersion schemaVersion;
    public boolean applicationDefined;
    public List<Item> patterns;
    public boolean isIgnoredFile;
    @Transient
    private final SynchronizedClearableLazy<List<PairProcessor<Project, VirtualFile>>> myCalculatedPatterns;

    public UserDefinedJsonSchemaConfiguration() {
        this.schemaVersion = JsonSchemaVersion.SCHEMA_4;
        this.patterns = new SmartList();
        this.isIgnoredFile = false;
        this.myCalculatedPatterns = new SynchronizedClearableLazy(this::recalculatePatterns);
    }

    public UserDefinedJsonSchemaConfiguration(@NotNull @NlsSafe String name, @Nullable JsonSchemaVersion schemaVersion, @NotNull String relativePathToSchema, boolean applicationDefined, @Nullable List<Item> patterns) {
        if (name == null) {
            UserDefinedJsonSchemaConfiguration.$$$reportNull$$$0(0);
        }
        if (relativePathToSchema == null) {
            UserDefinedJsonSchemaConfiguration.$$$reportNull$$$0(1);
        }
        this.schemaVersion = JsonSchemaVersion.SCHEMA_4;
        this.patterns = new SmartList();
        this.isIgnoredFile = false;
        this.myCalculatedPatterns = new SynchronizedClearableLazy(this::recalculatePatterns);
        this.name = name;
        this.relativePathToSchema = relativePathToSchema;
        this.schemaVersion = schemaVersion == null ? JsonSchemaVersion.SCHEMA_4 : schemaVersion;
        this.applicationDefined = applicationDefined;
        this.setPatterns(patterns);
    }

    public void setGeneratedName(@NotNull @Nls String generatedName) {
        if (generatedName == null) {
            UserDefinedJsonSchemaConfiguration.$$$reportNull$$$0(2);
        }
        this.generatedName = generatedName;
    }

    @Nls
    public String getGeneratedName() {
        return this.generatedName;
    }

    @Nls
    public String getName() {
        return this.name;
    }

    public void setName(@NotNull @Nls String name) {
        if (name == null) {
            UserDefinedJsonSchemaConfiguration.$$$reportNull$$$0(3);
        }
        this.name = name;
    }

    public boolean isIgnoredFile() {
        return this.isIgnoredFile;
    }

    public void setIgnoredFile(boolean ignoredFile) {
        this.isIgnoredFile = ignoredFile;
    }

    public String getRelativePathToSchema() {
        return Item.normalizePath(this.relativePathToSchema);
    }

    @NotNull
    public JsonSchemaVersion getSchemaVersion() {
        JsonSchemaVersion jsonSchemaVersion = this.schemaVersion;
        if (jsonSchemaVersion == null) {
            UserDefinedJsonSchemaConfiguration.$$$reportNull$$$0(4);
        }
        return jsonSchemaVersion;
    }

    public void setSchemaVersion(JsonSchemaVersion schemaVersion) {
        this.schemaVersion = schemaVersion == null ? JsonSchemaVersion.SCHEMA_4 : schemaVersion;
    }

    public void setRelativePathToSchema(String relativePathToSchema) {
        this.relativePathToSchema = Item.neutralizePath(relativePathToSchema);
    }

    public boolean isApplicationDefined() {
        return this.applicationDefined;
    }

    public void setApplicationDefined(boolean applicationDefined) {
        this.applicationDefined = applicationDefined;
    }

    public List<Item> getPatterns() {
        return this.patterns;
    }

    public void setPatterns(@Nullable List<Item> patterns) {
        this.patterns.clear();
        if (patterns != null) {
            this.patterns.addAll(patterns);
        }
        this.patterns.sort(ITEM_COMPARATOR);
        this.myCalculatedPatterns.drop();
    }

    public void refreshPatterns() {
        this.myCalculatedPatterns.drop();
    }

    @NotNull
    public List<PairProcessor<Project, VirtualFile>> getCalculatedPatterns() {
        List list = (List)this.myCalculatedPatterns.getValue();
        if (list == null) {
            UserDefinedJsonSchemaConfiguration.$$$reportNull$$$0(5);
        }
        return list;
    }

    private List<PairProcessor<Project, VirtualFile>> recalculatePatterns() {
        SmartList result = new SmartList();
        for (Item patternText : this.patterns) {
            switch (patternText.mappingKind) {
                case File: {
                    result.add((project, vfile) -> vfile.equals(UserDefinedJsonSchemaConfiguration.getRelativeFile(project, patternText)) || vfile.getUrl().equals(Item.neutralizePath(patternText.getPath())));
                    break;
                }
                case Pattern: {
                    String pathText = FileUtil.toSystemIndependentName((String)patternText.getPath());
                    Pattern pattern = pathText.isEmpty() ? PatternUtil.NOTHING : (pathText.indexOf(47) >= 0 ? PatternUtil.compileSafe((String)(".*/" + PatternUtil.convertToRegex((String)pathText)), (Pattern)PatternUtil.NOTHING) : PatternUtil.fromMask((String)pathText));
                    result.add((project, file) -> JsonSchemaObjectReadingUtils.matchPattern(pattern, pathText.indexOf(47) >= 0 ? file.getPath() : file.getName()));
                    break;
                }
                case Directory: {
                    result.add((project, vfile) -> {
                        VirtualFile relativeFile = UserDefinedJsonSchemaConfiguration.getRelativeFile(project, patternText);
                        if (relativeFile == null || !VfsUtilCore.isAncestor((VirtualFile)relativeFile, (VirtualFile)vfile, (boolean)true)) {
                            return false;
                        }
                        JsonSchemaService service = JsonSchemaService.Impl.get(project);
                        return service.isApplicableToFile((VirtualFile)vfile);
                    });
                }
            }
        }
        return result;
    }

    @Nullable
    private static VirtualFile getRelativeFile(@NotNull Project project, @NotNull Item pattern) {
        if (project == null) {
            UserDefinedJsonSchemaConfiguration.$$$reportNull$$$0(6);
        }
        if (pattern == null) {
            UserDefinedJsonSchemaConfiguration.$$$reportNull$$$0(7);
        }
        if (project.getBasePath() == null) {
            return null;
        }
        String path = FileUtilRt.toSystemIndependentName((String)StringUtil.notNullize((String)pattern.path));
        List<String> parts = UserDefinedJsonSchemaConfiguration.pathToPartsList(path);
        if (parts.isEmpty()) {
            return project.getBaseDir();
        }
        return VfsUtil.findRelativeFile((VirtualFile)project.getBaseDir(), (String[])ArrayUtilRt.toStringArray(parts));
    }

    @NotNull
    private static List<String> pathToPartsList(@NotNull String path) {
        if (path == null) {
            UserDefinedJsonSchemaConfiguration.$$$reportNull$$$0(8);
        }
        List list = ContainerUtil.filter((Collection)StringUtil.split((String)path, (String)"/"), s -> !".".equals(s));
        if (list == null) {
            UserDefinedJsonSchemaConfiguration.$$$reportNull$$$0(9);
        }
        return list;
    }

    private static String @NotNull [] pathToParts(@NotNull String path) {
        if (path == null) {
            UserDefinedJsonSchemaConfiguration.$$$reportNull$$$0(10);
        }
        String[] stringArray = ArrayUtilRt.toStringArray(UserDefinedJsonSchemaConfiguration.pathToPartsList(path));
        if (stringArray == null) {
            UserDefinedJsonSchemaConfiguration.$$$reportNull$$$0(11);
        }
        return stringArray;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserDefinedJsonSchemaConfiguration info = (UserDefinedJsonSchemaConfiguration)o;
        if (this.applicationDefined != info.applicationDefined) {
            return false;
        }
        if (this.schemaVersion != info.schemaVersion) {
            return false;
        }
        if (!Objects.equals(this.name, info.name)) {
            return false;
        }
        if (!Objects.equals(this.relativePathToSchema, info.relativePathToSchema)) {
            return false;
        }
        return Objects.equals(this.patterns, info.patterns);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.relativePathToSchema != null ? this.relativePathToSchema.hashCode() : 0);
        result = 31 * result + (this.applicationDefined ? 1 : 0);
        result = 31 * result + (this.patterns != null ? this.patterns.hashCode() : 0);
        result = 31 * result + this.schemaVersion.hashCode();
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 9, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePathToSchema";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generatedName";
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/jsonSchema/UserDefinedJsonSchemaConfiguration";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/jsonSchema/UserDefinedJsonSchemaConfiguration";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchemaVersion";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCalculatedPatterns";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "pathToPartsList";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "pathToParts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setGeneratedName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 11: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getRelativeFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "pathToPartsList";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "pathToParts";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 9, 11 -> new IllegalStateException(string);
        };
    }

    public static final class Item {
        public String path;
        public JsonMappingKind mappingKind = JsonMappingKind.File;

        public Item() {
        }

        public Item(String path, JsonMappingKind mappingKind) {
            this.path = Item.neutralizePath(path);
            this.mappingKind = mappingKind;
        }

        public Item(String path, boolean isPattern, boolean isDirectory) {
            this.path = Item.neutralizePath(path);
            this.mappingKind = isPattern ? JsonMappingKind.Pattern : (isDirectory ? JsonMappingKind.Directory : JsonMappingKind.File);
        }

        @NotNull
        private static String normalizePath(@NotNull String path) {
            if (path == null) {
                Item.$$$reportNull$$$0(0);
            }
            if (Item.preserveSlashes(path)) {
                String string = path;
                if (string == null) {
                    Item.$$$reportNull$$$0(1);
                }
                return string;
            }
            String string = StringUtil.trimEnd((String)FileUtilRt.toSystemDependentName((String)path), (char)File.separatorChar);
            if (string == null) {
                Item.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static boolean preserveSlashes(@NotNull String path) {
            if (path == null) {
                Item.$$$reportNull$$$0(3);
            }
            return StringUtil.startsWith((CharSequence)path, (CharSequence)"http:") || StringUtil.startsWith((CharSequence)path, (CharSequence)"https:") || JsonFileResolver.isTempOrMockUrl(path);
        }

        @NotNull
        public static String neutralizePath(@NotNull String path) {
            if (path == null) {
                Item.$$$reportNull$$$0(4);
            }
            if (Item.preserveSlashes(path)) {
                String string = path;
                if (string == null) {
                    Item.$$$reportNull$$$0(5);
                }
                return string;
            }
            String string = StringUtil.trimEnd((String)FileUtilRt.toSystemIndependentName((String)path), (char)'/');
            if (string == null) {
                Item.$$$reportNull$$$0(6);
            }
            return string;
        }

        public String getPath() {
            return Item.normalizePath(this.path);
        }

        public void setPath(String path) {
            this.path = Item.neutralizePath(path);
        }

        @NlsContexts.Tooltip
        public String getError() {
            return switch (this.mappingKind) {
                default -> throw new MatchException(null, null);
                case JsonMappingKind.File -> {
                    if (!StringUtil.isEmpty((String)this.path)) {
                        yield null;
                    }
                    yield JsonBundle.message((String)"schema.configuration.error.empty.file.path", (Object[])new Object[0]);
                }
                case JsonMappingKind.Pattern -> {
                    if (!StringUtil.isEmpty((String)this.path)) {
                        yield null;
                    }
                    yield JsonBundle.message((String)"schema.configuration.error.empty.pattern", (Object[])new Object[0]);
                }
                case JsonMappingKind.Directory -> null;
            };
        }

        public boolean isPattern() {
            return this.mappingKind == JsonMappingKind.Pattern;
        }

        public void setPattern(boolean pattern) {
            this.mappingKind = pattern ? JsonMappingKind.Pattern : JsonMappingKind.File;
        }

        public boolean isDirectory() {
            return this.mappingKind == JsonMappingKind.Directory;
        }

        public void setDirectory(boolean directory) {
            this.mappingKind = directory ? JsonMappingKind.Directory : JsonMappingKind.File;
        }

        public String getPresentation() {
            if (this.mappingKind == JsonMappingKind.Directory && StringUtil.isEmpty((String)this.path)) {
                return JsonBundle.message((String)"schema.configuration.project.directory", (Object[])new Object[]{this.mappingKind.getPrefix()});
            }
            return this.mappingKind.getPrefix() + this.getPath();
        }

        public String[] getPathParts() {
            return UserDefinedJsonSchemaConfiguration.pathToParts(this.path);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Item item = (Item)o;
            if (this.mappingKind != item.mappingKind) {
                return false;
            }
            return Objects.equals(this.path, item.path);
        }

        public int hashCode() {
            int result = Objects.hashCode(this.path);
            result = 31 * result + Objects.hashCode((Object)this.mappingKind);
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 5, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 1: 
                case 2: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/jsonSchema/UserDefinedJsonSchemaConfiguration$Item";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/jsonSchema/UserDefinedJsonSchemaConfiguration$Item";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "normalizePath";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "neutralizePath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "normalizePath";
                    break;
                }
                case 1: 
                case 2: 
                case 5: 
                case 6: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "preserveSlashes";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "neutralizePath";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 5, 6 -> new IllegalStateException(string);
            };
        }
    }
}

