/*
 * Decompiled with CFR 0.152.
 */
package json.ext;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import json.ext.AbstractByteListDirectOutputStream;
import json.ext.GeneratorState;
import json.ext.RuntimeInfo;
import json.ext.StringEncoder;
import json.ext.StringEncoderAsciiOnly;
import json.ext.Utils;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyIO;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.IOOutputStream;
import org.jruby.util.TypeConverter;

public final class Generator {
    private static final int IO_BUFFER_SIZE = 8192;
    static final Handler<RubyBignum> BIGNUM_HANDLER = new BignumHandler();
    static final Handler<RubyFixnum> FIXNUM_HANDLER = new FixnumHandler();
    static final Handler<RubyFloat> FLOAT_HANDLER = new FloatHandler();
    static final Handler<RubyArray<IRubyObject>> ARRAY_HANDLER = new ArrayHandler();
    static final Handler<RubyHash> HASH_HANDLER = new HashHandler();
    static final Handler<RubyString> STRING_HANDLER = new StringHandler();
    private static final byte[] TRUE_STRING = "true".getBytes();
    static final Handler<RubyBoolean> TRUE_HANDLER = new KeywordHandler<RubyBoolean>(TRUE_STRING);
    private static final byte[] FALSE_STRING = "false".getBytes();
    static final Handler<RubyBoolean> FALSE_HANDLER = new KeywordHandler<RubyBoolean>(FALSE_STRING);
    private static final byte[] NULL_STRING = "null".getBytes();
    static final Handler<IRubyObject> NIL_HANDLER = new KeywordHandler<IRubyObject>(NULL_STRING);
    static final Handler<IRubyObject> FRAGMENT_HANDLER = new FragmentHandler();
    static final Handler<RubySymbol> SYMBOL_HANDLER = new SymbolHandler();
    static final Handler<IRubyObject> OBJECT_HANDLER = new ObjectHandler();
    static final Handler<IRubyObject> GENERIC_HANDLER = new GenericHandler();
    private static final byte[] MIN_VALUE_BYTES_RADIX_10 = ByteList.plain((CharSequence)Long.toString(Long.MIN_VALUE, 10));
    private static final byte[] EMPTY_ARRAY_BYTES = "[]".getBytes();
    private static final byte[] EMPTY_HASH_BYTES = "{}".getBytes();

    private Generator() {
        throw new RuntimeException();
    }

    static <T extends IRubyObject> RubyString generateJson(ThreadContext threadContext, T t, Handler<? super T> handler) {
        Session session = new Session(null);
        return handler.generateNew(threadContext, session, t);
    }

    static <T extends IRubyObject> RubyString generateJson(ThreadContext threadContext, T t, Handler<? super T> handler, IRubyObject iRubyObject) {
        Session session = new Session(iRubyObject);
        return handler.generateNew(threadContext, session, t);
    }

    static <T extends IRubyObject> RubyString generateJson(ThreadContext threadContext, T t) {
        Handler<T> handler = Generator.getHandlerFor(threadContext.runtime, t);
        return Generator.generateJson(threadContext, t, handler);
    }

    static <T extends IRubyObject> RubyString generateJson(ThreadContext threadContext, T t, IRubyObject iRubyObject) {
        Handler<T> handler = Generator.getHandlerFor(threadContext.runtime, t);
        return Generator.generateJson(threadContext, t, handler, iRubyObject);
    }

    public static <T extends IRubyObject> IRubyObject generateJson(ThreadContext threadContext, T t, GeneratorState generatorState, IRubyObject iRubyObject) {
        Session session = new Session(generatorState);
        Handler<T> handler = Generator.getHandlerFor(threadContext.runtime, t);
        if (iRubyObject.isNil()) {
            return handler.generateNew(threadContext, session, t);
        }
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream((OutputStream)((Object)new PatchedIOOutputStream(iRubyObject, (Encoding)UTF8Encoding.INSTANCE)), 8192);
        handler.generateToBuffer(threadContext, session, t, bufferedOutputStream);
        return iRubyObject;
    }

    private static <T extends IRubyObject> Handler<? super T> getHandlerFor(Ruby ruby, T t) {
        switch (((RubyBasicObject)t).getNativeClassIndex()) {
            case NIL: {
                return NIL_HANDLER;
            }
            case TRUE: {
                return TRUE_HANDLER;
            }
            case FALSE: {
                return FALSE_HANDLER;
            }
            case FLOAT: {
                return FLOAT_HANDLER;
            }
            case FIXNUM: {
                return FIXNUM_HANDLER;
            }
            case BIGNUM: {
                return BIGNUM_HANDLER;
            }
            case SYMBOL: {
                return SYMBOL_HANDLER;
            }
            case STRING: {
                if (Helpers.metaclass(t) != ruby.getString()) break;
                return STRING_HANDLER;
            }
            case ARRAY: {
                if (Helpers.metaclass(t) != ruby.getArray()) break;
                return ARRAY_HANDLER;
            }
            case HASH: {
                if (Helpers.metaclass(t) != ruby.getHash()) break;
                return HASH_HANDLER;
            }
            case STRUCT: {
                RuntimeInfo runtimeInfo = RuntimeInfo.forRuntime(ruby);
                RubyClass rubyClass = ((RubyModule)runtimeInfo.jsonModule.get()).getClass("Fragment");
                if (Helpers.metaclass(t) != rubyClass) break;
                return FRAGMENT_HANDLER;
            }
        }
        return GENERIC_HANDLER;
    }

    private static <T extends IRubyObject> void generateFor(ThreadContext threadContext, Session session, T t, OutputStream outputStream) throws IOException {
        switch (((RubyBasicObject)t).getNativeClassIndex()) {
            case NIL: {
                outputStream.write(NULL_STRING);
                return;
            }
            case TRUE: {
                outputStream.write(TRUE_STRING);
                return;
            }
            case FALSE: {
                outputStream.write(FALSE_STRING);
                return;
            }
            case FLOAT: {
                Generator.generateFloat(threadContext, session, (RubyFloat)t, outputStream);
                return;
            }
            case FIXNUM: {
                Generator.generateFixnum(session, (RubyFixnum)t, outputStream);
                return;
            }
            case BIGNUM: {
                Generator.generateBignum((RubyBignum)t, outputStream);
                return;
            }
            case SYMBOL: {
                Generator.generateSymbol(threadContext, session, (RubySymbol)t, outputStream);
                return;
            }
            case STRING: {
                if (Helpers.metaclass(t) != threadContext.runtime.getString()) break;
                Generator.generateString(threadContext, session, (RubyString)t, outputStream);
                return;
            }
            case ARRAY: {
                if (Helpers.metaclass(t) != threadContext.runtime.getArray()) break;
                Generator.generateArray(threadContext, session, (RubyArray<IRubyObject>)((RubyArray)t), outputStream);
                return;
            }
            case HASH: {
                if (Helpers.metaclass(t) != threadContext.runtime.getHash()) break;
                Generator.generateHash(threadContext, session, (RubyHash)t, outputStream);
                return;
            }
            case STRUCT: {
                RuntimeInfo runtimeInfo = RuntimeInfo.forRuntime(threadContext.runtime);
                RubyClass rubyClass = ((RubyModule)runtimeInfo.jsonModule.get()).getClass("Fragment");
                if (Helpers.metaclass(t) != rubyClass) break;
                Generator.generateFragment(threadContext, session, t, outputStream);
                return;
            }
        }
        Generator.generateGeneric(threadContext, session, t, outputStream);
    }

    private static void generateBignum(RubyBignum rubyBignum, OutputStream outputStream) throws IOException {
        BigInteger bigInteger = rubyBignum.getValue();
        outputStream.write(bigInteger.toString().getBytes(StandardCharsets.UTF_8));
    }

    static void generateFixnum(Session session, RubyFixnum rubyFixnum, OutputStream outputStream) throws IOException {
        long l = rubyFixnum.getLongValue();
        if (l == 0L) {
            outputStream.write(48);
        } else if (l == Long.MIN_VALUE) {
            outputStream.write(MIN_VALUE_BYTES_RADIX_10);
        } else {
            byte[] byArray = session.getCharBytes();
            Generator.appendFixnum(outputStream, byArray, l);
        }
    }

    static void appendFixnum(OutputStream outputStream, byte[] byArray, long l) throws IOException {
        int n = byArray.length;
        int n2 = Generator.fltoa(l, byArray, n);
        outputStream.write(byArray, n - n2, n2);
    }

    static int fltoa(long l, byte[] byArray, int n) {
        boolean bl = l < 0L;
        int n2 = n;
        if (bl) {
            l = -l;
        }
        do {
            byArray[--n2] = (byte)((int)(l % 10L) + 48);
        } while ((l /= 10L) != 0L);
        if (bl) {
            byArray[--n2] = 45;
        }
        return n - n2;
    }

    static void generateFloat(ThreadContext threadContext, Session session, RubyFloat rubyFloat, OutputStream outputStream) throws IOException {
        GeneratorState generatorState;
        double d = rubyFloat.getValue();
        if ((Double.isInfinite(d) || Double.isNaN(d)) && !(generatorState = session.getState(threadContext)).allowNaN()) {
            IRubyObject iRubyObject;
            if (generatorState.strict() && generatorState.getAsJSON() != null && (iRubyObject = generatorState.getAsJSON().call(threadContext, new IRubyObject[]{rubyFloat, threadContext.getRuntime().getFalse()})) != rubyFloat) {
                Generator.getHandlerFor(threadContext.runtime, iRubyObject).generate(threadContext, session, iRubyObject, outputStream);
                return;
            }
            throw Utils.buildGeneratorError(threadContext, (IRubyObject)rubyFloat, rubyFloat + " not allowed in JSON").toThrowable();
        }
        outputStream.write(Double.toString(d).getBytes(StandardCharsets.UTF_8));
    }

    static void generateArray(ThreadContext threadContext, Session session, RubyArray<IRubyObject> rubyArray, OutputStream outputStream) throws IOException {
        int n;
        GeneratorState generatorState = session.getState(threadContext);
        int n2 = generatorState.increaseDepth(threadContext);
        if (rubyArray.isEmpty()) {
            outputStream.write(EMPTY_ARRAY_BYTES);
            generatorState.decreaseDepth();
            return;
        }
        ByteList byteList = generatorState.getIndent();
        ByteList byteList2 = generatorState.getArrayNl();
        byte[] byArray = byteList2.unsafeBytes();
        int n3 = byteList2.begin();
        int n4 = byteList2.realSize();
        boolean bl = n4 == 0;
        outputStream.write(91);
        outputStream.write(byArray, n3, n4);
        int n5 = rubyArray.getLength();
        for (n = 0; n < n5; ++n) {
            IRubyObject iRubyObject = rubyArray.eltInternal(n);
            if (n > 0) {
                outputStream.write(44);
                if (!bl) {
                    outputStream.write(byArray, n3, n4);
                }
            }
            Utils.repeatWrite(outputStream, byteList, n2);
            Generator.generateFor(threadContext, session, iRubyObject, outputStream);
        }
        n = generatorState.decreaseDepth();
        if (!bl) {
            outputStream.write(byArray, n3, n4);
            Utils.repeatWrite(outputStream, byteList, n);
        }
        outputStream.write(93);
    }

    static void generateHash(ThreadContext threadContext, Session session, RubyHash rubyHash, OutputStream outputStream) throws IOException {
        GeneratorState generatorState = session.getState(threadContext);
        int n = generatorState.increaseDepth(threadContext);
        if (rubyHash.isEmpty()) {
            outputStream.write(EMPTY_HASH_BYTES);
            generatorState.decreaseDepth();
            return;
        }
        ByteList byteList = generatorState.getObjectNl();
        byte[] byArray = byteList.unsafeBytes();
        byte[] byArray2 = Utils.repeat(generatorState.getIndent(), n);
        ByteList byteList2 = generatorState.getSpaceBefore();
        ByteList byteList3 = generatorState.getSpace();
        outputStream.write(123);
        outputStream.write(byArray);
        boolean bl = true;
        HashKeyTracker hashKeyTracker = new HashKeyTracker(rubyHash);
        for (RubyHash.RubyHashEntry rubyHashEntry : rubyHash.directEntrySet()) {
            if (bl) {
                hashKeyTracker.trackFirst(threadContext, session, (IRubyObject)rubyHashEntry.getKey());
            } else {
                hashKeyTracker.track(threadContext, session, (IRubyObject)rubyHashEntry.getKey());
            }
            Generator.processEntry(threadContext, session, outputStream, rubyHashEntry, bl, byteList, byArray2, byteList2, byteList3);
            bl = false;
        }
        int n2 = generatorState.decreaseDepth();
        if (!bl && !byteList.isEmpty()) {
            outputStream.write(byArray);
        }
        Utils.repeatWrite(outputStream, generatorState.getIndent(), n2);
        outputStream.write(125);
    }

    private static IRubyObject castKey(ThreadContext threadContext, IRubyObject iRubyObject) {
        RubyClass rubyClass = iRubyObject.getType();
        Ruby ruby = threadContext.runtime;
        if (iRubyObject instanceof RubyString) {
            if (rubyClass == ruby.getString()) {
                return iRubyObject;
            }
            return iRubyObject.callMethod(threadContext, "to_s");
        }
        if (rubyClass == ruby.getSymbol()) {
            return ((RubySymbol)iRubyObject).id2name(threadContext);
        }
        return null;
    }

    private static void processEntry(ThreadContext threadContext, Session session, OutputStream outputStream, RubyHash.RubyHashEntry rubyHashEntry, boolean bl, ByteList byteList, byte[] byArray, ByteList byteList2, ByteList byteList3) {
        StringEncoder stringEncoder = session.getStringEncoder(threadContext);
        IRubyObject iRubyObject = (IRubyObject)rubyHashEntry.getKey();
        IRubyObject iRubyObject2 = (IRubyObject)rubyHashEntry.getValue();
        try {
            IRubyObject iRubyObject3;
            Ruby ruby;
            block14: {
                GeneratorState generatorState;
                block13: {
                    if (!bl) {
                        outputStream.write(44);
                        outputStream.write(byteList.unsafeBytes());
                    }
                    if (!byteList.isEmpty()) {
                        outputStream.write(byArray);
                    }
                    ruby = threadContext.runtime;
                    iRubyObject3 = Generator.castKey(threadContext, iRubyObject);
                    if (iRubyObject3 == null || !(iRubyObject3 instanceof RubyString)) break block13;
                    if (StringEncoder.hasValidEncoding((RubyString)iRubyObject3)) break block14;
                }
                if ((generatorState = session.getState(threadContext)).strict()) {
                    if (generatorState.getAsJSON() != null) {
                        iRubyObject = generatorState.getAsJSON().call(threadContext, new IRubyObject[]{iRubyObject, threadContext.getRuntime().getTrue()});
                        iRubyObject3 = Generator.castKey(threadContext, iRubyObject);
                    }
                    if (iRubyObject3 == null) {
                        throw Utils.buildGeneratorError(threadContext, iRubyObject, iRubyObject.getType().name(threadContext) + " not allowed as object key in JSON").toThrowable();
                    }
                } else {
                    iRubyObject3 = TypeConverter.convertToType((IRubyObject)iRubyObject, (RubyClass)ruby.getString(), (String)"to_s");
                }
            }
            if (iRubyObject3.getMetaClass() == ruby.getString()) {
                Generator.generateString(threadContext, session, (RubyString)iRubyObject3, outputStream);
            } else {
                Utils.ensureString(iRubyObject3);
                Generator.generateFor(threadContext, session, iRubyObject3, outputStream);
            }
            outputStream.write(byteList2.unsafeBytes());
            outputStream.write(58);
            outputStream.write(byteList3.unsafeBytes());
            Generator.generateFor(threadContext, session, iRubyObject2, outputStream);
        }
        catch (Throwable throwable) {
            Helpers.throwException((Throwable)throwable);
        }
    }

    static void generateString(ThreadContext threadContext, Session session, RubyString rubyString, OutputStream outputStream) throws IOException {
        session.getStringEncoder(threadContext).generate(threadContext, rubyString, outputStream);
    }

    static RubyString generateFragmentNew(ThreadContext threadContext, Session session, IRubyObject iRubyObject) {
        GeneratorState generatorState = session.getState(threadContext);
        IRubyObject iRubyObject2 = iRubyObject.callMethod(threadContext, "to_json", (IRubyObject)generatorState);
        if (iRubyObject2 instanceof RubyString) {
            return (RubyString)iRubyObject2;
        }
        throw threadContext.runtime.newTypeError("to_json must return a String");
    }

    static void generateFragment(ThreadContext threadContext, Session session, IRubyObject iRubyObject, OutputStream outputStream) throws IOException {
        RubyString rubyString = Generator.generateFragmentNew(threadContext, session, iRubyObject);
        ByteList byteList = rubyString.getByteList();
        outputStream.write(byteList.unsafeBytes(), byteList.begin(), byteList.length());
    }

    static void generateSymbol(ThreadContext threadContext, Session session, RubySymbol rubySymbol, OutputStream outputStream) throws IOException {
        GeneratorState generatorState = session.getState(threadContext);
        if (generatorState.strict()) {
            STRING_HANDLER.generate(threadContext, session, rubySymbol.asString(), outputStream);
        } else {
            GENERIC_HANDLER.generate(threadContext, session, (IRubyObject)rubySymbol, outputStream);
        }
    }

    static RubyString generateObjectNew(ThreadContext threadContext, Session session, IRubyObject iRubyObject) {
        RubyString rubyString = iRubyObject.asString();
        return STRING_HANDLER.generateNew(threadContext, session, rubyString);
    }

    static void generateObject(ThreadContext threadContext, Session session, IRubyObject iRubyObject, OutputStream outputStream) throws IOException {
        Generator.generateString(threadContext, session, iRubyObject.asString(), outputStream);
    }

    static RubyString generateGenericNew(ThreadContext threadContext, Session session, IRubyObject iRubyObject) {
        GeneratorState generatorState = session.getState(threadContext);
        if (generatorState.strict()) {
            if (generatorState.getAsJSON() != null) {
                IRubyObject iRubyObject2 = generatorState.getAsJSON().call(threadContext, new IRubyObject[]{iRubyObject, threadContext.getRuntime().getFalse()});
                Handler<IRubyObject> handler = Generator.getHandlerFor(threadContext.runtime, iRubyObject2);
                if (handler == GENERIC_HANDLER) {
                    throw Utils.buildGeneratorError(threadContext, iRubyObject, iRubyObject2 + " returned by as_json not allowed in JSON").toThrowable();
                }
                return handler.generateNew(threadContext, session, iRubyObject2);
            }
            throw Utils.buildGeneratorError(threadContext, iRubyObject, iRubyObject + " not allowed in JSON").toThrowable();
        }
        if (iRubyObject.respondsTo("to_json")) {
            IRubyObject iRubyObject3 = iRubyObject.callMethod(threadContext, "to_json", (IRubyObject)generatorState);
            if (iRubyObject3 instanceof RubyString) {
                return (RubyString)iRubyObject3;
            }
            throw threadContext.runtime.newTypeError("to_json must return a String");
        }
        return OBJECT_HANDLER.generateNew(threadContext, session, iRubyObject);
    }

    static void generateGeneric(ThreadContext threadContext, Session session, IRubyObject iRubyObject, OutputStream outputStream) throws IOException {
        RubyString rubyString = Generator.generateGenericNew(threadContext, session, iRubyObject);
        ByteList byteList = rubyString.getByteList();
        outputStream.write(byteList.unsafeBytes(), byteList.begin(), byteList.length());
    }

    private static class GenericHandler
    extends Handler<IRubyObject> {
        private GenericHandler() {
        }

        @Override
        RubyString generateNew(ThreadContext threadContext, Session session, IRubyObject iRubyObject) {
            return Generator.generateGenericNew(threadContext, session, iRubyObject);
        }

        @Override
        void generate(ThreadContext threadContext, Session session, IRubyObject iRubyObject, OutputStream outputStream) throws IOException {
            Generator.generateGeneric(threadContext, session, iRubyObject, outputStream);
        }
    }

    private static class ObjectHandler
    extends Handler<IRubyObject> {
        private ObjectHandler() {
        }

        @Override
        RubyString generateNew(ThreadContext threadContext, Session session, IRubyObject iRubyObject) {
            return Generator.generateObjectNew(threadContext, session, iRubyObject);
        }

        @Override
        void generate(ThreadContext threadContext, Session session, IRubyObject iRubyObject, OutputStream outputStream) throws IOException {
            Generator.generateObject(threadContext, session, iRubyObject, outputStream);
        }
    }

    private static class SymbolHandler
    extends Handler<RubySymbol> {
        private SymbolHandler() {
        }

        @Override
        int guessSize(ThreadContext threadContext, Session session, RubySymbol rubySymbol) {
            GeneratorState generatorState = session.getState(threadContext);
            if (generatorState.strict()) {
                return STRING_HANDLER.guessSize(threadContext, session, rubySymbol.asString());
            }
            return GENERIC_HANDLER.guessSize(threadContext, session, (IRubyObject)rubySymbol);
        }

        @Override
        void generate(ThreadContext threadContext, Session session, RubySymbol rubySymbol, OutputStream outputStream) throws IOException {
            Generator.generateSymbol(threadContext, session, rubySymbol, outputStream);
        }
    }

    private static class FragmentHandler
    extends Handler<IRubyObject> {
        private FragmentHandler() {
        }

        @Override
        RubyString generateNew(ThreadContext threadContext, Session session, IRubyObject iRubyObject) {
            return Generator.generateFragmentNew(threadContext, session, iRubyObject);
        }

        @Override
        void generate(ThreadContext threadContext, Session session, IRubyObject iRubyObject, OutputStream outputStream) throws IOException {
            Generator.generateFragment(threadContext, session, iRubyObject, outputStream);
        }
    }

    private static class StringHandler
    extends Handler<RubyString> {
        private StringHandler() {
        }

        @Override
        int guessSize(ThreadContext threadContext, Session session, RubyString rubyString) {
            return 2 + rubyString.getByteList().length();
        }

        @Override
        void generate(ThreadContext threadContext, Session session, RubyString rubyString, OutputStream outputStream) throws IOException {
            GeneratorState generatorState = session.getState(threadContext);
            StringEncoder stringEncoder = session.getStringEncoder(threadContext);
            if (generatorState.strict()) {
                if (!StringEncoder.hasValidEncoding(rubyString) && generatorState.getAsJSON() != null) {
                    IRubyObject iRubyObject = generatorState.getAsJSON().call(threadContext, new IRubyObject[]{rubyString, threadContext.getRuntime().getFalse()});
                    if (iRubyObject instanceof RubyString) {
                        rubyString = (RubyString)iRubyObject;
                    } else {
                        Handler handler = Generator.getHandlerFor(threadContext.runtime, iRubyObject);
                        handler.generate(threadContext, session, iRubyObject, outputStream);
                        return;
                    }
                }
            }
            Generator.generateString(threadContext, session, rubyString, outputStream);
        }
    }

    private static class HashKeyTracker {
        private KeyType keyType;
        private boolean done;
        private RubyHash hash;

        private HashKeyTracker(RubyHash rubyHash) {
            this.hash = rubyHash;
            this.done = false;
            this.keyType = KeyType.UNKNOWN;
        }

        public void trackFirst(ThreadContext threadContext, Session session, IRubyObject iRubyObject) {
            if (iRubyObject instanceof RubyString) {
                this.keyType = KeyType.STRING;
            } else if (iRubyObject.getType() == threadContext.runtime.getSymbol()) {
                this.keyType = KeyType.SYMBOL;
            } else {
                this.done = true;
                this.report(threadContext, session);
            }
        }

        public void track(ThreadContext threadContext, Session session, IRubyObject iRubyObject) {
            if (!this.done) {
                if (this.keyType == KeyType.STRING) {
                    if (!(iRubyObject instanceof RubyString)) {
                        this.report(threadContext, session);
                    }
                } else if (iRubyObject.getType() != threadContext.runtime.getSymbol()) {
                    this.report(threadContext, session);
                }
            }
        }

        private void report(ThreadContext threadContext, Session session) {
            this.done = true;
            RuntimeInfo runtimeInfo = session.getInfo(threadContext);
            GeneratorState generatorState = session.getState(threadContext);
            if (!generatorState.getAllowDuplicateKey()) {
                if (generatorState.getDeprecateDuplicateKey()) {
                    IRubyObject[] iRubyObjectArray = new IRubyObject[]{this.hash, threadContext.getRuntime().getFalse()};
                    ((RubyModule)runtimeInfo.jsonModule.get()).callMethod(threadContext, "on_mixed_keys_hash", iRubyObjectArray);
                } else {
                    IRubyObject[] iRubyObjectArray = new IRubyObject[]{this.hash, threadContext.getRuntime().getTrue()};
                    ((RubyModule)runtimeInfo.jsonModule.get()).callMethod(threadContext, "on_mixed_keys_hash", iRubyObjectArray);
                }
            }
        }

        static enum KeyType {
            UNKNOWN,
            STRING,
            SYMBOL;

        }
    }

    private static class HashHandler
    extends Handler<RubyHash> {
        private HashHandler() {
        }

        @Override
        int guessSize(ThreadContext threadContext, Session session, RubyHash rubyHash) {
            GeneratorState generatorState = session.getState(threadContext);
            int n = 12 + (generatorState.getDepth() + 1) * generatorState.getIndent().length() + generatorState.getSpaceBefore().length() + generatorState.getSpace().length();
            return 2 + rubyHash.size() * n;
        }

        @Override
        void generate(ThreadContext threadContext, Session session, RubyHash rubyHash, OutputStream outputStream) throws IOException {
            Generator.generateHash(threadContext, session, rubyHash, outputStream);
        }
    }

    private static class ArrayHandler
    extends Handler<RubyArray<IRubyObject>> {
        private ArrayHandler() {
        }

        @Override
        int guessSize(ThreadContext threadContext, Session session, RubyArray<IRubyObject> rubyArray) {
            GeneratorState generatorState = session.getState(threadContext);
            int n = generatorState.getDepth();
            int n2 = 4 + (n + 1) * generatorState.getIndent().length() + 1 + generatorState.getArrayNl().length();
            return 2 + rubyArray.size() * n2;
        }

        @Override
        void generate(ThreadContext threadContext, Session session, RubyArray<IRubyObject> rubyArray, OutputStream outputStream) throws IOException {
            Generator.generateArray(threadContext, session, rubyArray, outputStream);
        }
    }

    private static class FloatHandler
    extends Handler<RubyFloat> {
        private FloatHandler() {
        }

        @Override
        void generate(ThreadContext threadContext, Session session, RubyFloat rubyFloat, OutputStream outputStream) throws IOException {
            Generator.generateFloat(threadContext, session, rubyFloat, outputStream);
        }
    }

    private static class FixnumHandler
    extends Handler<RubyFixnum> {
        private FixnumHandler() {
        }

        @Override
        void generate(ThreadContext threadContext, Session session, RubyFixnum rubyFixnum, OutputStream outputStream) throws IOException {
            Generator.generateFixnum(session, rubyFixnum, outputStream);
        }
    }

    private static class BignumHandler
    extends Handler<RubyBignum> {
        private BignumHandler() {
        }

        @Override
        void generate(ThreadContext threadContext, Session session, RubyBignum rubyBignum, OutputStream outputStream) throws IOException {
            Generator.generateBignum(rubyBignum, outputStream);
        }
    }

    private static class KeywordHandler<T extends IRubyObject>
    extends Handler<T> {
        private final byte[] keyword;

        private KeywordHandler(byte[] byArray) {
            this.keyword = byArray;
        }

        @Override
        int guessSize(ThreadContext threadContext, Session session, T t) {
            return this.keyword.length;
        }

        @Override
        RubyString generateNew(ThreadContext threadContext, Session session, T t) {
            return RubyString.newStringShared((Ruby)threadContext.runtime, (byte[])this.keyword);
        }

        @Override
        void generate(ThreadContext threadContext, Session session, T t, OutputStream outputStream) throws IOException {
            outputStream.write(this.keyword);
        }
    }

    private static abstract class Handler<T extends IRubyObject> {
        private Handler() {
        }

        int guessSize(ThreadContext threadContext, Session session, T t) {
            return 4;
        }

        RubyString generateNew(ThreadContext threadContext, Session session, T t) {
            AbstractByteListDirectOutputStream abstractByteListDirectOutputStream = AbstractByteListDirectOutputStream.create(this.guessSize(threadContext, session, t));
            this.generateToBuffer(threadContext, session, t, abstractByteListDirectOutputStream);
            return RubyString.newString((Ruby)threadContext.runtime, (ByteList)abstractByteListDirectOutputStream.toByteListDirect((Encoding)UTF8Encoding.INSTANCE));
        }

        void generateToBuffer(ThreadContext threadContext, Session session, T t, OutputStream outputStream) {
            try {
                this.generate(threadContext, session, t, outputStream);
                outputStream.flush();
            }
            catch (IOException iOException) {
                throw threadContext.runtime.newIOErrorFromException(iOException);
            }
        }

        abstract void generate(ThreadContext var1, Session var2, T var3, OutputStream var4) throws IOException;
    }

    static class Session {
        private static final int MAX_LONG_CHARS = Long.toString(Long.MIN_VALUE).length();
        private GeneratorState state;
        private IRubyObject possibleState;
        private RuntimeInfo info;
        private StringEncoder stringEncoder;
        private byte[] charBytes;

        Session(GeneratorState generatorState) {
            this.state = generatorState;
        }

        Session(IRubyObject iRubyObject) {
            this.possibleState = iRubyObject == null || iRubyObject.isNil() ? null : iRubyObject;
        }

        public GeneratorState getState(ThreadContext threadContext) {
            if (this.state == null) {
                this.state = GeneratorState.fromState(threadContext, this.getInfo(threadContext), this.possibleState);
            }
            return this.state;
        }

        public RuntimeInfo getInfo(ThreadContext threadContext) {
            if (this.info == null) {
                this.info = RuntimeInfo.forRuntime(threadContext.runtime);
            }
            return this.info;
        }

        public byte[] getCharBytes() {
            byte[] byArray = this.charBytes;
            if (byArray == null) {
                byArray = this.charBytes = new byte[MAX_LONG_CHARS];
            }
            return byArray;
        }

        public StringEncoder getStringEncoder(ThreadContext threadContext) {
            if (this.stringEncoder == null) {
                GeneratorState generatorState = this.getState(threadContext);
                this.stringEncoder = generatorState.asciiOnly() ? new StringEncoderAsciiOnly(generatorState.scriptSafe()) : (generatorState.scriptSafe() ? new StringEncoder(generatorState.scriptSafe()) : StringEncoder.createBasicEncoder());
            }
            return this.stringEncoder;
        }
    }

    private static class PatchedIOOutputStream
    extends IOOutputStream {
        public PatchedIOOutputStream(IRubyObject iRubyObject, Encoding encoding) {
            super(iRubyObject, encoding);
        }

        public RubyIO getRealIO(IRubyObject iRubyObject) {
            RubyIO rubyIO = super.getRealIO(iRubyObject);
            if (rubyIO == null || rubyIO.getEnc() != null) {
                return null;
            }
            return rubyIO;
        }
    }
}

