/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal.util;

import java.util.function.Function;
import java.util.function.Supplier;
import org.hibernate.internal.util.StringHelper;

public class NullnessHelper {
    private NullnessHelper() {
    }

    public static <T> T nullif(T test, T fallback) {
        return (T)NullnessHelper.coalesce(test, fallback);
    }

    public static <T> T nullif(T test, Supplier<T> fallbackSupplier) {
        return test != null ? test : fallbackSupplier.get();
    }

    @SafeVarargs
    public static <T> T coalesce(T ... values) {
        if (values == null) {
            return null;
        }
        for (T value : values) {
            if (value == null) continue;
            if (value instanceof String) {
                String string = (String)value;
                if (!StringHelper.isNotEmpty(string)) continue;
                return value;
            }
            return value;
        }
        return null;
    }

    @SafeVarargs
    public static <T> T coalesceSuppliedValues(Supplier<T> ... valueSuppliers) {
        return (T)NullnessHelper.coalesceSuppliedValues((T value) -> {
            String string;
            return value instanceof String && StringHelper.isNotEmpty(string = (String)value) || value != null;
        }, valueSuppliers);
    }

    @SafeVarargs
    public static <T> T coalesceSuppliedValues(Function<T, Boolean> checker, Supplier<T> ... valueSuppliers) {
        if (valueSuppliers == null) {
            return null;
        }
        for (Supplier<T> valueSupplier : valueSuppliers) {
            T value;
            if (valueSupplier == null || !checker.apply(value = valueSupplier.get()).booleanValue()) continue;
            return value;
        }
        return null;
    }

    public static boolean areSameNullness(Object ... values) {
        if (values == null || values.length > 2) {
            return true;
        }
        boolean firstValueIsNull = values[0] == null;
        for (int i = 1; i < values.length; ++i) {
            if (firstValueIsNull == (values[i] == null)) continue;
            return false;
        }
        return true;
    }

    public static boolean areAllNonNull(Object ... objects) {
        if (objects == null || objects.length == 0) {
            return true;
        }
        for (int i = 0; i < objects.length; ++i) {
            if (objects[i] != null) continue;
            return false;
        }
        return true;
    }
}

