/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.workflow.conditions;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.workflow.WorkflowConditionProvider;
import org.keycloak.models.workflow.WorkflowEvent;
import org.keycloak.models.workflow.WorkflowInvalidStateException;
import org.keycloak.models.workflow.conditions.expression.BooleanConditionEvaluator;
import org.keycloak.models.workflow.conditions.expression.BooleanConditionLexer;
import org.keycloak.models.workflow.conditions.expression.BooleanConditionParser;
import org.keycloak.models.workflow.conditions.expression.ErrorListener;
import org.keycloak.models.workflow.conditions.expression.PredicateConditionEvaluator;

public class ExpressionWorkflowConditionProvider
implements WorkflowConditionProvider {
    private final String expression;
    private final KeycloakSession session;
    private BooleanConditionParser.EvaluatorContext evaluatorContext;

    public ExpressionWorkflowConditionProvider(KeycloakSession session, String expression) {
        this.session = session;
        this.expression = expression;
    }

    public boolean evaluate(WorkflowEvent event) {
        this.validate();
        BooleanConditionEvaluator evaluator = new BooleanConditionEvaluator(this.session, event);
        return (Boolean)evaluator.visit((ParseTree)this.evaluatorContext);
    }

    public Predicate toPredicate(CriteriaBuilder cb, CriteriaQuery<String> query, Root<?> userRoot) {
        this.validate();
        PredicateConditionEvaluator evaluator = new PredicateConditionEvaluator(this.session, cb, query, userRoot);
        return (Predicate)evaluator.visit((ParseTree)this.evaluatorContext);
    }

    public void validate() {
        if (this.evaluatorContext == null) {
            CodePointCharStream charStream = CharStreams.fromString((String)this.expression);
            BooleanConditionLexer lexer = new BooleanConditionLexer((CharStream)charStream);
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            BooleanConditionParser parser = new BooleanConditionParser((TokenStream)tokens);
            ErrorListener errorListener = new ErrorListener();
            parser.removeErrorListeners();
            parser.addErrorListener((ANTLRErrorListener)errorListener);
            BooleanConditionParser.EvaluatorContext context = parser.evaluator();
            if (errorListener.hasErrors()) {
                String lineSeparator = System.lineSeparator();
                String errorDetails = errorListener.getErrorMessages().stream().map(error -> "- " + error).collect(Collectors.joining(lineSeparator));
                throw new WorkflowInvalidStateException(String.format("Invalid expression: %s%sError details:%s%s", this.expression, lineSeparator, lineSeparator, errorDetails));
            }
            this.evaluatorContext = context;
        }
    }

    public void close() {
    }
}

