/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.executor;

import java.net.URI;
import org.keycloak.dom.saml.v2.protocol.AuthnRequestType;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.saml.SamlClient;
import org.keycloak.representations.idm.ClientPolicyExecutorConfigurationRepresentation;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.context.AdminClientRegisteredContext;
import org.keycloak.services.clientpolicy.context.AdminClientUpdatedContext;
import org.keycloak.services.clientpolicy.context.SamlAuthnRequestContext;
import org.keycloak.services.clientpolicy.context.SamlLogoutRequestContext;
import org.keycloak.services.clientpolicy.executor.ClientPolicyExecutorProvider;

public class SamlAvoidRedirectBindingExecutor
implements ClientPolicyExecutorProvider<ClientPolicyExecutorConfigurationRepresentation> {
    public SamlAvoidRedirectBindingExecutor(KeycloakSession session) {
    }

    public String getProviderId() {
        return "saml-avoid-redirect";
    }

    public void executeOnEvent(ClientPolicyContext context) throws ClientPolicyException {
        switch (context.getEvent()) {
            case REGISTERED: {
                this.confirmPostBindingIsForced(((AdminClientRegisteredContext)context).getTargetClient());
                break;
            }
            case UPDATED: {
                this.confirmPostBindingIsForced(((AdminClientUpdatedContext)context).getTargetClient());
                break;
            }
            case SAML_AUTHN_REQUEST: {
                this.confirmRedirectBindingIsNotUsed((SamlAuthnRequestContext)context);
                break;
            }
            case SAML_LOGOUT_REQUEST: {
                this.confirmRedirectBindingIsNotUsed((SamlLogoutRequestContext)context);
            }
        }
    }

    private void confirmPostBindingIsForced(ClientModel client) throws ClientPolicyException {
        SamlClient samlClient;
        if ("saml".equals(client.getProtocol()) && !(samlClient = new SamlClient(client)).forcePostBinding()) {
            throw new ClientPolicyException("invalid_client_metadata", "Force POST binding is not enabled");
        }
    }

    private void confirmRedirectBindingIsNotUsed(SamlAuthnRequestContext context) throws ClientPolicyException {
        SamlClient samlClient = new SamlClient(context.getClient());
        if (samlClient.forcePostBinding()) {
            return;
        }
        URI requestedBinding = ((AuthnRequestType)context.getRequest()).getProtocolBinding();
        if (requestedBinding == null ? context.getProtocolBinding().equals("get") : JBossSAMLURIConstants.SAML_HTTP_REDIRECT_BINDING.get().equals(requestedBinding.toString()) || JBossSAMLURIConstants.SAML_HTTP_ARTIFACT_BINDING.get().equals(requestedBinding.toString()) && context.getProtocolBinding().equals("get")) {
            throw new ClientPolicyException("invalid_request", "REDIRECT binding is used for the login request and it is not allowed.");
        }
    }

    private void confirmRedirectBindingIsNotUsed(SamlLogoutRequestContext context) throws ClientPolicyException {
        SamlClient samlClient = new SamlClient(context.getClient());
        if (samlClient.forcePostBinding()) {
            return;
        }
        if (context.getProtocolBinding().equals("get")) {
            throw new ClientPolicyException("invalid_request", "REDIRECT binding is used for the logout request and it is not allowed.");
        }
    }
}

