/*
 * Decompiled with CFR 0.152.
 */
package io.github.dmlloyd.classfile;

import io.github.dmlloyd.classfile.Annotation;
import io.github.dmlloyd.classfile.AnnotationValue;
import io.github.dmlloyd.classfile.constantpool.Utf8Entry;
import io.github.dmlloyd.classfile.impl.AnnotationImpl;
import io.github.dmlloyd.classfile.impl.TemporaryConstantPool;
import java.lang.constant.ClassDesc;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface AnnotationElement {
    public Utf8Entry name();

    public AnnotationValue value();

    public static AnnotationElement of(Utf8Entry name, AnnotationValue value) {
        return new AnnotationImpl.AnnotationElementImpl(name, value);
    }

    public static AnnotationElement of(String name, AnnotationValue value) {
        return AnnotationElement.of(TemporaryConstantPool.INSTANCE.utf8Entry(name), value);
    }

    public static AnnotationElement ofClass(String name, ClassDesc value) {
        return AnnotationElement.of(name, (AnnotationValue)AnnotationValue.ofClass(value));
    }

    public static AnnotationElement ofString(String name, String value) {
        return AnnotationElement.of(name, (AnnotationValue)AnnotationValue.ofString(value));
    }

    public static AnnotationElement ofLong(String name, long value) {
        return AnnotationElement.of(name, (AnnotationValue)AnnotationValue.ofLong(value));
    }

    public static AnnotationElement ofInt(String name, int value) {
        return AnnotationElement.of(name, (AnnotationValue)AnnotationValue.ofInt(value));
    }

    public static AnnotationElement ofChar(String name, char value) {
        return AnnotationElement.of(name, (AnnotationValue)AnnotationValue.ofChar(value));
    }

    public static AnnotationElement ofShort(String name, short value) {
        return AnnotationElement.of(name, (AnnotationValue)AnnotationValue.ofShort(value));
    }

    public static AnnotationElement ofByte(String name, byte value) {
        return AnnotationElement.of(name, (AnnotationValue)AnnotationValue.ofByte(value));
    }

    public static AnnotationElement ofBoolean(String name, boolean value) {
        return AnnotationElement.of(name, (AnnotationValue)AnnotationValue.ofBoolean(value));
    }

    public static AnnotationElement ofDouble(String name, double value) {
        return AnnotationElement.of(name, (AnnotationValue)AnnotationValue.ofDouble(value));
    }

    public static AnnotationElement ofFloat(String name, float value) {
        return AnnotationElement.of(name, (AnnotationValue)AnnotationValue.ofFloat(value));
    }

    public static AnnotationElement ofAnnotation(String name, Annotation value) {
        return AnnotationElement.of(name, (AnnotationValue)AnnotationValue.ofAnnotation(value));
    }

    public static AnnotationElement ofArray(String name, AnnotationValue ... values) {
        return AnnotationElement.of(name, (AnnotationValue)AnnotationValue.ofArray(values));
    }
}

