/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.workflow;

import java.util.List;
import org.keycloak.Config;
import org.keycloak.component.ComponentModel;
import org.keycloak.component.ComponentValidationException;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.workflow.ResourceType;
import org.keycloak.models.workflow.RestartWorkflowStepProvider;
import org.keycloak.models.workflow.WorkflowStepProviderFactory;
import org.keycloak.provider.ProviderConfigProperty;

public final class RestartWorkflowStepProviderFactory
implements WorkflowStepProviderFactory<RestartWorkflowStepProvider> {
    public static final String ID = "restart";
    public static final String CONFIG_POSITION = "position";

    public RestartWorkflowStepProvider create(KeycloakSession session, ComponentModel model) {
        return new RestartWorkflowStepProvider(this.getPosition(model));
    }

    public void validateConfiguration(KeycloakSession session, RealmModel realm, ComponentModel model) throws ComponentValidationException {
        if (this.getPosition(model) < 0) {
            throw new ComponentValidationException("Position must be a non-negative integer", new Object[0]);
        }
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return ID;
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return List.of();
    }

    public ResourceType getType() {
        return ResourceType.USERS;
    }

    public String getHelpText() {
        return "Restarts the current workflow";
    }

    private int getPosition(ComponentModel model) {
        return model.get(CONFIG_POSITION, 0);
    }
}

