/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.inboundhandler;

import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.inboundhandler.PerCacheInboundInvocationHandler;
import org.infinispan.remoting.inboundhandler.Reply;

public abstract class AbstractDelegatingHandler
implements PerCacheInboundInvocationHandler {
    protected final PerCacheInboundInvocationHandler delegate;

    protected AbstractDelegatingHandler(PerCacheInboundInvocationHandler delegate) {
        this.delegate = delegate;
    }

    @Override
    public void handle(CacheRpcCommand command, Reply reply, DeliverOrder order) {
        boolean canDelegate = this.beforeHandle(command, reply, order);
        if (canDelegate) {
            this.delegate.handle(command, reply, order);
        }
        this.afterHandle(command, order, canDelegate);
    }

    @Override
    public void setFirstTopologyAsMember(int firstTopologyAsMember) {
        this.delegate.setFirstTopologyAsMember(firstTopologyAsMember);
    }

    @Override
    public int getFirstTopologyAsMember() {
        return this.delegate.getFirstTopologyAsMember();
    }

    protected boolean beforeHandle(CacheRpcCommand command, Reply reply, DeliverOrder order) {
        return true;
    }

    protected void afterHandle(CacheRpcCommand command, DeliverOrder order, boolean delegated) {
    }

    @Override
    public void checkForReadyTasks() {
        this.delegate.checkForReadyTasks();
    }
}

