/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.semconv.http;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.internal.HttpConstants;
import io.opentelemetry.instrumentation.api.semconv.http.HostAddressAndPortExtractor;
import io.opentelemetry.instrumentation.api.semconv.http.HttpClientAttributesExtractor;
import io.opentelemetry.instrumentation.api.semconv.http.HttpClientAttributesGetter;
import io.opentelemetry.instrumentation.api.semconv.http.HttpClientRequestResendCount;
import io.opentelemetry.instrumentation.api.semconv.network.internal.AddressAndPortExtractor;
import io.opentelemetry.instrumentation.api.semconv.network.internal.InternalNetworkAttributesExtractor;
import io.opentelemetry.instrumentation.api.semconv.network.internal.InternalServerAttributesExtractor;
import io.opentelemetry.instrumentation.api.semconv.network.internal.ServerAddressAndPortExtractor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.ToIntFunction;

public final class HttpClientAttributesExtractorBuilder<REQUEST, RESPONSE> {
    final HttpClientAttributesGetter<REQUEST, RESPONSE> httpAttributesGetter;
    final AddressAndPortExtractor<REQUEST> serverAddressAndPortExtractor;
    List<String> capturedRequestHeaders = Collections.emptyList();
    List<String> capturedResponseHeaders = Collections.emptyList();
    Set<String> knownMethods = HttpConstants.KNOWN_METHODS;
    ToIntFunction<Context> resendCountIncrementer = HttpClientRequestResendCount::getAndIncrement;

    HttpClientAttributesExtractorBuilder(HttpClientAttributesGetter<REQUEST, RESPONSE> httpAttributesGetter) {
        this.httpAttributesGetter = httpAttributesGetter;
        this.serverAddressAndPortExtractor = new ServerAddressAndPortExtractor<REQUEST>(httpAttributesGetter, new HostAddressAndPortExtractor<REQUEST>(httpAttributesGetter));
    }

    @CanIgnoreReturnValue
    public HttpClientAttributesExtractorBuilder<REQUEST, RESPONSE> setCapturedRequestHeaders(List<String> requestHeaders) {
        this.capturedRequestHeaders = new ArrayList<String>(requestHeaders);
        return this;
    }

    @CanIgnoreReturnValue
    public HttpClientAttributesExtractorBuilder<REQUEST, RESPONSE> setCapturedResponseHeaders(List<String> responseHeaders) {
        this.capturedResponseHeaders = new ArrayList<String>(responseHeaders);
        return this;
    }

    @CanIgnoreReturnValue
    public HttpClientAttributesExtractorBuilder<REQUEST, RESPONSE> setKnownMethods(Set<String> knownMethods) {
        this.knownMethods = new HashSet<String>(knownMethods);
        return this;
    }

    @CanIgnoreReturnValue
    HttpClientAttributesExtractorBuilder<REQUEST, RESPONSE> setResendCountIncrementer(ToIntFunction<Context> resendCountIncrementer) {
        this.resendCountIncrementer = resendCountIncrementer;
        return this;
    }

    public AttributesExtractor<REQUEST, RESPONSE> build() {
        return new HttpClientAttributesExtractor(this);
    }

    InternalNetworkAttributesExtractor<REQUEST, RESPONSE> buildNetworkExtractor() {
        return new InternalNetworkAttributesExtractor<REQUEST, RESPONSE>(this.httpAttributesGetter, false, false);
    }

    InternalServerAttributesExtractor<REQUEST> buildServerExtractor() {
        return new InternalServerAttributesExtractor<REQUEST>(this.serverAddressAndPortExtractor);
    }
}

