/*++

Copyright (C) 2024 3MF Consortium (Original Author)

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This file has been generated by the Automatic Component Toolkit (ACT) version 1.8.1-develop.

Abstract: This is an autogenerated Java file in order to allow an easy
 use of the 3MF Library

Interface version: 2.5.0

*/

package lib3mf;

import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;


import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;

public class FunctionFromImage3D extends Function {

	public FunctionFromImage3D(Lib3MFWrapper wrapper, Pointer handle) {
		super(wrapper, handle);
	}

	/**
	 * Returns the selected 3D image.
	 *
	 * @return image instance
	 * @throws Lib3MFException
	 */
	public Image3D getImage3D() throws Lib3MFException {
		Pointer bufferImage3D = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_functionfromimage3d_getimage3d.invokeInt(new java.lang.Object[]{mHandle, bufferImage3D}));
		Pointer valueImage3D = bufferImage3D.getPointer(0);
		Image3D image3D = null;
		if (valueImage3D == Pointer.NULL) {
		  throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Image3D was a null pointer");
		}
		image3D = mWrapper.PolymorphicFactory(valueImage3D, Image3D.class);
		return image3D;
	}

	/**
	 * Sets the 3D image of the selector.
	 *
	 * @param image3D image instance
	 * @throws Lib3MFException
	 */
	public void setImage3D(Image3D image3D) throws Lib3MFException {
		Pointer image3DHandle = null;
		if (image3D != null) {
			image3DHandle = image3D.getHandle();
		} else {
			throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Image3D is a null value.");
		}
		mWrapper.checkError(this, mWrapper.lib3mf_functionfromimage3d_setimage3d.invokeInt(new java.lang.Object[]{mHandle, image3DHandle}));
	}

	/**
	 * Sets the texture filter of the selector.
	 *
	 * @param filter texture filter
	 * @throws Lib3MFException
	 */
	public void setFilter(Lib3MFWrapper.TextureFilter filter) throws Lib3MFException {
		mWrapper.checkError(this, mWrapper.lib3mf_functionfromimage3d_setfilter.invokeInt(new java.lang.Object[]{mHandle, Lib3MFWrapper.EnumConversion.convertTextureFilterToConst(filter)}));
	}

	/**
	 * Returns the texture filter of the selector.
	 *
	 * @return texture filter
	 * @throws Lib3MFException
	 */
	public Lib3MFWrapper.TextureFilter getFilter() throws Lib3MFException {
		Pointer bufferFilter = new Memory(4);
		mWrapper.checkError(this, mWrapper.lib3mf_functionfromimage3d_getfilter.invokeInt(new java.lang.Object[]{mHandle, bufferFilter}));
		return Lib3MFWrapper.EnumConversion.convertConstToTextureFilter(bufferFilter.getInt(0));
	}

	/**
	 * Sets the tile styles of the selector.
	 *
	 * @param tileStyleU tile style in U
	 * @param tileStyleV tile style in V
	 * @param tileStyleW tile style in W
	 * @throws Lib3MFException
	 */
	public void setTileStyles(Lib3MFWrapper.TextureTileStyle tileStyleU, Lib3MFWrapper.TextureTileStyle tileStyleV, Lib3MFWrapper.TextureTileStyle tileStyleW) throws Lib3MFException {
		mWrapper.checkError(this, mWrapper.lib3mf_functionfromimage3d_settilestyles.invokeInt(new java.lang.Object[]{mHandle, Lib3MFWrapper.EnumConversion.convertTextureTileStyleToConst(tileStyleU), Lib3MFWrapper.EnumConversion.convertTextureTileStyleToConst(tileStyleV), Lib3MFWrapper.EnumConversion.convertTextureTileStyleToConst(tileStyleW)}));
	}

	/**
	 * Retrieves the tile styles of the selector.
	 *
	 * @return GetTileStyles Result Tuple
	 * @throws Lib3MFException
	 */
	public GetTileStylesResult getTileStyles() throws Lib3MFException {
		Pointer bufferTileStyleU = new Memory(4);
		Pointer bufferTileStyleV = new Memory(4);
		Pointer bufferTileStyleW = new Memory(4);
		mWrapper.checkError(this, mWrapper.lib3mf_functionfromimage3d_gettilestyles.invokeInt(new java.lang.Object[]{mHandle, bufferTileStyleU, bufferTileStyleV, bufferTileStyleW}));
		GetTileStylesResult returnTuple = new GetTileStylesResult();
		returnTuple.TileStyleU = Lib3MFWrapper.EnumConversion.convertConstToTextureTileStyle(bufferTileStyleU.getInt(0));
		returnTuple.TileStyleV = Lib3MFWrapper.EnumConversion.convertConstToTextureTileStyle(bufferTileStyleV.getInt(0));
		returnTuple.TileStyleW = Lib3MFWrapper.EnumConversion.convertConstToTextureTileStyle(bufferTileStyleW.getInt(0));
		return returnTuple;
	}

	public static class GetTileStylesResult {
		/**
		 * tile style in U
		 */
		public Lib3MFWrapper.TextureTileStyle TileStyleU;

		/**
		 * tile style in V
		 */
		public Lib3MFWrapper.TextureTileStyle TileStyleV;

		/**
		 * tile style in W
		 */
		public Lib3MFWrapper.TextureTileStyle TileStyleW;

	}
	/**
	 * returns the offset value for the pixel values in the Image3D
	 *
	 * @return the offset value for the pixel values in the Image3D
	 * @throws Lib3MFException
	 */
	public double getOffset() throws Lib3MFException {
		Pointer bufferOffset = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_functionfromimage3d_getoffset.invokeInt(new java.lang.Object[]{mHandle, bufferOffset}));
		return bufferOffset.getDouble(0);
	}

	/**
	 * Sets the offset value for the pixel values in the Image3D
	 *
	 * @param offset the offset value for the pixel values in the Image3D
	 * @throws Lib3MFException
	 */
	public void setOffset(double offset) throws Lib3MFException {
		mWrapper.checkError(this, mWrapper.lib3mf_functionfromimage3d_setoffset.invokeInt(new java.lang.Object[]{mHandle, offset}));
	}

	/**
	 * returns the scale value for the pixel values in the Image3D
	 *
	 * @return the scale value for the pixel values in the Image3D
	 * @throws Lib3MFException
	 */
	public double getScale() throws Lib3MFException {
		Pointer bufferScale = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_functionfromimage3d_getscale.invokeInt(new java.lang.Object[]{mHandle, bufferScale}));
		return bufferScale.getDouble(0);
	}

	/**
	 * Sets the scale value for the pixel values in the Image3D
	 *
	 * @param scale the scale value for the pixel values in the Image3D
	 * @throws Lib3MFException
	 */
	public void setScale(double scale) throws Lib3MFException {
		mWrapper.checkError(this, mWrapper.lib3mf_functionfromimage3d_setscale.invokeInt(new java.lang.Object[]{mHandle, scale}));
	}


}

