/*++

Copyright (C) 2024 3MF Consortium (Original Author)

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This file has been generated by the Automatic Component Toolkit (ACT) version 1.8.1-develop.

Abstract: This is an autogenerated Java file in order to allow an easy
 use of the 3MF Library

Interface version: 2.5.0

*/

package lib3mf;

import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;


import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;

public class Iterator extends Base {

	public Iterator(Lib3MFWrapper wrapper, Pointer handle) {
		super(wrapper, handle);
	}

	/**
	 * Iterates to the next item in the list.
	 *
	 * @return Iterates to the next item in the list.
	 * @throws Lib3MFException
	 */
	public boolean moveNext() throws Lib3MFException {
		Pointer bufferHasNext = new Memory(1);
		mWrapper.checkError(this, mWrapper.lib3mf_iterator_movenext.invokeInt(new java.lang.Object[]{mHandle, bufferHasNext}));
		return bufferHasNext.getByte(0) != 0;
	}

	/**
	 * Iterates to the previous item in the list.
	 *
	 * @return Iterates to the previous item in the list.
	 * @throws Lib3MFException
	 */
	public boolean movePrevious() throws Lib3MFException {
		Pointer bufferHasPrevious = new Memory(1);
		mWrapper.checkError(this, mWrapper.lib3mf_iterator_moveprevious.invokeInt(new java.lang.Object[]{mHandle, bufferHasPrevious}));
		return bufferHasPrevious.getByte(0) != 0;
	}

	/**
	 * Returns the number of items the iterator captures.
	 *
	 * @return returns the number of items the iterator captures.
	 * @throws Lib3MFException
	 */
	public long count() throws Lib3MFException {
		Pointer bufferCount = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_iterator_count.invokeInt(new java.lang.Object[]{mHandle, bufferCount}));
		return bufferCount.getLong(0);
	}


}

