/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.ShardStatistics;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class CountResponse
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, CountResponse> {
    private final long count;
    @Nonnull
    private final ShardStatistics shards;
    @Nullable
    private final Boolean terminatedEarly;
    public static final JsonpDeserializer<CountResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CountResponse::setupCountResponseDeserializer);

    private CountResponse(Builder builder) {
        this.count = ApiTypeHelper.requireNonNull(builder.count, this, "count");
        this.shards = ApiTypeHelper.requireNonNull(builder.shards, this, "shards");
        this.terminatedEarly = builder.terminatedEarly;
    }

    public static CountResponse of(Function<Builder, ObjectBuilder<CountResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long count() {
        return this.count;
    }

    @Nonnull
    public final ShardStatistics shards() {
        return this.shards;
    }

    @Nullable
    public final Boolean terminatedEarly() {
        return this.terminatedEarly;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("count");
        generator.write(this.count);
        generator.writeKey("_shards");
        this.shards.serialize(generator, mapper);
        if (this.terminatedEarly != null) {
            generator.writeKey("terminated_early");
            generator.write(this.terminatedEarly.booleanValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupCountResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::count, JsonpDeserializer.longDeserializer(), "count");
        op.add(Builder::shards, ShardStatistics._DESERIALIZER, "_shards");
        op.add(Builder::terminatedEarly, JsonpDeserializer.booleanDeserializer(), "terminated_early");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Long.hashCode(this.count);
        result = 31 * result + this.shards.hashCode();
        result = 31 * result + Objects.hashCode(this.terminatedEarly);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CountResponse other = (CountResponse)o;
        return this.count == other.count && this.shards.equals(other.shards) && Objects.equals(this.terminatedEarly, other.terminatedEarly);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, CountResponse> {
        private Long count;
        private ShardStatistics shards;
        @Nullable
        private Boolean terminatedEarly;

        public Builder() {
        }

        private Builder(CountResponse o) {
            this.count = o.count;
            this.shards = o.shards;
            this.terminatedEarly = o.terminatedEarly;
        }

        private Builder(Builder o) {
            this.count = o.count;
            this.shards = o.shards;
            this.terminatedEarly = o.terminatedEarly;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder count(long value) {
            this.count = value;
            return this;
        }

        @Nonnull
        public final Builder shards(ShardStatistics value) {
            this.shards = value;
            return this;
        }

        @Nonnull
        public final Builder shards(Function<ShardStatistics.Builder, ObjectBuilder<ShardStatistics>> fn) {
            return this.shards(fn.apply(new ShardStatistics.Builder()).build());
        }

        @Nonnull
        public final Builder terminatedEarly(@Nullable Boolean value) {
            this.terminatedEarly = value;
            return this;
        }

        @Override
        @Nonnull
        public CountResponse build() {
            this._checkSingleUse();
            return new CountResponse(this);
        }
    }
}

