/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.commons.alerting.model;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.commons.alerting.util.IndexUtilsKt;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 .2\u00020\u00012\u00020\u0002:\u0001.B5\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000b\u0010\fB\u0011\b\u0016\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000b\u0010\u000fJ\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020 H\u0016J\t\u0010!\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0004H\u00c6\u0003J\u000f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007H\u00c6\u0003J\t\u0010$\u001a\u00020\tH\u00c6\u0003J\t\u0010%\u001a\u00020\u0004H\u00c6\u0003JA\u0010&\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00042\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010*H\u00d6\u0003J\t\u0010+\u001a\u00020,H\u00d6\u0001J\t\u0010-\u001a\u00020\u0004H\u00d6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\n\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0011\u00a8\u0006/"}, d2={"Lorg/opensearch/commons/alerting/model/WorkflowMetadata;", "Lorg/opensearch/core/common/io/stream/Writeable;", "Lorg/opensearch/core/xcontent/ToXContent;", "id", "", "workflowId", "monitorIds", "", "latestRunTime", "Ljava/time/Instant;", "latestExecutionId", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/time/Instant;Ljava/lang/String;)V", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "getId", "()Ljava/lang/String;", "getWorkflowId", "getMonitorIds", "()Ljava/util/List;", "getLatestRunTime", "()Ljava/time/Instant;", "getLatestExecutionId", "writeTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "hashCode", "", "toString", "Companion", "common-utils"})
public final class WorkflowMetadata
implements Writeable,
ToXContent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    @NotNull
    private final String workflowId;
    @NotNull
    private final List<String> monitorIds;
    @NotNull
    private final Instant latestRunTime;
    @NotNull
    private final String latestExecutionId;
    @NotNull
    public static final String METADATA = "workflow_metadata";
    @NotNull
    public static final String WORKFLOW_ID_FIELD = "workflow_id";
    @NotNull
    public static final String MONITOR_IDS_FIELD = "monitor_ids";
    @NotNull
    public static final String LATEST_RUN_TIME = "latest_run_time";
    @NotNull
    public static final String LATEST_EXECUTION_ID = "latest_execution_id";

    public WorkflowMetadata(@NotNull String id, @NotNull String workflowId, @NotNull List<String> monitorIds, @NotNull Instant latestRunTime, @NotNull String latestExecutionId) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)workflowId, (String)"workflowId");
        Intrinsics.checkNotNullParameter(monitorIds, (String)"monitorIds");
        Intrinsics.checkNotNullParameter((Object)latestRunTime, (String)"latestRunTime");
        Intrinsics.checkNotNullParameter((Object)latestExecutionId, (String)"latestExecutionId");
        this.id = id;
        this.workflowId = workflowId;
        this.monitorIds = monitorIds;
        this.latestRunTime = latestRunTime;
        this.latestExecutionId = latestExecutionId;
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public final String getWorkflowId() {
        return this.workflowId;
    }

    @NotNull
    public final List<String> getMonitorIds() {
        return this.monitorIds;
    }

    @NotNull
    public final Instant getLatestRunTime() {
        return this.latestRunTime;
    }

    @NotNull
    public final String getLatestExecutionId() {
        return this.latestExecutionId;
    }

    public WorkflowMetadata(@NotNull StreamInput sin) throws IOException {
        Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
        String string = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readString(...)");
        String string2 = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"readString(...)");
        List list = sin.readStringList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"readStringList(...)");
        Instant instant = sin.readInstant();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"readInstant(...)");
        String string3 = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"readString(...)");
        this(string, string2, list, instant, string3);
    }

    public void writeTo(@NotNull StreamOutput out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeString(this.id);
        out.writeString(this.workflowId);
        out.writeStringCollection((Collection)this.monitorIds);
        out.writeInstant(this.latestRunTime);
        out.writeString(this.latestExecutionId);
    }

    @NotNull
    public XContentBuilder toXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        builder.startObject();
        if (params.paramAsBoolean("with_type", false)) {
            builder.startObject(METADATA);
        }
        XContentBuilder xContentBuilder = builder.field(WORKFLOW_ID_FIELD, this.workflowId).field(MONITOR_IDS_FIELD, (Iterable)this.monitorIds);
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"field(...)");
        IndexUtilsKt.optionalTimeField(xContentBuilder, LATEST_RUN_TIME, this.latestRunTime).field(LATEST_EXECUTION_ID, this.latestExecutionId);
        if (params.paramAsBoolean("with_type", false)) {
            builder.endObject();
        }
        XContentBuilder xContentBuilder2 = builder.endObject();
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder2, (String)"endObject(...)");
        return xContentBuilder2;
    }

    @NotNull
    public final String component1() {
        return this.id;
    }

    @NotNull
    public final String component2() {
        return this.workflowId;
    }

    @NotNull
    public final List<String> component3() {
        return this.monitorIds;
    }

    @NotNull
    public final Instant component4() {
        return this.latestRunTime;
    }

    @NotNull
    public final String component5() {
        return this.latestExecutionId;
    }

    @NotNull
    public final WorkflowMetadata copy(@NotNull String id, @NotNull String workflowId, @NotNull List<String> monitorIds, @NotNull Instant latestRunTime, @NotNull String latestExecutionId) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)workflowId, (String)"workflowId");
        Intrinsics.checkNotNullParameter(monitorIds, (String)"monitorIds");
        Intrinsics.checkNotNullParameter((Object)latestRunTime, (String)"latestRunTime");
        Intrinsics.checkNotNullParameter((Object)latestExecutionId, (String)"latestExecutionId");
        return new WorkflowMetadata(id, workflowId, monitorIds, latestRunTime, latestExecutionId);
    }

    public static /* synthetic */ WorkflowMetadata copy$default(WorkflowMetadata workflowMetadata, String string, String string2, List list, Instant instant, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string = workflowMetadata.id;
        }
        if ((n & 2) != 0) {
            string2 = workflowMetadata.workflowId;
        }
        if ((n & 4) != 0) {
            list = workflowMetadata.monitorIds;
        }
        if ((n & 8) != 0) {
            instant = workflowMetadata.latestRunTime;
        }
        if ((n & 0x10) != 0) {
            string3 = workflowMetadata.latestExecutionId;
        }
        return workflowMetadata.copy(string, string2, list, instant, string3);
    }

    @NotNull
    public String toString() {
        return "WorkflowMetadata(id=" + this.id + ", workflowId=" + this.workflowId + ", monitorIds=" + this.monitorIds + ", latestRunTime=" + this.latestRunTime + ", latestExecutionId=" + this.latestExecutionId + ")";
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = result * 31 + this.workflowId.hashCode();
        result = result * 31 + ((Object)this.monitorIds).hashCode();
        result = result * 31 + this.latestRunTime.hashCode();
        result = result * 31 + this.latestExecutionId.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof WorkflowMetadata)) {
            return false;
        }
        WorkflowMetadata workflowMetadata = (WorkflowMetadata)other;
        if (!Intrinsics.areEqual((Object)this.id, (Object)workflowMetadata.id)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.workflowId, (Object)workflowMetadata.workflowId)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.monitorIds, workflowMetadata.monitorIds)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.latestRunTime, (Object)workflowMetadata.latestRunTime)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.latestExecutionId, (Object)workflowMetadata.latestExecutionId);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final WorkflowMetadata parse(@NotNull XContentParser xcp) throws IOException {
        return Companion.parse(xcp);
    }

    @JvmStatic
    @NotNull
    public static final WorkflowMetadata readFrom(@NotNull StreamInput sin) throws IOException {
        return Companion.readFrom(sin);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0012\u0010\u0011\u001a\u00020\u00052\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/opensearch/commons/alerting/model/WorkflowMetadata$Companion;", "", "<init>", "()V", "METADATA", "", "WORKFLOW_ID_FIELD", "MONITOR_IDS_FIELD", "LATEST_RUN_TIME", "LATEST_EXECUTION_ID", "parse", "Lorg/opensearch/commons/alerting/model/WorkflowMetadata;", "xcp", "Lorg/opensearch/core/xcontent/XContentParser;", "readFrom", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "getId", "workflowId", "common-utils"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final WorkflowMetadata parse(@NotNull XContentParser xcp) throws IOException {
            String string;
            Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
            String workflowId = null;
            List monitorIds = new ArrayList();
            Instant latestRunTime = null;
            String latestExecutionId = null;
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
            while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                String fieldName = xcp.currentName();
                xcp.nextToken();
                String string2 = fieldName;
                if (string2 == null) continue;
                int n = -1;
                switch (string2.hashCode()) {
                    case 1712917915: {
                        if (string2.equals(WorkflowMetadata.WORKFLOW_ID_FIELD)) {
                            n = 1;
                        }
                        break;
                    }
                    case 1679645113: {
                        if (string2.equals(WorkflowMetadata.LATEST_RUN_TIME)) {
                            n = 2;
                        }
                        break;
                    }
                    case -1160774310: {
                        if (string2.equals(WorkflowMetadata.LATEST_EXECUTION_ID)) {
                            n = 3;
                        }
                        break;
                    }
                    case 1579894355: {
                        if (string2.equals(WorkflowMetadata.MONITOR_IDS_FIELD)) {
                            n = 4;
                        }
                        break;
                    }
                }
                switch (n) {
                    case 1: {
                        Intrinsics.checkNotNullExpressionValue((Object)xcp.text(), (String)"text(...)");
                        break;
                    }
                    case 4: {
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                        while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                            String string3 = xcp.text();
                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"text(...)");
                            monitorIds.add(string3);
                        }
                        break;
                    }
                    case 2: {
                        Intrinsics.checkNotNull((Object)IndexUtilsKt.instant(xcp));
                        break;
                    }
                    case 3: {
                        Intrinsics.checkNotNullExpressionValue((Object)xcp.text(), (String)"text(...)");
                    }
                }
            }
            String string4 = workflowId;
            if (string4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"workflowId");
                string4 = null;
            }
            String string5 = string4 + "-metadata";
            Instant instant = latestRunTime;
            if (instant == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"latestRunTime");
                instant = null;
            }
            if ((string = latestExecutionId) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"latestExecutionId");
                string = null;
            }
            return new WorkflowMetadata(string5, workflowId, monitorIds, instant, string);
        }

        @JvmStatic
        @NotNull
        public final WorkflowMetadata readFrom(@NotNull StreamInput sin) throws IOException {
            Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
            return new WorkflowMetadata(sin);
        }

        @NotNull
        public final String getId(@Nullable String workflowId) {
            return workflowId + "-metadata";
        }

        public static /* synthetic */ String getId$default(Companion companion, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = null;
            }
            return companion.getId(string);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

