/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling.internal;

import com.amazonaws.util.StringUtils;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;

public final class Hkdf {
    private static final byte[] EMPTY_ARRAY = new byte[0];
    private final String algorithm;
    private final Provider provider;
    private SecretKey prk = null;

    public static Hkdf getInstance(String algorithm) throws NoSuchAlgorithmException {
        Mac mac = Mac.getInstance(algorithm);
        return new Hkdf(algorithm, mac.getProvider());
    }

    public static Hkdf getInstance(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        Mac mac = Mac.getInstance(algorithm, provider);
        return new Hkdf(algorithm, mac.getProvider());
    }

    public static Hkdf getInstance(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        Mac mac = Mac.getInstance(algorithm, provider);
        return new Hkdf(algorithm, mac.getProvider());
    }

    public void init(byte[] ikm) {
        this.init(ikm, null);
    }

    public void init(byte[] ikm, byte[] salt) {
        byte[] realSalt = salt == null ? EMPTY_ARRAY : (byte[])salt.clone();
        byte[] rawKeyMaterial = EMPTY_ARRAY;
        try {
            Mac extractionMac = Mac.getInstance(this.algorithm, this.provider);
            if (realSalt.length == 0) {
                realSalt = new byte[extractionMac.getMacLength()];
                Arrays.fill(realSalt, (byte)0);
            }
            extractionMac.init(new SecretKeySpec(realSalt, this.algorithm));
            rawKeyMaterial = extractionMac.doFinal(ikm);
            SecretKeySpec key = new SecretKeySpec(rawKeyMaterial, this.algorithm);
            Arrays.fill(rawKeyMaterial, (byte)0);
            this.unsafeInitWithoutKeyExtraction(key);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
        finally {
            Arrays.fill(rawKeyMaterial, (byte)0);
        }
    }

    public void unsafeInitWithoutKeyExtraction(SecretKey rawKey) throws InvalidKeyException {
        if (!rawKey.getAlgorithm().equals(this.algorithm)) {
            throw new InvalidKeyException("Algorithm for the provided key must match the algorithm for this Hkdf. Expected " + this.algorithm + " but found " + rawKey.getAlgorithm());
        }
        this.prk = rawKey;
    }

    private Hkdf(String algorithm, Provider provider) {
        if (!algorithm.startsWith("Hmac")) {
            throw new IllegalArgumentException("Invalid algorithm " + algorithm + ". Hkdf may only be used with Hmac algorithms.");
        }
        this.algorithm = algorithm;
        this.provider = provider;
    }

    public byte[] deriveKey(String info, int length) throws IllegalStateException {
        return this.deriveKey(info != null ? info.getBytes(StringUtils.UTF8) : null, length);
    }

    public byte[] deriveKey(byte[] info, int length) throws IllegalStateException {
        byte[] result = new byte[length];
        try {
            this.deriveKey(info, length, result, 0);
        }
        catch (ShortBufferException ex) {
            throw new RuntimeException(ex);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deriveKey(byte[] info, int length, byte[] output, int offset) throws ShortBufferException, IllegalStateException {
        this.assertInitialized();
        if (length < 0) {
            throw new IllegalArgumentException("Length must be a non-negative value.");
        }
        if (output.length < offset + length) {
            throw new ShortBufferException();
        }
        Mac mac = this.createMac();
        if (length > 255 * mac.getMacLength()) {
            throw new IllegalArgumentException("Requested keys may not be longer than 255 times the underlying HMAC length.");
        }
        byte[] t = EMPTY_ARRAY;
        try {
            int loc = 0;
            byte i = 1;
            while (loc < length) {
                mac.update(t);
                mac.update(info);
                mac.update(i);
                t = mac.doFinal();
                for (int x = 0; x < t.length && loc < length; ++x, ++loc) {
                    output[loc] = t[x];
                }
                i = (byte)(i + 1);
            }
        }
        finally {
            Arrays.fill(t, (byte)0);
        }
    }

    private Mac createMac() {
        try {
            Mac mac = Mac.getInstance(this.algorithm, this.provider);
            mac.init(this.prk);
            return mac;
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
        catch (InvalidKeyException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void assertInitialized() throws IllegalStateException {
        if (this.prk == null) {
            throw new IllegalStateException("Hkdf has not been initialized");
        }
    }
}

