/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.png.quantx;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public final class OKLabPaletteMapper {
    public static BufferedImage quantize(BufferedImage src, Map<Integer, Integer> palette, boolean floydSteinberg) {
        int w = src.getWidth();
        int h = src.getHeight();
        int paletteSize = Math.min(256, palette.size());
        byte[] r = new byte[256];
        byte[] g = new byte[256];
        byte[] b = new byte[256];
        byte[] a = new byte[256];
        int[] paletteInts = new int[Math.max(1, paletteSize)];
        int idx = 0;
        for (Integer c : palette.keySet()) {
            if (idx == paletteSize) break;
            int argb = c;
            a[idx] = (byte)(argb >>> 24 & 0xFF);
            r[idx] = (byte)(argb >>> 16 & 0xFF);
            g[idx] = (byte)(argb >>> 8 & 0xFF);
            b[idx] = (byte)(argb & 0xFF);
            paletteInts[idx] = argb;
            ++idx;
        }
        int fillFrom = Math.max(0, paletteSize);
        int fillArgb = paletteSize == 0 ? -16777216 : paletteInts[paletteSize - 1];
        byte fillA = (byte)(fillArgb >>> 24 & 0xFF);
        byte fillR = (byte)(fillArgb >>> 16 & 0xFF);
        byte fillG = (byte)(fillArgb >>> 8 & 0xFF);
        byte fillB = (byte)(fillArgb & 0xFF);
        for (int i = fillFrom; i < 256; ++i) {
            a[i] = fillA;
            r[i] = fillR;
            g[i] = fillG;
            b[i] = fillB;
        }
        IndexColorModel icm = new IndexColorModel(8, 256, r, g, b, a);
        BufferedImage dst = new BufferedImage(w, h, 13, icm);
        byte[] out = ((DataBufferByte)dst.getRaster().getDataBuffer()).getData();
        if (paletteSize == 0) {
            Arrays.fill(out, (byte)0);
            return dst;
        }
        float[] pL = new float[paletteSize];
        float[] pA = new float[paletteSize];
        float[] pB = new float[paletteSize];
        int transparentIndex = -1;
        for (int i = 0; i < paletteSize; ++i) {
            int argb = paletteInts[i];
            int pa = argb >>> 24 & 0xFF;
            int pr = argb >>> 16 & 0xFF;
            int pg = argb >>> 8 & 0xFF;
            int pb_ = argb & 0xFF;
            float[] lab = OKLabPaletteMapper.srgbToOKLab(pr, pg, pb_);
            pL[i] = lab[0];
            pA[i] = lab[1];
            pB[i] = lab[2];
            if (pa != 0 || transparentIndex >= 0) continue;
            transparentIndex = i;
        }
        int[] srcPixels = src.getRGB(0, 0, w, h, null, 0, w);
        float alphaWeight = 0.015f;
        if (!floydSteinberg) {
            HashMap<Integer, Byte> cache = new HashMap<Integer, Byte>(4096);
            for (int y = 0; y < h; ++y) {
                int rowOff = y * w;
                for (int x = 0; x < w; ++x) {
                    int pos = rowOff + x;
                    int argb = srcPixels[pos];
                    Byte cached = (Byte)cache.get(argb);
                    if (cached != null) {
                        out[pos] = cached;
                        continue;
                    }
                    int A0 = argb >>> 24 & 0xFF;
                    int R0 = argb >>> 16 & 0xFF;
                    int G0 = argb >>> 8 & 0xFF;
                    int B0 = argb & 0xFF;
                    if (transparentIndex >= 0 && A0 < 8) {
                        byte bi = (byte)transparentIndex;
                        cache.put(argb, bi);
                        out[pos] = bi;
                        continue;
                    }
                    float[] lab0 = OKLabPaletteMapper.srgbToOKLab(R0, G0, B0);
                    byte best = OKLabPaletteMapper.findNearestOKLabIndex(lab0[0], lab0[1], lab0[2], A0, pL, pA, pB, paletteInts, 0.015f);
                    cache.put(argb, best);
                    out[pos] = best;
                }
            }
            return dst;
        }
        boolean serpentine = true;
        float[] errLRow = new float[w];
        float[] errARow = new float[w];
        float[] errBRow = new float[w];
        float[] errLNext = new float[w];
        float[] errANext = new float[w];
        float[] errBNext = new float[w];
        float w7 = 0.4375f;
        float w5 = 0.3125f;
        float w3 = 0.1875f;
        float w1 = 0.0625f;
        for (int y = 0; y < h; ++y) {
            float eB;
            float eA;
            float eL;
            int bi;
            byte best;
            float Bok;
            float Aok;
            float L;
            float[] lab0;
            int B0;
            int G0;
            int R0;
            int A0;
            int argb;
            int pos;
            int rowOff = y * w;
            boolean leftToRight = (y & 1) == 0;
            Arrays.fill(errLNext, 0.0f);
            Arrays.fill(errANext, 0.0f);
            Arrays.fill(errBNext, 0.0f);
            if (leftToRight) {
                for (int x = 0; x < w; ++x) {
                    pos = rowOff + x;
                    argb = srcPixels[pos];
                    A0 = argb >>> 24 & 0xFF;
                    R0 = argb >>> 16 & 0xFF;
                    G0 = argb >>> 8 & 0xFF;
                    B0 = argb & 0xFF;
                    if (transparentIndex >= 0 && A0 < 8) {
                        out[pos] = (byte)transparentIndex;
                        continue;
                    }
                    lab0 = OKLabPaletteMapper.srgbToOKLab(R0, G0, B0);
                    L = OKLabPaletteMapper.clamp(lab0[0] + errLRow[x], -0.5f, 1.5f);
                    Aok = OKLabPaletteMapper.clamp(lab0[1] + errARow[x], -1.5f, 1.5f);
                    Bok = OKLabPaletteMapper.clamp(lab0[2] + errBRow[x], -1.5f, 1.5f);
                    out[pos] = best = OKLabPaletteMapper.findNearestOKLabIndex(L, Aok, Bok, A0, pL, pA, pB, paletteInts, 0.015f);
                    bi = best & 0xFF;
                    eL = L - pL[bi];
                    eA = Aok - pA[bi];
                    eB = Bok - pB[bi];
                    if (x + 1 < w) {
                        int n = x + 1;
                        errLRow[n] = errLRow[n] + eL * 0.4375f;
                        int n2 = x + 1;
                        errARow[n2] = errARow[n2] + eA * 0.4375f;
                        int n3 = x + 1;
                        errBRow[n3] = errBRow[n3] + eB * 0.4375f;
                    }
                    if (x - 1 >= 0) {
                        int n = x - 1;
                        errLNext[n] = errLNext[n] + eL * 0.1875f;
                        int n4 = x - 1;
                        errANext[n4] = errANext[n4] + eA * 0.1875f;
                        int n5 = x - 1;
                        errBNext[n5] = errBNext[n5] + eB * 0.1875f;
                    }
                    int n = x;
                    errLNext[n] = errLNext[n] + eL * 0.3125f;
                    int n6 = x;
                    errANext[n6] = errANext[n6] + eA * 0.3125f;
                    int n7 = x;
                    errBNext[n7] = errBNext[n7] + eB * 0.3125f;
                    if (x + 1 >= w) continue;
                    int n8 = x + 1;
                    errLNext[n8] = errLNext[n8] + eL * 0.0625f;
                    int n9 = x + 1;
                    errANext[n9] = errANext[n9] + eA * 0.0625f;
                    int n10 = x + 1;
                    errBNext[n10] = errBNext[n10] + eB * 0.0625f;
                }
            } else {
                for (int xi = w - 1; xi >= 0; --xi) {
                    pos = rowOff + xi;
                    argb = srcPixels[pos];
                    A0 = argb >>> 24 & 0xFF;
                    R0 = argb >>> 16 & 0xFF;
                    G0 = argb >>> 8 & 0xFF;
                    B0 = argb & 0xFF;
                    if (transparentIndex >= 0 && A0 < 8) {
                        out[pos] = (byte)transparentIndex;
                        continue;
                    }
                    lab0 = OKLabPaletteMapper.srgbToOKLab(R0, G0, B0);
                    L = OKLabPaletteMapper.clamp(lab0[0] + errLRow[xi], -0.5f, 1.5f);
                    Aok = OKLabPaletteMapper.clamp(lab0[1] + errARow[xi], -1.5f, 1.5f);
                    Bok = OKLabPaletteMapper.clamp(lab0[2] + errBRow[xi], -1.5f, 1.5f);
                    out[pos] = best = OKLabPaletteMapper.findNearestOKLabIndex(L, Aok, Bok, A0, pL, pA, pB, paletteInts, 0.015f);
                    bi = best & 0xFF;
                    eL = L - pL[bi];
                    eA = Aok - pA[bi];
                    eB = Bok - pB[bi];
                    if (xi - 1 >= 0) {
                        int n = xi - 1;
                        errLRow[n] = errLRow[n] + eL * 0.4375f;
                        int n11 = xi - 1;
                        errARow[n11] = errARow[n11] + eA * 0.4375f;
                        int n12 = xi - 1;
                        errBRow[n12] = errBRow[n12] + eB * 0.4375f;
                    }
                    if (xi + 1 < w) {
                        int n = xi + 1;
                        errLNext[n] = errLNext[n] + eL * 0.1875f;
                        int n13 = xi + 1;
                        errANext[n13] = errANext[n13] + eA * 0.1875f;
                        int n14 = xi + 1;
                        errBNext[n14] = errBNext[n14] + eB * 0.1875f;
                    }
                    int n = xi;
                    errLNext[n] = errLNext[n] + eL * 0.3125f;
                    int n15 = xi;
                    errANext[n15] = errANext[n15] + eA * 0.3125f;
                    int n16 = xi;
                    errBNext[n16] = errBNext[n16] + eB * 0.3125f;
                    if (xi - 1 < 0) continue;
                    int n17 = xi - 1;
                    errLNext[n17] = errLNext[n17] + eL * 0.0625f;
                    int n18 = xi - 1;
                    errANext[n18] = errANext[n18] + eA * 0.0625f;
                    int n19 = xi - 1;
                    errBNext[n19] = errBNext[n19] + eB * 0.0625f;
                }
            }
            float[] tmp = errLRow;
            errLRow = errLNext;
            errLNext = tmp;
            tmp = errARow;
            errARow = errANext;
            errANext = tmp;
            tmp = errBRow;
            errBRow = errBNext;
            errBNext = tmp;
        }
        return dst;
    }

    private static byte findNearestOKLabIndex(float L0, float A0, float B0, int alphaSrc, float[] pL, float[] pA, float[] pB, int[] paletteInts, float alphaWeight) {
        int bestI = 0;
        double bestD = Double.POSITIVE_INFINITY;
        for (int i = 0; i < pL.length; ++i) {
            float dL = L0 - pL[i];
            float dA = A0 - pA[i];
            float dB = B0 - pB[i];
            double dist = dL * dL + dA * dA + dB * dB;
            int pa = paletteInts[i] >>> 24 & 0xFF;
            float da = alphaSrc - pa;
            if (!((dist += (double)(alphaWeight * (da * da))) < bestD)) continue;
            bestD = dist;
            bestI = i;
            if (bestD == 0.0) break;
        }
        return (byte)bestI;
    }

    private static float[] srgbToOKLab(int R, int G, int B) {
        double r = OKLabPaletteMapper.srgbToLinear((double)R / 255.0);
        double g = OKLabPaletteMapper.srgbToLinear((double)G / 255.0);
        double b = OKLabPaletteMapper.srgbToLinear((double)B / 255.0);
        double l = 0.4122214708 * r + 0.5363325363 * g + 0.0514459929 * b;
        double m = 0.2119034982 * r + 0.6806995451 * g + 0.1073969566 * b;
        double s = 0.0883024619 * r + 0.2817188376 * g + 0.6299787005 * b;
        double l_ = Math.cbrt(l);
        double m_ = Math.cbrt(m);
        double s_ = Math.cbrt(s);
        double L = 0.2104542553 * l_ + 0.793617785 * m_ - 0.0040720468 * s_;
        double A = 1.9779984951 * l_ - 2.428592205 * m_ + 0.4505937099 * s_;
        double Bv = 0.0259040371 * l_ + 0.7827717662 * m_ - 0.808675766 * s_;
        return new float[]{(float)L, (float)A, (float)Bv};
    }

    private static double srgbToLinear(double c) {
        return c <= 0.04045 ? c / 12.92 : Math.pow((c + 0.055) / 1.055, 2.4);
    }

    private static float clamp(float v, float lo, float hi) {
        return v < lo ? lo : (v > hi ? hi : v);
    }
}

