/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.contextvars;

import com.oracle.graal.python.lib.PyObjectRichCompareBool;
import com.oracle.truffle.api.CompilerDirectives;

public final class Hamt {
    final TreePart root;

    public String dump() {
        return Hamt.dumpPart(this.root, 0);
    }

    private static String dumpPart(TreePart i, int indent) {
        return i == null ? " ".repeat(indent) + "null\n" : i.dump(indent);
    }

    public int size() {
        return Hamt.computeSize(this.root);
    }

    private static int sumSize(TreePart[] arr) {
        int i = 0;
        for (TreePart el : arr) {
            i += Hamt.computeSize(el);
        }
        return i;
    }

    private static int computeSize(TreePart part) {
        if (part == null) {
            return 0;
        }
        if (part instanceof Entry) {
            return 1;
        }
        if (part instanceof CollisionPart) {
            return Hamt.sumSize(((CollisionPart)part).elems);
        }
        if (part instanceof ArrayPart) {
            return Hamt.sumSize(((ArrayPart)part).elems);
        }
        if (part instanceof BitmapPart) {
            return Hamt.sumSize(((BitmapPart)part).elems);
        }
        throw CompilerDirectives.shouldNotReachHere((String)"TreePart type is not handled");
    }

    public Hamt() {
        this(null);
    }

    private Hamt(TreePart root) {
        this.root = root;
    }

    private static int hashIdx(int hash, int hashShift) {
        return Hamt.hashTail(hash >> hashShift);
    }

    private static int hashTail(int hash) {
        return hash & 0x1F;
    }

    private static int idxToBit(int idx) {
        assert (idx < 32 && idx >= 0) : "invalid bitmap index: " + idx;
        return 1 << idx;
    }

    private static int popcount(int n) {
        return Integer.bitCount(n);
    }

    private static int bitmapToIdx(int bitmap, int position) {
        int shiftedBitmap = bitmap >>> position;
        if ((shiftedBitmap & 1) == 1) {
            return Hamt.popcount(shiftedBitmap) - 1;
        }
        return -1;
    }

    private static BitmapPart bitmapPartsForPair(TreePart one, int hashOne, TreePart two, int hashTwo, int hashShift) {
        TreePart[] treePartArray;
        int twoIdx;
        assert (hashOne != hashTwo) : "cannot work with colliding parts";
        int oneIdx = Hamt.hashIdx(hashOne, hashShift);
        if (oneIdx == (twoIdx = Hamt.hashIdx(hashTwo, hashShift))) {
            return new BitmapPart(new TreePart[]{Hamt.bitmapPartsForPair(one, hashOne, two, hashTwo, hashShift + 5)}, Hamt.idxToBit(twoIdx));
        }
        if (oneIdx > twoIdx) {
            TreePart[] treePartArray2 = new TreePart[2];
            treePartArray2[0] = one;
            treePartArray = treePartArray2;
            treePartArray2[1] = two;
        } else {
            TreePart[] treePartArray3 = new TreePart[2];
            treePartArray3[0] = two;
            treePartArray = treePartArray3;
            treePartArray3[1] = one;
        }
        return new BitmapPart(treePartArray, Hamt.idxToBit(twoIdx) | Hamt.idxToBit(oneIdx));
    }

    @CompilerDirectives.TruffleBoundary
    private static TreePart partWithEntry(TreePart original, Entry newEntry, int hashShift) {
        assert (hashShift <= 25);
        if (original == null) {
            return newEntry;
        }
        if (original instanceof Entry) {
            Entry existing = (Entry)original;
            if (newEntry.hash == existing.hash) {
                if (PyObjectRichCompareBool.executeEqUncached(newEntry.key, existing.key)) {
                    return newEntry;
                }
                return new CollisionPart(existing.hash, existing, newEntry);
            }
            return Hamt.bitmapPartsForPair(newEntry, newEntry.hash, existing, existing.hash, hashShift);
        }
        if (original instanceof BitmapPart) {
            TreePart newPart;
            BitmapPart existing = (BitmapPart)original;
            int position = Hamt.hashIdx(newEntry.hash, hashShift);
            int sparseIdx = Hamt.bitmapToIdx(existing.bitmap, position);
            if (sparseIdx < 0) {
                int originalLength = existing.elems.length;
                if (originalLength >= 15) {
                    TreePart[] newElems = new TreePart[32];
                    newElems[position] = newEntry;
                    int elemsI = originalLength - 1;
                    for (int i = 0; i < 32; ++i) {
                        if ((existing.bitmap >>> i & 1) != 1) continue;
                        newElems[i] = existing.elems[elemsI--];
                    }
                    return new ArrayPart(newElems);
                }
                int newBitmap = existing.bitmap | Hamt.idxToBit(position);
                TreePart[] newElems = new TreePart[existing.elems.length + 1];
                int insertAt = Hamt.bitmapToIdx(newBitmap, position);
                assert (insertAt >= 0);
                int oldI = 0;
                for (int i = 0; i <= originalLength; ++i) {
                    newElems[i] = insertAt == i ? newEntry : existing.elems[oldI++];
                }
                return new BitmapPart(newElems, newBitmap);
            }
            TreePart[] toReplaceIn = (TreePart[])existing.elems.clone();
            TreePart toReplace = toReplaceIn[sparseIdx];
            toReplaceIn[sparseIdx] = newPart = Hamt.partWithEntry(toReplace, newEntry, hashShift + 5);
            return new BitmapPart(toReplaceIn, existing.bitmap);
        }
        if (original instanceof ArrayPart) {
            TreePart newPart;
            ArrayPart existing = (ArrayPart)original;
            int position = Hamt.hashIdx(newEntry.hash, hashShift);
            TreePart[] toReplaceIn = (TreePart[])existing.elems.clone();
            TreePart toReplace = toReplaceIn[position];
            toReplaceIn[position] = newPart = Hamt.partWithEntry(toReplace, newEntry, hashShift + 5);
            return new ArrayPart(toReplaceIn);
        }
        if (original instanceof CollisionPart) {
            CollisionPart existing = (CollisionPart)original;
            if (existing.hash == newEntry.hash) {
                int originalLength = existing.elems.length;
                Entry[] newElems = new Entry[originalLength + 1];
                newElems[originalLength] = newEntry;
                System.arraycopy(existing.elems, 0, newElems, 0, originalLength);
                return new CollisionPart(existing.hash, newElems);
            }
            return Hamt.bitmapPartsForPair(existing, existing.hash, newEntry, newEntry.hash, hashShift);
        }
        throw CompilerDirectives.shouldNotReachHere((String)"TreePart type is not handled");
    }

    public Hamt withEntry(Entry newEntry) {
        return new Hamt(Hamt.partWithEntry(this.root, newEntry, 0));
    }

    @CompilerDirectives.TruffleBoundary
    private static Object lookupKeyInPart(TreePart part, Object key, int hash, int hashShift) {
        assert (hashShift <= 25);
        if (part == null) {
            return null;
        }
        if (part instanceof Entry) {
            Entry existing = (Entry)part;
            if (existing.hash == hash && PyObjectRichCompareBool.executeEqUncached(existing.key, key)) {
                return existing.value;
            }
            return null;
        }
        if (part instanceof BitmapPart) {
            BitmapPart existing = (BitmapPart)part;
            int position = Hamt.hashIdx(hash, hashShift);
            int sparseIdx = Hamt.bitmapToIdx(existing.bitmap, position);
            if (sparseIdx < 0) {
                return null;
            }
            TreePart deeper = existing.elems[sparseIdx];
            return Hamt.lookupKeyInPart(deeper, key, hash, hashShift + 5);
        }
        if (part instanceof ArrayPart) {
            ArrayPart existing = (ArrayPart)part;
            int position = Hamt.hashIdx(hash, hashShift);
            return Hamt.lookupKeyInPart(existing.elems[position], key, hash, hashShift + 5);
        }
        if (part instanceof CollisionPart) {
            CollisionPart existing = (CollisionPart)part;
            if (existing.hash != hash) {
                return null;
            }
            for (Entry entry : existing.elems) {
                if (!PyObjectRichCompareBool.executeEqUncached(entry.key, key)) continue;
                return entry.value;
            }
            return null;
        }
        throw CompilerDirectives.shouldNotReachHere((String)"TreePart type not handled");
    }

    public Object lookup(Object key, int hash) {
        return Hamt.lookupKeyInPart(this.root, key, hash, 0);
    }

    private static TreePart bitmapWithoutKey(BitmapPart existing, Object key, int hash, int hashShift) {
        int otherIdx;
        TreePart otherElem;
        int position = Hamt.hashIdx(hash, hashShift);
        int sparseIdx = Hamt.bitmapToIdx(existing.bitmap, position);
        if (sparseIdx < 0) {
            return existing;
        }
        TreePart replacement = Hamt.partWithoutKey(existing.elems[sparseIdx], key, hash, hashShift + 5);
        int currentLen = existing.elems.length;
        if (currentLen == 1) {
            if (replacement == null) {
                return null;
            }
            if (replacement instanceof Entry || replacement instanceof CollisionPart) {
                return replacement;
            }
        }
        if (currentLen == 2 && replacement == null && ((otherElem = existing.elems[otherIdx = sparseIdx == 0 ? 1 : 0]) instanceof Entry || otherElem instanceof CollisionPart)) {
            return otherElem;
        }
        if (replacement == null) {
            int newBitmap = existing.bitmap & ~Hamt.idxToBit(position);
            TreePart[] newElems = new TreePart[existing.elems.length - 1];
            int newI = 0;
            for (int i = 0; i < existing.elems.length; ++i) {
                if (i == sparseIdx) continue;
                newElems[newI++] = existing.elems[i];
            }
            assert (newI == newElems.length);
            return new BitmapPart(newElems, newBitmap);
        }
        TreePart[] newElems = (TreePart[])existing.elems.clone();
        newElems[sparseIdx] = replacement;
        return new BitmapPart(newElems, existing.bitmap);
    }

    @CompilerDirectives.TruffleBoundary
    private static TreePart partWithoutKey(TreePart root, Object key, int hash, int hashShift) {
        if (root == null) {
            return null;
        }
        if (root instanceof Entry) {
            Entry existing = (Entry)root;
            if (existing.hash == hash && PyObjectRichCompareBool.executeEqUncached(existing.key, key)) {
                return null;
            }
            return root;
        }
        if (root instanceof BitmapPart) {
            BitmapPart existing = (BitmapPart)root;
            return Hamt.bitmapWithoutKey(existing, key, hash, hashShift);
        }
        if (root instanceof ArrayPart) {
            ArrayPart existing = (ArrayPart)root;
            int position = Hamt.hashIdx(hash, hashShift);
            TreePart replacement = Hamt.partWithoutKey(existing.elems[position], key, hash, hashShift + 5);
            if (replacement == null) {
                int bitmap = 0;
                for (int i = 0; i < existing.elems.length; ++i) {
                    if (existing.elems[i] == null || position == i) continue;
                    bitmap |= Hamt.idxToBit(i);
                }
                if (Hamt.popcount(bitmap) < 16) {
                    assert (Hamt.popcount(bitmap) == 15);
                    TreePart[] newElems = new TreePart[15];
                    int newElemsI = 15;
                    for (int i = 0; i < existing.elems.length; ++i) {
                        if (i == position || existing.elems[i] == null) continue;
                        newElems[--newElemsI] = existing.elems[i];
                    }
                    assert (newElemsI == 0);
                    return new BitmapPart(newElems, bitmap);
                }
            }
            TreePart[] newElems = (TreePart[])existing.elems.clone();
            newElems[position] = replacement;
            return new ArrayPart(newElems);
        }
        if (root instanceof CollisionPart) {
            CollisionPart existing = (CollisionPart)root;
            if (existing.hash == hash) {
                for (int i = 0; i < existing.elems.length; ++i) {
                    if (!PyObjectRichCompareBool.executeEqUncached(existing.elems[i].key, key)) continue;
                    if (existing.elems.length == 1) {
                        return null;
                    }
                    int newI = 0;
                    Entry[] newElems = new Entry[existing.elems.length - 1];
                    for (int j = 0; j < existing.elems.length; ++j) {
                        if (j == i) continue;
                        newElems[newI++] = existing.elems[j];
                    }
                    if (newElems.length == 1) {
                        return newElems[0];
                    }
                    return new CollisionPart(hash, newElems);
                }
            }
            return root;
        }
        throw CompilerDirectives.shouldNotReachHere((String)"TreePart type not handled");
    }

    public Hamt without(Object key, int hash) {
        return new Hamt(Hamt.partWithoutKey(this.root, key, hash, 0));
    }

    static interface TreePart {
        public String dump(int var1);
    }

    @CompilerDirectives.ValueType
    public static final class Entry
    implements TreePart {
        public final Object key;
        final int hash;
        public final Object value;

        public Entry(Object key, int hash, Object value) {
            this.key = key;
            this.hash = hash & 0x3FFFFFFF;
            this.value = value;
        }

        @Override
        public String dump(int indent) {
            return " ".repeat(indent) + String.format("%s : %s (%d)\n", this.key, this.value, this.hash);
        }
    }

    static final class CollisionPart
    implements TreePart {
        final int hash;
        final Entry[] elems;

        public CollisionPart(int hash, Entry ... elems) {
            this.hash = hash;
            this.elems = elems;
        }

        @Override
        public String dump(int indent) {
            StringBuilder result = new StringBuilder();
            result.append(" ".repeat(indent));
            result.append("Collision ");
            result.append(this.hash);
            result.append('\n');
            for (Entry i : this.elems) {
                result.append(Hamt.dumpPart(i, indent + 2));
            }
            return result.toString();
        }
    }

    static final class ArrayPart
    implements TreePart {
        final TreePart[] elems;

        public ArrayPart(TreePart[] elems) {
            assert (elems.length == 32);
            this.elems = elems;
        }

        @Override
        public String dump(int indent) {
            StringBuilder result = new StringBuilder();
            result.append(" ".repeat(indent));
            result.append("Array\n");
            for (TreePart i : this.elems) {
                result.append(Hamt.dumpPart(i, indent + 2));
            }
            return result.toString();
        }
    }

    static final class BitmapPart
    implements TreePart {
        final int bitmap;
        final TreePart[] elems;

        public BitmapPart(TreePart[] elems, int bitmap) {
            for (TreePart e : elems) {
                assert (e != null);
            }
            this.elems = elems;
            this.bitmap = bitmap;
        }

        @Override
        public String dump(int indent) {
            StringBuilder result = new StringBuilder();
            result.append(" ".repeat(indent));
            result.append("Bitmap (");
            result.append(Integer.toBinaryString(this.bitmap));
            result.append(")\n");
            for (TreePart i : this.elems) {
                result.append(Hamt.dumpPart(i, indent + 2));
            }
            return result.toString();
        }
    }
}

