/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.exception;

import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.exception.ExceptMatchNodeGen;
import com.oracle.graal.python.nodes.exception.ValidExceptionNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.bytecode.OperationProxy;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;

@ImportStatic(value={PGuards.class})
@GenerateUncached
@OperationProxy.Proxyable
@GenerateInline(value=false)
public abstract class ExceptMatchNode
extends Node {
    public abstract boolean executeMatch(Frame var1, Object var2, Object var3);

    private static void raiseIfNoException(VirtualFrame frame, Node inliningTarget, Object clause, ValidExceptionNode isValidException) {
        if (!isValidException.execute((Frame)frame, clause)) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.TypeError, ErrorMessages.CATCHING_CLS_NOT_ALLOWED);
        }
    }

    @Specialization(guards={"!isPTuple(clause)"})
    public static boolean matchPythonSingle(VirtualFrame frame, PException e, Object clause, @Bind Node inliningTarget, @Cached.Shared @Cached ValidExceptionNode isValidException, @Cached GetClassNode getClassNode, @Cached IsSubtypeNode isSubtype) {
        ExceptMatchNode.raiseIfNoException(frame, inliningTarget, clause, isValidException);
        return isSubtype.execute(getClassNode.execute(inliningTarget, e.getUnreifiedException()), clause);
    }

    @Specialization(guards={"!isPTuple(clause)", "!isPException(e)"}, limit="1")
    public static boolean matchJava(VirtualFrame frame, AbstractTruffleException e, Object clause, @Bind Node inliningTarget, @Cached.Shared @Cached ValidExceptionNode isValidException, @CachedLibrary(value="clause") InteropLibrary clauseLib) {
        ExceptMatchNode.raiseIfNoException(frame, inliningTarget, clause, isValidException);
        if (clauseLib.isMetaObject(clause)) {
            try {
                return clauseLib.isMetaInstance(clause, (Object)e);
            }
            catch (UnsupportedMessageException e1) {
                throw CompilerDirectives.shouldNotReachHere();
            }
        }
        return false;
    }

    @Specialization
    public static boolean matchTuple(VirtualFrame frame, Object e, PTuple clause, @Bind Node inliningTarget, @Cached ExceptMatchNode recursiveNode, @Cached SequenceStorageNodes.GetItemScalarNode getItemNode) {
        SequenceStorage storage = clause.getSequenceStorage();
        int length = storage.length();
        for (int i = 0; i < length; ++i) {
            Object clauseType = getItemNode.execute(inliningTarget, storage, i);
            if (!recursiveNode.executeMatch((Frame)frame, e, clauseType)) continue;
            return true;
        }
        return false;
    }

    @NeverDefault
    public static ExceptMatchNode create() {
        return ExceptMatchNodeGen.create();
    }

    public static ExceptMatchNode getUncached() {
        return ExceptMatchNodeGen.getUncached();
    }
}

