/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.carrot2.util.ResourceLookup;

public class ChainedResourceLookup
implements ResourceLookup {
    private List<ResourceLookup> rls;

    public ChainedResourceLookup(List<ResourceLookup> resourceLookups) {
        this.rls = new ArrayList<ResourceLookup>(resourceLookups);
        if (this.rls.isEmpty()) {
            throw new IllegalArgumentException("At least one chained lookup is required.");
        }
    }

    @Override
    public InputStream open(String resource) throws IOException {
        ResourceLookup rl = this.loaderOf(resource);
        if (rl == null) {
            throw new IOException("Resource does not exist: " + this.pathOf(resource));
        }
        return rl.open(resource);
    }

    @Override
    public boolean exists(String resource) {
        return this.loaderOf(resource) != null;
    }

    @Override
    public String pathOf(String resource) {
        ResourceLookup rl = this.loaderOf(resource);
        if (rl != null) {
            return rl.pathOf(resource);
        }
        return this.rls.stream().map(loader -> loader.pathOf(resource)).collect(Collectors.joining(", "));
    }

    private ResourceLookup loaderOf(String resource) {
        for (ResourceLookup rl : this.rls) {
            if (!rl.exists(resource)) continue;
            return rl;
        }
        return null;
    }
}

